/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.trace.sff.CompletelyParsedIndexedSffFileDataStore;
import org.jcvi.jillion.trace.sff.DefaultSffFileDataStore;
import org.jcvi.jillion.trace.sff.LargeSffFileDataStore;
import org.jcvi.jillion.trace.sff.ManifestIndexed454SffFileDataStore;
import org.jcvi.jillion.trace.sff.SffFileDataStore;

public class SffFileDataStoreBuilder {
    private final File sffFile;
    private DataStoreFilter filter = DataStoreFilters.alwaysAccept();
    private DataStoreProviderHint hint = DataStoreProviderHint.RANDOM_ACCESS_OPTIMIZE_SPEED;

    public SffFileDataStoreBuilder(File sffFile) throws IOException {
        if (sffFile == null) {
            throw new NullPointerException("sff file can not be null");
        }
        if (!sffFile.exists()) {
            throw new FileNotFoundException("sff file must exist");
        }
        if (!sffFile.canRead()) {
            throw new IOException("sff file is not readable");
        }
        this.sffFile = sffFile;
    }

    public SffFileDataStoreBuilder filter(DataStoreFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.filter = filter;
        return this;
    }

    public SffFileDataStoreBuilder hint(DataStoreProviderHint hint) {
        if (hint == null) {
            throw new NullPointerException("hint can not be null");
        }
        this.hint = hint;
        return this;
    }

    public SffFileDataStore build() throws IOException {
        switch (this.hint) {
            case RANDOM_ACCESS_OPTIMIZE_SPEED: {
                return DefaultSffFileDataStore.create(this.sffFile, this.filter);
            }
            case RANDOM_ACCESS_OPTIMIZE_MEMORY: {
                return this.handleIndexedSffFileDataStore();
            }
            case ITERATION_ONLY: {
                return LargeSffFileDataStore.create(this.sffFile, this.filter);
            }
        }
        throw new IllegalArgumentException("unknown provider hint : " + (Object)((Object)this.hint));
    }

    private SffFileDataStore handleIndexedSffFileDataStore() throws IOException {
        SffFileDataStore manifestDataStore = ManifestIndexed454SffFileDataStore.create(this.sffFile, this.filter);
        if (manifestDataStore != null) {
            return manifestDataStore;
        }
        return CompletelyParsedIndexedSffFileDataStore.create(this.sffFile, this.filter);
    }
}

