/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.trace.sff.SffFileDataStore;
import org.jcvi.jillion.trace.sff.SffFlowgram;

final class SffDataStoreBuilder {
    private final NucleotideSequence keySequence;
    private final NucleotideSequence flowSequence;
    private final Map<String, SffFlowgram> map;

    public SffDataStoreBuilder(NucleotideSequence keySequence, NucleotideSequence flowSequence) {
        if (keySequence == null) {
            throw new NullPointerException("key sequence can not be null");
        }
        if (flowSequence == null) {
            throw new NullPointerException("flow sequence can not be null");
        }
        this.map = new LinkedHashMap<String, SffFlowgram>();
        this.keySequence = keySequence;
        this.flowSequence = flowSequence;
    }

    public SffDataStoreBuilder(NucleotideSequence keySequence, NucleotideSequence flowSequence, int initialCapacity) {
        if (keySequence == null) {
            throw new NullPointerException("key sequence can not be null");
        }
        if (flowSequence == null) {
            throw new NullPointerException("flow sequence can not be null");
        }
        this.map = new LinkedHashMap<String, SffFlowgram>(initialCapacity);
        this.keySequence = keySequence;
        this.flowSequence = flowSequence;
    }

    public SffFileDataStore build() {
        return new DefaultSffFileDataStore(this.keySequence, this.flowSequence, DataStore.of(this.map, SffFileDataStore.class));
    }

    public SffDataStoreBuilder addFlowgram(SffFlowgram flowgram) {
        this.map.put(flowgram.getId(), flowgram);
        return this;
    }

    private static final class DefaultSffFileDataStore
    implements SffFileDataStore {
        private final NucleotideSequence keySequence;
        private final NucleotideSequence flowSequence;
        private final DataStore<SffFlowgram> delegate;

        public DefaultSffFileDataStore(NucleotideSequence keySequence, NucleotideSequence flowSequence, DataStore<SffFlowgram> delegate) {
            this.keySequence = keySequence;
            this.flowSequence = flowSequence;
            this.delegate = delegate;
        }

        @Override
        public StreamingIterator<String> idIterator() throws DataStoreException {
            return this.delegate.idIterator();
        }

        @Override
        public SffFlowgram get(String id) throws DataStoreException {
            return this.delegate.get(id);
        }

        @Override
        public boolean contains(String id) throws DataStoreException {
            return this.delegate.contains(id);
        }

        @Override
        public long getNumberOfRecords() throws DataStoreException {
            return this.delegate.getNumberOfRecords();
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public StreamingIterator<SffFlowgram> iterator() throws DataStoreException {
            return this.delegate.iterator();
        }

        @Override
        public StreamingIterator<DataStoreEntry<SffFlowgram>> entryIterator() throws DataStoreException {
            return this.delegate.entryIterator();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public final NucleotideSequence getKeySequence() {
            return this.keySequence;
        }

        @Override
        public final NucleotideSequence getFlowSequence() {
            return this.flowSequence;
        }
    }
}

