/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.internal.core.util.Validator;

public final class Sff454NameUtil {
    private static final Pattern UNIVERSAL_ACCCESSION_NUM_PATTERN = Pattern.compile("^([A-Z0-9]{7}\\d\\d[A-Z0-9]{5})\\S*$");
    private static final Predicate<String> STRING_NOT_EMPTY = s -> !s.isEmpty();

    private Sff454NameUtil() {
    }

    public static boolean is454Read(String readId) {
        Matcher matcher = UNIVERSAL_ACCCESSION_NUM_PATTERN.matcher(readId);
        return matcher.matches();
    }

    public static String parseUniversalAccessionNumberFrom(String readId) {
        Matcher matcher = UNIVERSAL_ACCCESSION_NUM_PATTERN.matcher(readId);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("not a valid 454 read id: " + readId);
    }

    public static String computeRigRunName(Date date, String rigName, String username, String uniqueRunName) {
        if (date == null) {
            throw new NullPointerException("date can not be null");
        }
        Validator.validate(username, STRING_NOT_EMPTY, u -> "username is empty");
        Validator.validate(uniqueRunName, STRING_NOT_EMPTY, u -> "unique run is empty");
        LocalDateTime datetime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return String.format("R_%04d_%02d_%02d_%02d_%02d_%02d_%s_%s_%s", datetime.getYear(), datetime.getMonthValue(), datetime.getDayOfMonth(), datetime.getHour(), datetime.getMinute(), datetime.getSecond(), rigName, username, uniqueRunName);
    }

    public static String generateAccessionNumberFor(String rigRunName, int regionNumber, Location wellLocation) {
        if (rigRunName == null) {
            throw new NullPointerException("rigRunName can not be null");
        }
        if (wellLocation == null) {
            throw new NullPointerException("wellLocation can not be null");
        }
        if (regionNumber < 0 || regionNumber > 99) {
            throw new IllegalArgumentException("region number must be >=0 and <=99 : " + regionNumber);
        }
        RigRun rigRun = new RigRun(rigRunName);
        Date dateOfRigRun = rigRun.getDate();
        BigInteger encodedDate = DateEncoder.INSTANCE.encode(dateOfRigRun);
        return Base36Encoder.INSTANCE.encode(encodedDate) + rigRun.getRandomizingHashcode() + String.format("%02d", regionNumber) + wellLocation.encode();
    }

    public static Date getDateOfRun(String readId) {
        if (!Sff454NameUtil.is454Read(readId)) {
            throw new IllegalArgumentException(readId + " is not a 454 read");
        }
        String substring = readId.substring(0, 6);
        BigInteger timeStamp = Base36Encoder.INSTANCE.decode(substring);
        return DateEncoder.INSTANCE.decode(timeStamp);
    }

    public static int getRegionNumber(String readId) {
        if (!Sff454NameUtil.is454Read(readId)) {
            throw new IllegalArgumentException(readId + " is not a 454 read");
        }
        String substring = readId.substring(7, 9);
        return Integer.parseInt(substring);
    }

    public static Location parseLocationOf(String readId) {
        if (!Sff454NameUtil.is454Read(readId)) {
            throw new IllegalArgumentException(readId + " is not a 454 read");
        }
        String subString = readId.substring(9, 14);
        return Location.decode(subString);
    }

    private static final class RigRun {
        private static final Pattern RIG_RUN_NAME_PATTERN = Pattern.compile("^R_(\\d+)_(\\d+)_(\\d+)_(\\d+)_(\\d+)_(\\d+)_.+");
        private final Date dateOfRun;
        private final char hash;

        private RigRun(String rigRunName) {
            this.dateOfRun = this.parseDateFrom(rigRunName);
            this.hash = this.generate454Hash(rigRunName);
        }

        Date getDate() {
            return this.dateOfRun;
        }

        char getRandomizingHashcode() {
            return this.hash;
        }

        private Date parseDateFrom(String rigRunName) {
            Matcher matcher = RIG_RUN_NAME_PATTERN.matcher(rigRunName);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("invalid rigRunName: " + rigRunName);
            }
            return new GregorianCalendar(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6))).getTime();
        }

        private char generate454Hash(String rigRunName) {
            int hash = 0;
            for (char c : rigRunName.toCharArray()) {
                hash += c;
                hash %= 31;
            }
            return Base36Encoder.INSTANCE.encode(hash).charAt(0);
        }
    }

    private static enum DateEncoder {
        INSTANCE;

        private static final BigInteger SIXTY;
        private static final BigInteger TWENTY_FOUR;
        private static final BigInteger THIRTEEN;
        private static final BigInteger THIRTY_TWO;
        private static final BigInteger MINUTE_MASK;
        private static final BigInteger HOUR_MASK;
        private static final BigInteger DAY_MASK;
        private static final BigInteger MONTH_MASK;
        private static final BigInteger YEAR_MASK;

        BigInteger encode(Date timestampOfRun) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timestampOfRun);
            BigInteger year = BigInteger.valueOf(calendar.get(1) - 2000);
            BigInteger month = BigInteger.valueOf(calendar.get(2));
            BigInteger day = BigInteger.valueOf(calendar.get(5));
            BigInteger hour = BigInteger.valueOf(calendar.get(11));
            BigInteger minute = BigInteger.valueOf(calendar.get(12));
            BigInteger second = BigInteger.valueOf(calendar.get(13));
            return YEAR_MASK.multiply(year).add(MONTH_MASK.multiply(month)).add(DAY_MASK.multiply(day)).add(HOUR_MASK.multiply(hour)).add(MINUTE_MASK.multiply(minute)).add(second);
        }

        Date decode(BigInteger timestamp) {
            BigInteger current = timestamp;
            BigInteger year = current.divide(YEAR_MASK);
            current = current.mod(YEAR_MASK);
            BigInteger month = current.divide(MONTH_MASK);
            current = current.mod(MONTH_MASK);
            BigInteger dayOfMonth = current.divide(DAY_MASK);
            current = current.mod(DAY_MASK);
            BigInteger hourOfDay = current.divide(HOUR_MASK);
            current = current.mod(HOUR_MASK);
            BigInteger minute = current.divide(MINUTE_MASK);
            BigInteger second = current = current.mod(MINUTE_MASK);
            return new GregorianCalendar(year.intValue() + 2000, month.intValue() - 1, dayOfMonth.intValue(), hourOfDay.intValue(), minute.intValue(), second.intValue()).getTime();
        }

        static {
            SIXTY = BigInteger.valueOf(60L);
            TWENTY_FOUR = BigInteger.valueOf(24L);
            THIRTEEN = BigInteger.valueOf(13L);
            THIRTY_TWO = BigInteger.valueOf(32L);
            MINUTE_MASK = SIXTY;
            HOUR_MASK = MINUTE_MASK.multiply(SIXTY);
            DAY_MASK = HOUR_MASK.multiply(TWENTY_FOUR);
            MONTH_MASK = DAY_MASK.multiply(THIRTY_TWO);
            YEAR_MASK = MONTH_MASK.multiply(THIRTEEN);
        }
    }

    private static enum Base36Encoder {
        INSTANCE;


        BigInteger decode(String encodedString) {
            StringBuilder decodedBuilder = new StringBuilder();
            for (char c : encodedString.toCharArray()) {
                int value = Character.isDigit(c) ? Integer.parseInt(Character.toString(c)) + 26 : c - 65;
                if (value < 10) {
                    decodedBuilder.append(value);
                    continue;
                }
                decodedBuilder.append((char)(value - 10 + 65));
            }
            return new BigInteger(decodedBuilder.toString(), 36);
        }

        String encode(long value) {
            return this.encode(BigInteger.valueOf(value));
        }

        String encode(BigInteger value) {
            String base36EncodedString = value.toString(36).toUpperCase(Locale.ENGLISH);
            StringBuilder x454EncodedBase36Builder = new StringBuilder();
            char[] cArray = base36EncodedString.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                int offset = Integer.parseInt(c.toString(), 36);
                if (offset < 26) {
                    x454EncodedBase36Builder.append((char)(offset + 65));
                    continue;
                }
                x454EncodedBase36Builder.append((char)(48 + (offset - 26)));
            }
            return x454EncodedBase36Builder.toString();
        }
    }

    public static final class Location {
        private final int x;
        private final int y;
        private static final BigInteger FOURTY_NINETY_SIX = BigInteger.valueOf(4096L);

        public Location(int x, int y) {
            if (x < 0) {
                throw new IllegalArgumentException("x coordinate can not be negative");
            }
            if (y < 0) {
                throw new IllegalArgumentException("y coordinate can not be negative");
            }
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        private String encode() {
            String encoded = Base36Encoder.INSTANCE.encode(BigInteger.valueOf((long)this.x * 4096L + (long)this.y));
            if (encoded.length() == 5) {
                return encoded;
            }
            if (encoded.length() > 5) {
                return encoded.substring(encoded.length() - 5);
            }
            int numToPadd = 5 - encoded.length();
            StringBuilder builder = new StringBuilder(5);
            for (int i = 0; i < numToPadd; ++i) {
                builder.append('A');
            }
            builder.append(encoded);
            return builder.toString();
        }

        private static Location decode(String encodedLocation) {
            BigInteger value = Base36Encoder.INSTANCE.decode(encodedLocation);
            BigInteger x = value.divide(FOURTY_NINETY_SIX);
            BigInteger y = value.mod(FOURTY_NINETY_SIX);
            return new Location(x.intValue(), y.intValue());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Location)) {
                return false;
            }
            Location other = (Location)obj;
            if (this.x != other.x) {
                return false;
            }
            return this.y == other.y;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(30);
            builder.append("Location [x=").append(this.x).append(", y=").append(this.y).append(']');
            return builder.toString();
        }
    }
}

