/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;
import org.jcvi.jillion.trace.sff.DefaultSffReadDataDecoder;
import org.jcvi.jillion.trace.sff.DefaultSffReadHeaderDecoder;
import org.jcvi.jillion.trace.sff.LargeSffFileDataStore;
import org.jcvi.jillion.trace.sff.SffCommonHeader;
import org.jcvi.jillion.trace.sff.SffFileDataStore;
import org.jcvi.jillion.trace.sff.SffFileParser;
import org.jcvi.jillion.trace.sff.SffFileReadVisitor;
import org.jcvi.jillion.trace.sff.SffFlowgram;
import org.jcvi.jillion.trace.sff.SffFlowgramImpl;
import org.jcvi.jillion.trace.sff.SffReadData;
import org.jcvi.jillion.trace.sff.SffReadHeader;
import org.jcvi.jillion.trace.sff.SffUtil;
import org.jcvi.jillion.trace.sff.SffVisitor;
import org.jcvi.jillion.trace.sff.SffVisitorCallback;

final class ManifestIndexed454SffFileDataStore
implements SffFileDataStore {
    private final RandomAccessFile randomAccessFile;
    private final File sffFile;
    private final SffCommonHeader commonHeader;
    private final Map<String, Integer> map;
    private boolean isClosed = false;
    private final DataStoreFilter filter;

    public static SffFileDataStore create(File sffFile) throws IOException {
        return ManifestIndexed454SffFileDataStore.create(sffFile, DataStoreFilters.alwaysAccept());
    }

    public static SffFileDataStore create(File sffFile, DataStoreFilter filter) throws IOException {
        ManifestCreatorVisitor visitor = new ManifestCreatorVisitor(sffFile, filter);
        SffFileParser.create(sffFile).parse(visitor);
        if (visitor.isUseableManifest()) {
            return new ManifestIndexed454SffFileDataStore(visitor);
        }
        return null;
    }

    private ManifestIndexed454SffFileDataStore(ManifestCreatorVisitor visitor) throws FileNotFoundException {
        this.map = visitor.map;
        this.sffFile = visitor.sffFile;
        this.randomAccessFile = new RandomAccessFile(visitor.sffFile, "r");
        this.commonHeader = visitor.commonHeader;
        this.filter = visitor.filter;
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        this.throwErrorIfClosed();
        try {
            return DataStoreStreamingIterator.create(this, LargeSffFileDataStore.create(this.sffFile, this.filter).idIterator());
        }
        catch (IOException e) {
            throw new IllegalStateException("sff file has been deleted", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SffFlowgram get(String id) throws DataStoreException {
        SffFlowgram sffFlowgram;
        this.throwErrorIfClosed();
        Long offset = this.getOffsetFor(id);
        if (offset == null) {
            return null;
        }
        BufferedInputStream in = null;
        try {
            RandomAccessFile randomAccessFile = this.randomAccessFile;
            synchronized (randomAccessFile) {
                this.randomAccessFile.seek(offset);
                in = new BufferedInputStream(new RandomAccessFileInputStream(this.randomAccessFile));
                DataInputStream dataIn = new DataInputStream(in);
                SffReadHeader readHeader = DefaultSffReadHeaderDecoder.INSTANCE.decodeReadHeader(dataIn);
                int numberOfBases = readHeader.getNumberOfBases();
                SffReadData readData = DefaultSffReadDataDecoder.INSTANCE.decode(dataIn, this.commonHeader.getNumberOfFlowsPerRead(), numberOfBases);
                sffFlowgram = SffFlowgramImpl.create(readHeader, readData);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(in);
            throw throwable;
        }
        {
            catch (IOException e) {
                throw new DataStoreException("error trying to get flowgram " + id, e);
            }
        }
        IOUtil.closeAndIgnoreErrors((Closeable)in);
        return sffFlowgram;
    }

    private Long getOffsetFor(String id) {
        Integer offset = this.map.get(id);
        if (offset == null) {
            return null;
        }
        return IOUtil.toUnsignedInt(offset);
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        this.throwErrorIfClosed();
        return this.map.containsKey(id);
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        this.throwErrorIfClosed();
        return this.map.size();
    }

    @Override
    public NucleotideSequence getKeySequence() {
        this.throwErrorIfClosed();
        return this.commonHeader.getKeySequence();
    }

    @Override
    public NucleotideSequence getFlowSequence() {
        this.throwErrorIfClosed();
        return this.commonHeader.getFlowSequence();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public StreamingIterator<SffFlowgram> iterator() throws DataStoreException {
        this.throwErrorIfClosed();
        try {
            return DataStoreStreamingIterator.create(this, LargeSffFileDataStore.create(this.sffFile, this.filter).iterator());
        }
        catch (IOException e) {
            throw new DataStoreException("sff file has been deleted?", e);
        }
    }

    @Override
    public StreamingIterator<DataStoreEntry<SffFlowgram>> entryIterator() throws DataStoreException {
        this.throwErrorIfClosed();
        try {
            return DataStoreStreamingIterator.create(this, LargeSffFileDataStore.create(this.sffFile, this.filter).entryIterator());
        }
        catch (IOException e) {
            throw new DataStoreException("sff file has been deleted?", e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.map.clear();
        this.randomAccessFile.close();
    }

    private synchronized void throwErrorIfClosed() {
        if (this.isClosed) {
            throw new DataStoreClosedException("closed");
        }
    }

    private static final class ManifestCreatorVisitor
    implements SffVisitor {
        private static final int INITIAL_NAME_SIZE = 14;
        private final File sffFile;
        private SffCommonHeader commonHeader;
        private Map<String, Integer> map;
        private boolean useableManifest = false;
        private final DataStoreFilter filter;

        private ManifestCreatorVisitor(File sffFile, DataStoreFilter filter) {
            this.sffFile = sffFile;
            this.filter = filter;
        }

        public boolean isUseableManifest() {
            return this.useableManifest;
        }

        @Override
        public void visitHeader(SffVisitorCallback callback, SffCommonHeader header) {
            this.commonHeader = header;
            BigInteger offsetToIndex = this.commonHeader.getIndexOffset();
            if (offsetToIndex.longValue() != 0L) {
                this.tryToParseManifest(offsetToIndex);
            }
            callback.haltParsing();
        }

        @Override
        public SffFileReadVisitor visitRead(SffVisitorCallback callback, SffReadHeader readHeader) {
            return null;
        }

        @Override
        public void end() {
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void tryToParseManifest(BigInteger offsetToIndex) {
            BufferedInputStream in = null;
            try {
                String versionString;
                byte[] version;
                in = new BufferedInputStream(new RandomAccessFileInputStream(this.sffFile, offsetToIndex.longValue()));
                byte[] magicNumber = new byte[4];
                IOUtil.blockingRead(in, magicNumber);
                if (Arrays.equals(magicNumber, ".mft".getBytes(IOUtil.UTF_8))) {
                    version = new byte[4];
                    IOUtil.blockingRead(in, version);
                    versionString = new String(version, IOUtil.UTF_8);
                    if (!"1.00".equals(versionString)) {
                        throw new IOException("unsupported xml manifest version : " + versionString);
                    }
                    long xmlLength = IOUtil.readUnsignedInt(in);
                    IOUtil.blockingSkip(in, 4L + xmlLength);
                    this.populateOffsetMap(in);
                    this.useableManifest = true;
                }
                if (Arrays.equals(magicNumber, ".srt".getBytes(IOUtil.UTF_8))) {
                    version = new byte[4];
                    IOUtil.blockingRead(in, version);
                    versionString = new String(version, IOUtil.UTF_8);
                    if (!"1.00".equals(versionString)) {
                        throw new IOException("unsupported sorted manifest version : " + versionString);
                    }
                    this.populateOffsetMap(in);
                    this.useableManifest = true;
                }
            }
            catch (FileNotFoundException e1) {
                try {
                    throw new RuntimeException("the sff file no longer exists", e1);
                    catch (IOException e) {
                        throw new RuntimeException("error parsing manifest", e);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeAndIgnoreErrors(in);
                    throw throwable;
                }
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }

        private void populateOffsetMap(InputStream in) throws IOException {
            int mapSize = MapUtil.computeMinHashMapSizeWithoutRehashing(this.commonHeader.getNumberOfReads());
            this.map = new HashMap<String, Integer>(mapSize);
            for (long i = 0L; i < this.commonHeader.getNumberOfReads(); ++i) {
                String id = this.parseNextId(in);
                if (id == null) {
                    throw new IOException(String.format("incomplete index in sff file; missing %d reads", this.commonHeader.getNumberOfReads() - i));
                }
                byte[] index = new byte[4];
                IOUtil.blockingRead(in, index);
                if (this.filter.accept(id)) {
                    long offset = SffUtil.parseSffIndexOffsetValue(index);
                    this.map.put(id, IOUtil.toSignedInt(offset));
                }
                in.read();
            }
        }

        private String parseNextId(InputStream in) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream(14);
            byte nextByte = (byte)in.read();
            if (nextByte == -1) {
                return null;
            }
            do {
                out.write(nextByte);
            } while ((nextByte = (byte)in.read()) != 0);
            return new String(out.toByteArray(), IOUtil.UTF_8);
        }
    }
}

