/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.AbstractDataStore;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;
import org.jcvi.jillion.trace.sff.DefaultSFFCommonHeaderDecoder;
import org.jcvi.jillion.trace.sff.SffCommonHeader;
import org.jcvi.jillion.trace.sff.SffFileDataStore;
import org.jcvi.jillion.trace.sff.SffFileIterator;
import org.jcvi.jillion.trace.sff.SffFileParser;
import org.jcvi.jillion.trace.sff.SffFileReadVisitor;
import org.jcvi.jillion.trace.sff.SffFlowgram;
import org.jcvi.jillion.trace.sff.SffFlowgramImpl;
import org.jcvi.jillion.trace.sff.SffParser;
import org.jcvi.jillion.trace.sff.SffReadData;
import org.jcvi.jillion.trace.sff.SffReadHeader;
import org.jcvi.jillion.trace.sff.SffVisitor;
import org.jcvi.jillion.trace.sff.SffVisitorCallback;

final class LargeSffFileDataStore
extends AbstractDataStore<SffFlowgram>
implements SffFileDataStore {
    private final File sffFile;
    private Long size = null;
    private final DataStoreFilter filter;
    private final NucleotideSequence keySequence;
    private final NucleotideSequence flowSequence;

    public static SffFileDataStore create(File sffFile) throws IOException {
        return LargeSffFileDataStore.create(sffFile, DataStoreFilters.alwaysAccept());
    }

    public static SffFileDataStore create(File sffFile, DataStoreFilter filter) throws IOException {
        LargeSffFileDataStore.verifyFileExists(sffFile);
        LargeSffFileDataStore.verifyIsValidSff(sffFile);
        return new LargeSffFileDataStore(sffFile, filter);
    }

    private static void verifyFileExists(File sffFile) throws FileNotFoundException {
        if (sffFile == null) {
            throw new NullPointerException("file can not be null");
        }
        if (!sffFile.exists()) {
            throw new FileNotFoundException("sff file does not exist");
        }
    }

    private static void verifyIsValidSff(File f) throws IOException {
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
            DefaultSFFCommonHeaderDecoder.INSTANCE.decodeHeader(in);
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(in);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)in);
    }

    private LargeSffFileDataStore(File sffFile, DataStoreFilter filter) throws FileNotFoundException, IOException {
        SffParser parser = SffFileParser.create(sffFile);
        this.sffFile = sffFile;
        this.filter = filter;
        HeaderVisitor visitor = new HeaderVisitor();
        parser.parse(visitor);
        SffCommonHeader header = visitor.getHeader();
        if (header == null) {
            throw new IOException("could not parse sff header");
        }
        this.keySequence = header.getKeySequence();
        this.flowSequence = header.getFlowSequence();
    }

    @Override
    public NucleotideSequence getKeySequence() {
        return this.keySequence;
    }

    @Override
    public NucleotideSequence getFlowSequence() {
        return this.flowSequence;
    }

    @Override
    protected boolean containsImpl(String id) throws DataStoreException {
        return this.get(id) != null;
    }

    @Override
    protected SffFlowgram getImpl(String id) throws DataStoreException {
        if (!this.filter.accept(id)) {
            return null;
        }
        try {
            SingleFlowgramVisitor singleVisitor = new SingleFlowgramVisitor(id);
            SffFileParser.create(this.sffFile).parse(singleVisitor);
            return singleVisitor.getFlowgram();
        }
        catch (IOException e) {
            throw new DataStoreException("could not read sffFile ", e);
        }
    }

    @Override
    protected synchronized long getNumberOfRecordsImpl() throws DataStoreException {
        if (this.size == null) {
            StreamingIterator iter = null;
            try {
                iter = this.iterator();
                long count = 0L;
                while (iter.hasNext()) {
                    iter.next();
                    ++count;
                }
                this.size = count;
            }
            catch (Exception e) {
                throw new DataStoreException("could not parse sffFile ", e);
            }
            finally {
                IOUtil.closeAndIgnoreErrors(iter);
            }
        }
        return this.size;
    }

    @Override
    protected StreamingIterator<String> idIteratorImpl() throws DataStoreException {
        SffFileIdIterator iter = SffFileIdIterator.createNewIteratorFor(this.sffFile, this.filter);
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    protected StreamingIterator<SffFlowgram> iteratorImpl() throws DataStoreException {
        return DataStoreStreamingIterator.create(this, SffFileIterator.createNewIteratorFor(this.sffFile, this.filter));
    }

    @Override
    protected StreamingIterator<DataStoreEntry<SffFlowgram>> entryIteratorImpl() throws DataStoreException {
        StreamingIterator<DataStoreEntry<SffFlowgram>> iter = new StreamingIterator<DataStoreEntry<SffFlowgram>>(){
            StreamingIterator<SffFlowgram> flowgramIter;
            {
                this.flowgramIter = SffFileIterator.createNewIteratorFor(LargeSffFileDataStore.this.sffFile, LargeSffFileDataStore.this.filter);
            }

            @Override
            public boolean hasNext() {
                return this.flowgramIter.hasNext();
            }

            @Override
            public void close() {
                this.flowgramIter.close();
            }

            @Override
            public DataStoreEntry<SffFlowgram> next() {
                SffFlowgram flowgram = this.flowgramIter.next();
                return new DataStoreEntry<SffFlowgram>(flowgram.getId(), flowgram);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    protected void handleClose() throws IOException {
    }

    private static final class HeaderVisitor
    implements SffVisitor {
        private SffCommonHeader header;

        private HeaderVisitor() {
        }

        @Override
        public SffFileReadVisitor visitRead(SffVisitorCallback callback, SffReadHeader readHeader) {
            return null;
        }

        @Override
        public void visitHeader(SffVisitorCallback callback, SffCommonHeader header) {
            this.header = header;
            callback.haltParsing();
        }

        @Override
        public void end() {
        }

        public final SffCommonHeader getHeader() {
            return this.header;
        }
    }

    private static final class SingleFlowgramVisitor
    implements SffVisitor {
        private final String idToFind;
        private SffFlowgram flowgram = null;

        private SingleFlowgramVisitor(String idToFind) {
            this.idToFind = idToFind;
        }

        public SffFlowgram getFlowgram() {
            return this.flowgram;
        }

        @Override
        public void visitHeader(SffVisitorCallback callback, SffCommonHeader header) {
        }

        @Override
        public SffFileReadVisitor visitRead(final SffVisitorCallback callback, final SffReadHeader readHeader) {
            if (readHeader.getId().equals(this.idToFind)) {
                return new SffFileReadVisitor(){

                    @Override
                    public void visitReadData(SffReadData readData) {
                        flowgram = SffFlowgramImpl.create(readHeader, readData);
                    }

                    @Override
                    public void visitEnd() {
                        callback.haltParsing();
                    }
                };
            }
            return null;
        }

        @Override
        public void end() {
        }
    }

    private static final class SffFileIdIterator
    extends AbstractBlockingStreamingIterator<String> {
        private final File sffFile;
        private final DataStoreFilter filter;

        public static SffFileIdIterator createNewIteratorFor(File sffFile, DataStoreFilter filter) {
            SffFileIdIterator iter = new SffFileIdIterator(sffFile, filter);
            iter.start();
            return iter;
        }

        private SffFileIdIterator(File sffFile, DataStoreFilter filter) {
            this.sffFile = sffFile;
            this.filter = filter;
        }

        @Override
        protected void backgroundThreadRunMethod() {
            try {
                SffVisitor visitor = new SffVisitor(){

                    @Override
                    public void visitHeader(SffVisitorCallback callback, SffCommonHeader header) {
                    }

                    @Override
                    public SffFileReadVisitor visitRead(SffVisitorCallback callback, SffReadHeader readHeader) {
                        String readId = readHeader.getId();
                        if (filter.accept(readId)) {
                            this.blockingPut(readId);
                        }
                        return null;
                    }

                    @Override
                    public void end() {
                    }
                };
                SffFileParser.create(this.sffFile).parse(visitor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

