/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.trace.sff.DefaultSffReadHeader;
import org.jcvi.jillion.trace.sff.SffDecoderException;
import org.jcvi.jillion.trace.sff.SffReadHeader;
import org.jcvi.jillion.trace.sff.SffReadHeaderDecoder;
import org.jcvi.jillion.trace.sff.SffUtil;

enum DefaultSffReadHeaderDecoder implements SffReadHeaderDecoder
{
    INSTANCE;

    private static final int FIXED_PORTION_HEADER_LENGTH = 16;

    @Override
    public SffReadHeader decodeReadHeader(DataInputStream in) throws SffDecoderException {
        try {
            short headerLength = in.readShort();
            short nameLegnth = in.readShort();
            int numBases = in.readInt();
            short qualLeft = in.readShort();
            short qualRight = in.readShort();
            short adapterLeft = in.readShort();
            short adapterRight = in.readShort();
            String name = this.readSequenceName(in, nameLegnth);
            int bytesReadSoFar = 16 + nameLegnth;
            int padding = SffUtil.caclulatePaddedBytes(bytesReadSoFar);
            if (headerLength != bytesReadSoFar + padding) {
                throw new SffDecoderException("invalid header length");
            }
            IOUtil.blockingSkip(in, padding);
            return this.createNewHeader(numBases, qualLeft, qualRight, adapterLeft, adapterRight, name);
        }
        catch (IOException e) {
            throw new SffDecoderException("error trying to decode read header", e);
        }
    }

    @Override
    public SffReadHeader decodeReadHeader(ByteBuffer buf) throws SffDecoderException {
        try {
            short headerLength = buf.getShort();
            short nameLegnth = buf.getShort();
            int numBases = buf.getInt();
            short qualLeft = buf.getShort();
            short qualRight = buf.getShort();
            short adapterLeft = buf.getShort();
            short adapterRight = buf.getShort();
            String name = this.readSequenceName(buf, (int)nameLegnth);
            int bytesReadSoFar = 16 + nameLegnth;
            int padding = SffUtil.caclulatePaddedBytes(bytesReadSoFar);
            if (headerLength != bytesReadSoFar + padding) {
                throw new SffDecoderException("invalid header length");
            }
            buf.position(padding + buf.position());
            return this.createNewHeader(numBases, qualLeft, qualRight, adapterLeft, adapterRight, name);
        }
        catch (IOException e) {
            throw new SffDecoderException("error trying to decode read header", e);
        }
    }

    public SffReadHeader createNewHeader(int numBases, short qualLeft, short qualRight, short adapterLeft, short adapterRight, String name) {
        Range qualityClip = qualLeft == 0 ? Range.of(Range.CoordinateSystem.RESIDUE_BASED, 0L, 0L) : (qualRight == 0 ? new Range.Builder(numBases).contractBegin(qualLeft - 1).build() : Range.of(Range.CoordinateSystem.RESIDUE_BASED, qualLeft, qualRight));
        Range adapterClip = adapterLeft == 0 ? Range.of(Range.CoordinateSystem.RESIDUE_BASED, 0L, 0L) : (adapterRight == 0 ? new Range.Builder(numBases).contractBegin(adapterLeft - 1).build() : Range.of(Range.CoordinateSystem.RESIDUE_BASED, adapterLeft, adapterRight));
        return new DefaultSffReadHeader(numBases, qualityClip, adapterClip, name);
    }

    private String readSequenceName(DataInputStream in, short length) throws IOException {
        byte[] name = new byte[length];
        try {
            IOUtil.blockingRead(in, name);
        }
        catch (IOException e) {
            throw new SffDecoderException("error decoding seq name", e);
        }
        return new String(name, IOUtil.UTF_8);
    }

    private String readSequenceName(ByteBuffer buf, int length) throws IOException {
        byte[] name = new byte[length];
        try {
            buf.get(name);
        }
        catch (BufferUnderflowException e) {
            throw new SffDecoderException("error decoding seq name", e);
        }
        return new String(name, IOUtil.UTF_8);
    }
}

