/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.util.ObjectsUtil;
import org.jcvi.jillion.trace.sff.SffReadHeader;

final class DefaultSffReadHeader
implements SffReadHeader {
    private final int numberOfBases;
    private final Range qualityClip;
    private final Range adapterClip;
    private final String name;

    public DefaultSffReadHeader(int numberOfBases, Range qualityClip, Range adapterClip, String name) {
        this.numberOfBases = numberOfBases;
        this.qualityClip = qualityClip;
        this.adapterClip = adapterClip;
        this.name = name;
    }

    @Override
    public Range getAdapterClip() {
        return this.adapterClip;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public int getNumberOfBases() {
        return this.numberOfBases;
    }

    @Override
    public Range getQualityClip() {
        return this.qualityClip;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.numberOfBases;
        result = 31 * result + (this.qualityClip == null ? 0 : this.qualityClip.hashCode());
        result = 31 * result + (this.adapterClip == null ? 0 : this.adapterClip.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultSffReadHeader)) {
            return false;
        }
        DefaultSffReadHeader other = (DefaultSffReadHeader)obj;
        return ObjectsUtil.nullSafeEquals(this.getId(), other.getId()) && ObjectsUtil.nullSafeEquals(this.getNumberOfBases(), other.getNumberOfBases()) && ObjectsUtil.nullSafeEquals(this.getAdapterClip(), other.getAdapterClip()) && ObjectsUtil.nullSafeEquals(this.getQualityClip(), other.getQualityClip());
    }

    public static class Builder
    implements org.jcvi.jillion.core.util.Builder<DefaultSffReadHeader> {
        private final int numberOfBases;
        private Range qualityClip;
        private final Range adapterClip;
        private final String name;

        public Builder(SffReadHeader header) {
            this.numberOfBases = header.getNumberOfBases();
            this.qualityClip = header.getQualityClip();
            this.adapterClip = header.getAdapterClip();
            this.name = header.getId();
        }

        public Builder qualityClip(Range clip) {
            this.qualityClip = clip;
            return this;
        }

        @Override
        public DefaultSffReadHeader build() {
            return new DefaultSffReadHeader(this.numberOfBases, this.qualityClip, this.adapterClip, this.name);
        }
    }
}

