/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.trace.sff.DefaultSffReadData;
import org.jcvi.jillion.trace.sff.SffDecoderException;
import org.jcvi.jillion.trace.sff.SffReadData;
import org.jcvi.jillion.trace.sff.SffReadDataDecoder;
import org.jcvi.jillion.trace.sff.SffUtil;

enum DefaultSffReadDataDecoder implements SffReadDataDecoder
{
    INSTANCE;


    @Override
    public SffReadData decode(DataInputStream in, int numberOfFlows, int numberOfBases) throws SffDecoderException {
        try {
            short[] values = IOUtil.readShortArray(in, numberOfFlows);
            byte[] indexes = IOUtil.toByteArray(in, numberOfBases);
            NucleotideSequence bases = new NucleotideSequenceBuilder().append(new String(IOUtil.toByteArray(in, numberOfBases), IOUtil.UTF_8)).build();
            QualitySequence qualities = new QualitySequenceBuilder(IOUtil.toByteArray(in, numberOfBases)).build();
            int readDataLength = SffUtil.getReadDataLength(numberOfFlows, numberOfBases);
            int padding = SffUtil.caclulatePaddedBytes(readDataLength);
            IOUtil.blockingSkip(in, padding);
            return new DefaultSffReadData(bases, indexes, values, qualities);
        }
        catch (IOException e) {
            throw new SffDecoderException("error decoding read data", e);
        }
    }

    @Override
    public SffReadData decode(ByteBuffer in, int numberOfFlows, int numberOfBases) throws SffDecoderException {
        try {
            short[] values = new short[numberOfFlows];
            in.asShortBuffer().get(values);
            in.position(in.position() + numberOfFlows * 2);
            byte[] indexes = new byte[numberOfBases];
            in.get(indexes);
            byte[] basecallsAsBytes = new byte[numberOfBases];
            in.get(basecallsAsBytes);
            NucleotideSequence bases = new NucleotideSequenceBuilder(new String(basecallsAsBytes, IOUtil.UTF_8)).build();
            byte[] qualitiesAsBytes = new byte[numberOfBases];
            in.get(qualitiesAsBytes);
            QualitySequence qualities = new QualitySequenceBuilder(qualitiesAsBytes).build();
            int readDataLength = SffUtil.getReadDataLength(numberOfFlows, numberOfBases);
            int padding = SffUtil.caclulatePaddedBytes(readDataLength);
            in.position(in.position() + padding);
            return new DefaultSffReadData(bases, indexes, values, qualities);
        }
        catch (BufferUnderflowException e) {
            throw new SffDecoderException("error decoding read data", e);
        }
    }
}

