/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.util.Arrays;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.ObjectsUtil;
import org.jcvi.jillion.trace.sff.SffReadData;

final class DefaultSffReadData
implements SffReadData {
    private final NucleotideSequence basecalls;
    private final byte[] indexes;
    private final short[] values;
    private final QualitySequence qualities;

    public DefaultSffReadData(NucleotideSequence basecalls, byte[] indexes, short[] values, QualitySequence qualities) {
        this.validateArguments(basecalls, indexes, values, qualities);
        this.basecalls = basecalls;
        this.indexes = Arrays.copyOf(indexes, indexes.length);
        this.values = Arrays.copyOf(values, values.length);
        this.qualities = qualities;
    }

    private void validateArguments(NucleotideSequence basecalls, byte[] indexes, short[] values, QualitySequence qualities) {
        this.canNotBeNull(basecalls, indexes, values, qualities);
        this.lengthsMatch(basecalls, indexes, qualities);
        this.indexesWithinBounds(indexes, values);
    }

    private void indexesWithinBounds(byte[] indexes, short[] values) {
        long sum = 0L;
        for (int i = 0; i < indexes.length; ++i) {
            sum += (long)indexes[i];
        }
        if (sum > (long)values.length) {
            throw new ArrayIndexOutOfBoundsException("indexed flowgram value refers to " + sum + "flowgram value length is" + values.length);
        }
    }

    private void lengthsMatch(NucleotideSequence basecalls, byte[] indexes, QualitySequence qualities) {
        if (basecalls.getLength() != (long)indexes.length || (long)indexes.length != qualities.getLength()) {
            throw new IllegalArgumentException("basecalls, indexes and qualities must be the same length");
        }
    }

    private void canNotBeNull(NucleotideSequence basecalls, byte[] indexes, short[] values, QualitySequence qualities) {
        ObjectsUtil.checkNotNull(basecalls, "basecalls can not be null");
        ObjectsUtil.checkNotNull(indexes, "indexes can not be null");
        ObjectsUtil.checkNotNull(values, "flowgram values can not be null");
        ObjectsUtil.checkNotNull(qualities, "qualities can not be null");
    }

    @Override
    public NucleotideSequence getNucleotideSequence() {
        return this.basecalls;
    }

    @Override
    public byte[] getFlowIndexPerBase() {
        return Arrays.copyOf(this.indexes, this.indexes.length);
    }

    @Override
    public short[] getFlowgramValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public QualitySequence getQualitySequence() {
        return this.qualities;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.basecalls.hashCode();
        result = 31 * result + Arrays.hashCode(this.indexes);
        result = 31 * result + this.qualities.hashCode();
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultSffReadData)) {
            return false;
        }
        DefaultSffReadData other = (DefaultSffReadData)obj;
        return ObjectsUtil.nullSafeEquals(this.getNucleotideSequence(), other.getNucleotideSequence()) && Arrays.equals(this.indexes, other.indexes) && this.qualities.equals(other.getQualitySequence()) && Arrays.equals(this.values, other.values);
    }
}

