/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.trace.sff.SffCommonHeader;
import org.jcvi.jillion.trace.sff.SffDataStoreBuilder;
import org.jcvi.jillion.trace.sff.SffFileDataStore;
import org.jcvi.jillion.trace.sff.SffFileParser;
import org.jcvi.jillion.trace.sff.SffFileReadVisitor;
import org.jcvi.jillion.trace.sff.SffFlowgramImpl;
import org.jcvi.jillion.trace.sff.SffParser;
import org.jcvi.jillion.trace.sff.SffReadData;
import org.jcvi.jillion.trace.sff.SffReadHeader;
import org.jcvi.jillion.trace.sff.SffVisitor;
import org.jcvi.jillion.trace.sff.SffVisitorCallback;

final class DefaultSffFileDataStore {
    private DefaultSffFileDataStore() {
    }

    public static SffFileDataStore create(File sffFile) throws IOException {
        return DefaultSffFileDataStore.create(sffFile, DataStoreFilters.alwaysAccept());
    }

    public static SffFileDataStore create(File sffFile, DataStoreFilter filter) throws IOException {
        Visitor visitor = new Visitor(filter);
        SffParser parser = SffFileParser.create(sffFile);
        parser.parse(visitor);
        return visitor.builder.build();
    }

    private static final class Visitor
    implements SffVisitor {
        private SffDataStoreBuilder builder;
        private final DataStoreFilter filter;

        public Visitor(DataStoreFilter filter) {
            this.filter = filter;
        }

        @Override
        public void visitHeader(SffVisitorCallback callback, SffCommonHeader header) {
            this.builder = new SffDataStoreBuilder(header.getKeySequence(), header.getFlowSequence(), (int)header.getNumberOfReads());
        }

        @Override
        public SffFileReadVisitor visitRead(SffVisitorCallback callback, final SffReadHeader readHeader) {
            if (this.filter.accept(readHeader.getId())) {
                return new SffFileReadVisitor(){

                    @Override
                    public void visitReadData(SffReadData readData) {
                        builder.addFlowgram(SffFlowgramImpl.create(readHeader, readData));
                    }

                    @Override
                    public void visitEnd() {
                    }
                };
            }
            return null;
        }

        @Override
        public void end() {
        }
    }
}

