/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.math.BigInteger;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.ObjectsUtil;
import org.jcvi.jillion.trace.sff.SffCommonHeader;

final class DefaultSffCommonHeader
implements SffCommonHeader {
    private final BigInteger indexOffset;
    private final long indexLength;
    private final long numberOfReads;
    private final int numberOfFlowsPerRead;
    private final NucleotideSequence flow;
    private final NucleotideSequence keySequence;

    DefaultSffCommonHeader(BigInteger indexOffset, long indexLength, long numberOfReads, int numberOfFlowsPerRead, NucleotideSequence flow, NucleotideSequence keySequence) {
        this.indexOffset = indexOffset;
        this.indexLength = indexLength;
        this.numberOfReads = numberOfReads;
        this.numberOfFlowsPerRead = numberOfFlowsPerRead;
        this.flow = flow;
        this.keySequence = keySequence;
    }

    @Override
    public NucleotideSequence getFlowSequence() {
        return this.flow;
    }

    @Override
    public long getIndexLength() {
        return this.indexLength;
    }

    @Override
    public BigInteger getIndexOffset() {
        return this.indexOffset;
    }

    @Override
    public NucleotideSequence getKeySequence() {
        return this.keySequence;
    }

    @Override
    public int getNumberOfFlowsPerRead() {
        return this.numberOfFlowsPerRead;
    }

    @Override
    public long getNumberOfReads() {
        return this.numberOfReads;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flow == null ? 0 : this.flow.hashCode());
        result = 31 * result + (int)(this.indexLength ^ this.indexLength >>> 32);
        result = 31 * result + (this.indexOffset == null ? 0 : this.indexOffset.hashCode());
        result = 31 * result + (this.keySequence == null ? 0 : this.keySequence.hashCode());
        result = 31 * result + this.numberOfFlowsPerRead;
        result = 31 * result + (int)(this.numberOfReads ^ this.numberOfReads >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSffCommonHeader other = (DefaultSffCommonHeader)obj;
        return ObjectsUtil.nullSafeEquals(this.getFlowSequence(), other.getFlowSequence()) && ObjectsUtil.nullSafeEquals(this.getIndexLength(), other.getIndexLength()) && ObjectsUtil.nullSafeEquals(this.getIndexOffset(), other.getIndexOffset()) && ObjectsUtil.nullSafeEquals(this.getKeySequence(), other.getKeySequence()) && ObjectsUtil.nullSafeEquals(this.getNumberOfFlowsPerRead(), other.getNumberOfFlowsPerRead()) && ObjectsUtil.nullSafeEquals(this.getNumberOfReads(), other.getNumberOfReads());
    }

    public String toString() {
        return "DefaultSFFCommonHeader [flow=" + this.flow + ", indexLength=" + this.indexLength + ", indexOffset=" + this.indexOffset + ", keySequence=" + this.keySequence + ", numberOfFlowsPerRead=" + this.numberOfFlowsPerRead + ", numberOfReads=" + this.numberOfReads + "]";
    }

    public static class Builder
    implements org.jcvi.jillion.core.util.Builder<DefaultSffCommonHeader> {
        private BigInteger indexOffset;
        private long indexLength;
        private long numberOfReads;
        private int numberOfFlowsPerRead;
        private NucleotideSequence flow;
        private NucleotideSequence keySequence;

        public Builder() {
        }

        public Builder(SffCommonHeader copy) {
            this.indexOffset = copy.getIndexOffset();
            this.indexLength = copy.getIndexLength();
            this.numberOfReads = copy.getNumberOfReads();
            this.numberOfFlowsPerRead = copy.getNumberOfFlowsPerRead();
            this.flow = copy.getFlowSequence();
            this.keySequence = copy.getKeySequence();
        }

        public Builder withNoIndex() {
            this.indexOffset = BigInteger.ZERO;
            this.indexLength = 0L;
            return this;
        }

        public Builder indexOffset(BigInteger indexOffset) {
            this.indexOffset = indexOffset;
            return this;
        }

        public Builder indexLength(long indexLength) {
            this.indexLength = indexLength;
            return this;
        }

        public Builder numberOfReads(long numberOfReads) {
            this.numberOfReads = numberOfReads;
            return this;
        }

        public Builder numberOfFlowsPerRead(int numberOfFlowsPerRead) {
            this.numberOfFlowsPerRead = numberOfFlowsPerRead;
            return this;
        }

        public Builder keySequence(NucleotideSequence keySequence) {
            this.keySequence = keySequence;
            return this;
        }

        public Builder flow(NucleotideSequence flow) {
            this.flow = flow;
            return this;
        }

        @Override
        public DefaultSffCommonHeader build() {
            if (this.flow == null) {
                NucleotideSequenceBuilder flowBuilder = new NucleotideSequenceBuilder(this.numberOfFlowsPerRead);
                int keyLength = (int)this.keySequence.getLength();
                for (int i = 0; i < this.numberOfFlowsPerRead; i += keyLength) {
                    flowBuilder.append(this.keySequence);
                }
                this.flow = flowBuilder.build();
            }
            return new DefaultSffCommonHeader(this.indexOffset, this.indexLength, this.numberOfReads, this.numberOfFlowsPerRead, this.flow, this.keySequence);
        }
    }
}

