/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.trace.sff.DefaultSffCommonHeader;
import org.jcvi.jillion.trace.sff.SffCommonHeader;
import org.jcvi.jillion.trace.sff.SffCommonHeaderDecoder;
import org.jcvi.jillion.trace.sff.SffDecoderException;
import org.jcvi.jillion.trace.sff.SffUtil;

enum DefaultSFFCommonHeaderDecoder implements SffCommonHeaderDecoder
{
    INSTANCE;

    private static final byte[] MAGIC_NUMBER;
    private static final byte[] ACCEPTED_VERSION;
    private static final byte FORMAT_CODE = 1;
    private static final byte FIXED_HEADER_SIZE = 31;

    @Override
    public SffCommonHeader decodeHeader(ByteBuffer buf) throws SffDecoderException {
        try {
            this.verifyMagicNumber(buf);
            this.verifyVersion1(buf);
            BigInteger indexOffset = IOUtil.getUnsignedLong(buf);
            long indexLength = IOUtil.getUnsignedInt(buf);
            long numReads = IOUtil.getUnsignedInt(buf);
            buf.position(2 + buf.position());
            int keyLength = IOUtil.getUnsignedShort(buf);
            int flowsPerRead = IOUtil.getUnsignedShort(buf);
            this.verifyFlowgramFormatCode(buf);
            byte[] flowBuffer = new byte[flowsPerRead];
            byte[] keySequenceBuffer = new byte[keyLength];
            buf.get(flowBuffer);
            buf.get(keySequenceBuffer);
            NucleotideSequence flow = new NucleotideSequenceBuilder(new String(flowBuffer, IOUtil.UTF_8)).build();
            NucleotideSequence keySequence = new NucleotideSequenceBuilder(new String(keySequenceBuffer, IOUtil.UTF_8)).build();
            int bytesReadSoFar = 31 + flowsPerRead + keyLength;
            int padding = SffUtil.caclulatePaddedBytes(bytesReadSoFar);
            buf.position(padding + buf.position());
            return new DefaultSffCommonHeader(indexOffset, indexLength, numReads, flowsPerRead, flow, keySequence);
        }
        catch (IOException e) {
            throw new SffDecoderException("error reading sff header", e);
        }
    }

    private void verifyMagicNumber(ByteBuffer fixedLengthHeader) throws SffDecoderException {
        byte[] actualMagicNumber = new byte[4];
        fixedLengthHeader.get(actualMagicNumber);
        if (!Arrays.equals(MAGIC_NUMBER, actualMagicNumber)) {
            throw new SffDecoderException("magic number does not match expected");
        }
    }

    @Override
    public SffCommonHeader decodeHeader(DataInputStream in) throws SffDecoderException {
        try {
            this.verifyMagicNumber(in);
            this.verifyVersion1(in);
            BigInteger indexOffset = IOUtil.readUnsignedLong(in);
            long indexLength = IOUtil.readUnsignedInt(in);
            long numReads = IOUtil.readUnsignedInt(in);
            IOUtil.readUnsignedShort(in);
            int keyLength = IOUtil.readUnsignedShort(in);
            int flowsPerRead = IOUtil.readUnsignedShort(in);
            this.verifyFlowgramFormatCode(in);
            NucleotideSequence flow = this.readFlow(in, flowsPerRead);
            NucleotideSequence keySequence = this.readKeySequence(in, keyLength);
            int bytesReadSoFar = 31 + flowsPerRead + keyLength;
            int padding = SffUtil.caclulatePaddedBytes(bytesReadSoFar);
            IOUtil.blockingSkip(in, padding);
            return new DefaultSffCommonHeader(indexOffset, indexLength, numReads, flowsPerRead, flow, keySequence);
        }
        catch (IOException e) {
            throw new SffDecoderException("error decoding sff file", e);
        }
    }

    private NucleotideSequence readFlow(DataInputStream in, int flowsPerRead) throws IOException, SffDecoderException {
        byte[] flow = new byte[flowsPerRead];
        try {
            IOUtil.blockingRead(in, flow);
        }
        catch (IOException e) {
            throw new SffDecoderException("error decoding flow", e);
        }
        return new NucleotideSequenceBuilder(new String(flow, IOUtil.UTF_8)).build();
    }

    private NucleotideSequence readKeySequence(DataInputStream in, int keyLength) throws IOException, SffDecoderException {
        byte[] keySequence = new byte[keyLength];
        try {
            IOUtil.blockingRead(in, keySequence);
        }
        catch (IOException e) {
            throw new SffDecoderException("error decoding keySequence", e);
        }
        return new NucleotideSequenceBuilder(new String(keySequence, IOUtil.UTF_8)).build();
    }

    private void verifyFlowgramFormatCode(DataInputStream in) throws IOException, SffDecoderException {
        if (in.readByte() != 1) {
            throw new SffDecoderException("unknown flowgram format code");
        }
    }

    private void verifyFlowgramFormatCode(ByteBuffer in) throws IOException, SffDecoderException {
        if (in.get() != 1) {
            throw new SffDecoderException("unknown flowgram format code");
        }
    }

    private void verifyVersion1(DataInputStream in) throws IOException, SffDecoderException {
        byte[] versionArray = new byte[4];
        IOUtil.blockingRead(in, versionArray);
        if (!Arrays.equals(versionArray, ACCEPTED_VERSION)) {
            throw new SffDecoderException("version not compatible with decoder");
        }
    }

    private void verifyVersion1(ByteBuffer buf) throws IOException, SffDecoderException {
        byte[] versionArray = new byte[4];
        buf.get(versionArray);
        if (!Arrays.equals(versionArray, ACCEPTED_VERSION)) {
            throw new SffDecoderException("version not compatible with decoder");
        }
    }

    private void verifyMagicNumber(DataInputStream in) throws IOException, SffDecoderException {
        byte[] actualMagicNumber = new byte[4];
        IOUtil.blockingRead(in, actualMagicNumber);
        if (!Arrays.equals(actualMagicNumber, MAGIC_NUMBER)) {
            throw new SffDecoderException("magic number does not match expected");
        }
    }

    static {
        MAGIC_NUMBER = ".sff".getBytes(IOUtil.UTF_8);
        ACCEPTED_VERSION = new byte[]{0, 0, 0, 1};
    }
}

