/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.sff;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.trace.sff.SffCommonHeader;
import org.jcvi.jillion.trace.sff.SffFileDataStore;
import org.jcvi.jillion.trace.sff.SffFileIterator;
import org.jcvi.jillion.trace.sff.SffFileParser;
import org.jcvi.jillion.trace.sff.SffFileReadVisitor;
import org.jcvi.jillion.trace.sff.SffFlowgram;
import org.jcvi.jillion.trace.sff.SffFlowgramImpl;
import org.jcvi.jillion.trace.sff.SffParser;
import org.jcvi.jillion.trace.sff.SffReadData;
import org.jcvi.jillion.trace.sff.SffReadHeader;
import org.jcvi.jillion.trace.sff.SffVisitor;
import org.jcvi.jillion.trace.sff.SffVisitorCallback;

final class CompletelyParsedIndexedSffFileDataStore {
    private CompletelyParsedIndexedSffFileDataStore() {
    }

    public static SffFileDataStore create(File sffFile) throws IOException {
        return CompletelyParsedIndexedSffFileDataStore.create(sffFile, DataStoreFilters.alwaysAccept());
    }

    public static SffFileDataStore create(File sffFile, DataStoreFilter filter) throws IOException {
        Visitor visitor = new Visitor(filter);
        SffParser parser = SffFileParser.create(sffFile);
        parser.parse(visitor);
        return visitor.build(parser, sffFile, filter);
    }

    private static class SingleRecordVisitor
    implements SffVisitor {
        private SffFlowgram flowgram;

        private SingleRecordVisitor() {
        }

        @Override
        public void visitHeader(SffVisitorCallback callback, SffCommonHeader header) {
        }

        @Override
        public SffFileReadVisitor visitRead(final SffVisitorCallback callback, final SffReadHeader readHeader) {
            return new SffFileReadVisitor(){

                @Override
                public void visitReadData(SffReadData readData) {
                    flowgram = SffFlowgramImpl.create(readHeader, readData);
                }

                @Override
                public void visitEnd() {
                    callback.haltParsing();
                }
            };
        }

        @Override
        public void end() {
        }

        public final SffFlowgram getFlowgram() {
            return this.flowgram;
        }
    }

    private static class DataStoreImpl
    implements SffFileDataStore {
        private final SffParser parser;
        private volatile boolean closed = false;
        private final NucleotideSequence keySequence;
        private final NucleotideSequence flowSequence;
        private final Map<String, SffVisitorCallback.SffVisitorMemento> mementos;
        private final File sffFile;
        private final DataStoreFilter filter;

        public DataStoreImpl(SffParser parser, File sffFile, DataStoreFilter filter, NucleotideSequence keySequence, NucleotideSequence flowSequence, Map<String, SffVisitorCallback.SffVisitorMemento> mementos) {
            this.parser = parser;
            this.mementos = mementos;
            this.sffFile = sffFile;
            this.filter = filter;
            if (keySequence == null) {
                throw new NullPointerException("key sequence can not be null");
            }
            if (flowSequence == null) {
                throw new NullPointerException("flow sequence can not be null");
            }
            this.keySequence = keySequence;
            this.flowSequence = flowSequence;
        }

        @Override
        public NucleotideSequence getKeySequence() {
            return this.keySequence;
        }

        @Override
        public NucleotideSequence getFlowSequence() {
            return this.flowSequence;
        }

        @Override
        public StreamingIterator<String> idIterator() throws DataStoreException {
            this.checkNotYetClosed();
            return IteratorUtil.createStreamingIterator(this.mementos.keySet().iterator());
        }

        @Override
        public SffFlowgram get(String id) throws DataStoreException {
            this.checkNotYetClosed();
            SffVisitorCallback.SffVisitorMemento momento = this.mementos.get(id);
            if (momento == null) {
                return null;
            }
            SingleRecordVisitor visitor = new SingleRecordVisitor();
            try {
                this.parser.parse(visitor, momento);
            }
            catch (IOException e) {
                throw new DataStoreException("error reparsing file", e);
            }
            return visitor.getFlowgram();
        }

        @Override
        public boolean contains(String id) throws DataStoreException {
            this.checkNotYetClosed();
            return this.mementos.containsKey(id);
        }

        @Override
        public long getNumberOfRecords() throws DataStoreException {
            this.checkNotYetClosed();
            return this.mementos.size();
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public StreamingIterator<SffFlowgram> iterator() throws DataStoreException {
            this.checkNotYetClosed();
            return DataStoreStreamingIterator.create(this, SffFileIterator.createNewIteratorFor(this.sffFile, this.filter));
        }

        @Override
        public StreamingIterator<DataStoreEntry<SffFlowgram>> entryIterator() throws DataStoreException {
            this.checkNotYetClosed();
            StreamingIterator<DataStoreEntry<SffFlowgram>> iter = new StreamingIterator<DataStoreEntry<SffFlowgram>>(){
                StreamingIterator<SffFlowgram> flowgramIter;
                {
                    this.flowgramIter = SffFileIterator.createNewIteratorFor(sffFile, filter);
                }

                @Override
                public boolean hasNext() {
                    return this.flowgramIter.hasNext();
                }

                @Override
                public void close() {
                    this.flowgramIter.close();
                }

                @Override
                public DataStoreEntry<SffFlowgram> next() {
                    SffFlowgram flowgram = this.flowgramIter.next();
                    return new DataStoreEntry<SffFlowgram>(flowgram.getId(), flowgram);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return DataStoreStreamingIterator.create(this, iter);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        private void checkNotYetClosed() {
            if (this.closed) {
                throw new DataStoreClosedException("datastore is closed");
            }
        }
    }

    private static final class Visitor
    implements SffVisitor {
        private Map<String, SffVisitorCallback.SffVisitorMemento> mementos;
        private final DataStoreFilter filter;
        private NucleotideSequence keySequence;
        private NucleotideSequence flowSequence;

        public Visitor(DataStoreFilter filter) {
            this.filter = filter;
        }

        @Override
        public void visitHeader(SffVisitorCallback callback, SffCommonHeader header) {
            this.mementos = new LinkedHashMap<String, SffVisitorCallback.SffVisitorMemento>((int)header.getNumberOfReads());
            this.keySequence = header.getKeySequence();
            this.flowSequence = header.getFlowSequence();
        }

        @Override
        public SffFileReadVisitor visitRead(SffVisitorCallback callback, SffReadHeader readHeader) {
            if (this.filter.accept(readHeader.getId())) {
                this.mementos.put(readHeader.getId(), callback.createMemento());
            }
            return null;
        }

        @Override
        public void end() {
        }

        SffFileDataStore build(SffParser parser, File sffFile, DataStoreFilter filter) {
            return new DataStoreImpl(parser, sffFile, filter, this.keySequence, this.flowSequence, this.mementos);
        }
    }
}

