/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.trace.fastq.FastqRecord;

class UncommentedFastqRecord
implements FastqRecord {
    private final String id;
    private final NucleotideSequence nucleotides;
    private final QualitySequence qualities;

    public UncommentedFastqRecord(String id, NucleotideSequence nucleotides, QualitySequence qualities) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        if (nucleotides == null) {
            throw new NullPointerException("nucleotides can not be null");
        }
        if (qualities == null) {
            throw new NullPointerException("qualities can not be null");
        }
        this.id = id;
        this.nucleotides = nucleotides;
        this.qualities = qualities;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public NucleotideSequence getNucleotideSequence() {
        return this.nucleotides;
    }

    @Override
    public QualitySequence getQualitySequence() {
        return this.qualities;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.nucleotides.hashCode();
        result = 31 * result + this.qualities.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FastqRecord)) {
            return false;
        }
        FastqRecord other = (FastqRecord)obj;
        if (!this.id.equals(other.getId())) {
            return false;
        }
        if (!this.nucleotides.equals(other.getNucleotideSequence())) {
            return false;
        }
        return this.qualities.equals(other.getQualitySequence());
    }

    public String toString() {
        return "UncommentedFastqRecord [id=" + this.id + ", nucleotides=" + this.nucleotides + ", qualities=" + this.qualities + "]";
    }
}

