/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.util.iter.MergedSortedRecordIterator;
import org.jcvi.jillion.trace.fastq.FastqFileParserBuilder;
import org.jcvi.jillion.trace.fastq.FastqParser;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqRecordBuilder;
import org.jcvi.jillion.trace.fastq.FastqWriter;
import org.jcvi.jillion.trace.fastq.FastqWriterBuilder;
import org.jcvi.jillion.trace.fastq.LargeFastqFileDataStore;

class TmpDirSortedFastqWriter
implements FastqWriter {
    private final File tmpDir;
    private final List<File> tmpFiles = new ArrayList<File>();
    private final int cacheSize;
    private final Comparator<FastqRecord> comparator;
    private final Set<FastqRecord> cache;
    private final FastqQualityCodec codec;
    private final FastqWriter finalWriter;
    private volatile boolean isClosed;

    public TmpDirSortedFastqWriter(FastqWriter finalWriter, Comparator<FastqRecord> comparator, FastqQualityCodec codec, File tmpDir, int cacheSize) {
        this.tmpDir = tmpDir;
        this.cacheSize = cacheSize;
        this.comparator = comparator;
        this.cache = new TreeSet<FastqRecord>(comparator);
        this.codec = codec;
        this.finalWriter = finalWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        ArrayList iters = new ArrayList();
        try {
            iters.add(IteratorUtil.createPeekableStreamingIterator(this.cache.iterator()));
            for (File file : this.tmpFiles) {
                try {
                    FastqParser parser = new FastqFileParserBuilder(file).hasComments(true).build();
                    iters.add(LargeFastqFileDataStore.create(parser, this.codec, DataStoreFilters.alwaysAccept(), null).iterator());
                }
                catch (DataStoreException e) {
                    throw new IOException("error re-parsing temp file " + file.getAbsolutePath(), e);
                }
            }
            MergedSortedRecordIterator<FastqRecord> mergedIter = new MergedSortedRecordIterator<FastqRecord>(iters, this.comparator);
            try {
                while (mergedIter.hasNext()) {
                    this.finalWriter.write((FastqRecord)mergedIter.next());
                }
            }
            finally {
                this.finalWriter.close();
            }
        }
        catch (Throwable throwable) {
            for (StreamingIterator streamingIterator : iters) {
                IOUtil.closeAndIgnoreErrors((Closeable)streamingIterator);
            }
            this.cache.clear();
            for (File file : this.tmpFiles) {
                IOUtil.deleteIgnoreError(file);
            }
            this.tmpFiles.clear();
            throw throwable;
        }
        for (StreamingIterator streamingIterator : iters) {
            IOUtil.closeAndIgnoreErrors((Closeable)streamingIterator);
        }
        this.cache.clear();
        for (File file : this.tmpFiles) {
            IOUtil.deleteIgnoreError(file);
        }
        this.tmpFiles.clear();
    }

    private synchronized void writeToCache(FastqRecord record) throws IOException {
        this.cache.add(record);
        if (this.cache.size() >= this.cacheSize) {
            this.writeCacheToTmpFile();
            this.cache.clear();
        }
    }

    private void writeCacheToTmpFile() throws IOException {
        File tmpFile = File.createTempFile("sorted.", ".fastq", this.tmpDir);
        try (FastqWriter writer = new FastqWriterBuilder(tmpFile).qualityCodec(this.codec).build();){
            for (FastqRecord record : this.cache) {
                writer.write(record);
            }
        }
        this.tmpFiles.add(tmpFile);
    }

    @Override
    public void write(FastqRecord record) throws IOException {
        if (this.isClosed) {
            throw new IOException("writer is closed");
        }
        Objects.requireNonNull(record);
        this.writeToCache(record);
    }

    @Override
    public void write(String id, NucleotideSequence nucleotides, QualitySequence qualities) throws IOException {
        this.write(FastqRecordBuilder.create(id, nucleotides, qualities).build());
    }

    @Override
    public void write(String id, NucleotideSequence sequence, QualitySequence qualities, String optionalComment) throws IOException {
        this.write(FastqRecordBuilder.create(id, sequence, qualities, optionalComment).build());
    }
}

