/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.internal.core.util.Sneak;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqRecordBuilder;
import org.jcvi.jillion.trace.fastq.FastqWriter;

public final class SplitFastqWriter {
    public static FastqWriter roundRobin(int numberOfFiles, FastqWriterFactory supplier) {
        return new RoundRobinSplitFastqWriter(numberOfFiles, supplier);
    }

    public static FastqWriter rollover(int maxRecordsPerFile, FastqWriterFactory supplier) {
        return new RolloverSplitFastqWriter(maxRecordsPerFile, supplier);
    }

    public static <K> FastqWriter deconvolve(Function<FastqRecord, K> deconvolutionFunction, DeconvolveFastqRecordWriterFactory<K> supplier) {
        return new DeconvolutionFastqWriter<K>(deconvolutionFunction, supplier);
    }

    private SplitFastqWriter() {
    }

    private static final class RoundRobinSplitFastqWriter
    implements FastqWriter {
        private final FastqWriterFactory supplier;
        private int currentIndex = 0;
        private volatile boolean closed = false;
        private final FastqWriter[] writers;

        private RoundRobinSplitFastqWriter(int numberOfFiles, FastqWriterFactory supplier) {
            Objects.requireNonNull(supplier);
            if (numberOfFiles < 1) {
                throw new IllegalArgumentException("records per File must be >=1");
            }
            this.writers = new FastqWriter[numberOfFiles];
            this.supplier = supplier;
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("already closed");
            }
        }

        private synchronized FastqWriter getCurrentWriter() throws IOException {
            this.checkNotClosed();
            FastqWriter writer = this.writers[this.currentIndex];
            if (writer == null) {
                this.writers[this.currentIndex] = writer = this.supplier.create(this.currentIndex + 1);
            }
            this.currentIndex = (this.currentIndex + 1) % this.writers.length;
            return writer;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.closed) {
                for (FastqWriter writer : this.writers) {
                    IOUtil.closeAndIgnoreErrors((Closeable)writer);
                }
            }
            this.closed = true;
        }

        @Override
        public void write(FastqRecord record) throws IOException {
            this.getCurrentWriter().write(record);
        }

        @Override
        public void write(String id, NucleotideSequence sequence, QualitySequence qualities) throws IOException {
            this.getCurrentWriter().write(id, sequence, qualities);
        }

        @Override
        public void write(String id, NucleotideSequence sequence, QualitySequence qualities, String optionalComment) throws IOException {
            this.getCurrentWriter().write(id, sequence, qualities, optionalComment);
        }
    }

    private static final class RolloverSplitFastqWriter
    implements FastqWriter {
        private final FastqWriterFactory supplier;
        private final int recordsPerFile;
        private int splitFileNumber = 0;
        private int currentRecordCount;
        private FastqWriter currentWriter;
        private volatile boolean closed = false;

        private RolloverSplitFastqWriter(int recordsPerFile, FastqWriterFactory supplier) {
            Objects.requireNonNull(supplier);
            if (recordsPerFile < 1) {
                throw new IllegalArgumentException("records per File must be >=1");
            }
            this.supplier = supplier;
            this.recordsPerFile = recordsPerFile;
            this.currentRecordCount = recordsPerFile;
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("already closed");
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.closed && this.currentWriter != null) {
                this.currentWriter.close();
            }
            this.closed = true;
        }

        @Override
        public synchronized void write(FastqRecord record) throws IOException {
            this.updateCurrentWriterIfNeeded();
            this.currentWriter.write(record);
            ++this.currentRecordCount;
        }

        private synchronized void updateCurrentWriterIfNeeded() throws IOException {
            this.checkNotClosed();
            if (this.currentRecordCount == this.recordsPerFile) {
                if (this.currentWriter != null) {
                    this.currentWriter.close();
                }
                ++this.splitFileNumber;
                this.currentRecordCount = 0;
                this.currentWriter = this.supplier.create(this.splitFileNumber);
            }
        }

        @Override
        public synchronized void write(String id, NucleotideSequence sequence, QualitySequence qualities) throws IOException {
            this.write(id, sequence, qualities, null);
        }

        @Override
        public synchronized void write(String id, NucleotideSequence sequence, QualitySequence qualities, String optionalComment) throws IOException {
            this.updateCurrentWriterIfNeeded();
            this.currentWriter.write(id, sequence, qualities, optionalComment);
            ++this.currentRecordCount;
        }
    }

    private static final class DeconvolutionFastqWriter<K>
    implements FastqWriter {
        private volatile boolean closed = false;
        private final Map<K, FastqWriter> writers = new ConcurrentHashMap<K, FastqWriter>();
        private final Function<FastqRecord, K> deconvolutionFunction;
        private final DeconvolveFastqRecordWriterFactory<K> supplier;

        public DeconvolutionFastqWriter(Function<FastqRecord, K> deconvolutionFunction, DeconvolveFastqRecordWriterFactory<K> supplier) {
            Objects.requireNonNull(deconvolutionFunction);
            Objects.requireNonNull(supplier);
            this.deconvolutionFunction = deconvolutionFunction;
            this.supplier = supplier;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (FastqWriter writer : this.writers.values()) {
                IOUtil.closeAndIgnoreErrors((Closeable)writer);
            }
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("already closed");
            }
        }

        @Override
        public void write(FastqRecord record) throws IOException {
            this.checkNotClosed();
            Objects.requireNonNull(record);
            K key = this.deconvolutionFunction.apply(record);
            if (key == null) {
                return;
            }
            this.writers.computeIfAbsent(key, k -> {
                try {
                    return this.supplier.create(k);
                }
                catch (IOException e) {
                    throw Sneak.sneakyThrow(e);
                }
            }).write(record);
        }

        @Override
        public void write(String id, NucleotideSequence sequence, QualitySequence qualities) throws IOException {
            this.write(id, sequence, qualities, null);
        }

        @Override
        public void write(String id, NucleotideSequence sequence, QualitySequence qualities, String optionalComment) throws IOException {
            Objects.requireNonNull(id, "id can not be null");
            Objects.requireNonNull(sequence, "sequence can not be null");
            Objects.requireNonNull(qualities, "qualities can not be null");
            this.write(FastqRecordBuilder.create(id, sequence, qualities, optionalComment).build());
        }
    }

    @FunctionalInterface
    public static interface DeconvolveFastqRecordWriterFactory<K> {
        public FastqWriter create(K var1) throws IOException;
    }

    @FunctionalInterface
    public static interface FastqWriterFactory {
        public FastqWriter create(int var1) throws IOException;
    }
}

