/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.util.HashMap;
import java.util.Map;
import org.jcvi.jillion.core.qual.PhredQuality;

final class SolexaUtil {
    private static final double TEN = 10.0;
    private static final Map<Integer, PhredQuality> SOLEXA_2_PHRED_MAP;
    private static final Map<PhredQuality, Integer> PHRED_2_SOLEXA_MAP;

    private SolexaUtil() {
    }

    private static PhredQuality privateConvertSolexaQualityToPhredQuality(int solexaQuality) {
        if (solexaQuality == -5) {
            return PhredQuality.valueOf(0);
        }
        if (solexaQuality == -4) {
            return PhredQuality.valueOf(1);
        }
        if (solexaQuality == -3 || solexaQuality == -2) {
            return PhredQuality.valueOf(2);
        }
        if (solexaQuality == -1) {
            return PhredQuality.valueOf(3);
        }
        double math = 10.0 * Math.log(1.0 + Math.pow(10.0, (double)solexaQuality / 10.0)) / Math.log(10.0);
        return PhredQuality.valueOf((int)Math.round(math));
    }

    private static int privateConvertPhredQualityToSolexaQuality(PhredQuality phredQuality) {
        byte qualityValue = phredQuality.getQualityScore();
        if (qualityValue == 0) {
            return -5;
        }
        if (qualityValue == 1) {
            return -4;
        }
        if (qualityValue == 2) {
            return -2;
        }
        double math = 10.0 * Math.log(Math.pow(10.0, (double)qualityValue / 10.0) - 1.0) / Math.log(10.0);
        return (int)Math.round(math);
    }

    public static PhredQuality convertSolexaQualityToPhredQuality(int solexaQuality) {
        return SOLEXA_2_PHRED_MAP.get(solexaQuality);
    }

    public static int convertPhredQualityToSolexaQuality(PhredQuality phredQuality) {
        return PHRED_2_SOLEXA_MAP.get(phredQuality);
    }

    static {
        PhredQuality phred;
        SOLEXA_2_PHRED_MAP = new HashMap<Integer, PhredQuality>();
        PHRED_2_SOLEXA_MAP = new HashMap<PhredQuality, Integer>();
        for (int solexaValue = -5; solexaValue <= 62; ++solexaValue) {
            phred = SolexaUtil.privateConvertSolexaQualityToPhredQuality(solexaValue);
            SOLEXA_2_PHRED_MAP.put(solexaValue, phred);
        }
        for (int i = 0; i < 127; i = (int)((byte)(i + 1))) {
            phred = PhredQuality.valueOf(i);
            int solexaValue = SolexaUtil.privateConvertPhredQualityToSolexaQuality(phred);
            PHRED_2_SOLEXA_MAP.put(phred, solexaValue);
        }
    }
}

