/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.core.util.streams.ThrowingBiConsumer;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.core.util.Sneak;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;
import org.jcvi.jillion.trace.fastq.AbstractFastqRecordVisitor;
import org.jcvi.jillion.trace.fastq.AbstractFastqVisitor;
import org.jcvi.jillion.trace.fastq.FastqFileDataStore;
import org.jcvi.jillion.trace.fastq.FastqParser;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqRecordVisitor;
import org.jcvi.jillion.trace.fastq.FastqVisitor;

final class LargeFastqFileDataStore
implements FastqFileDataStore {
    private final FastqQualityCodec qualityCodec;
    private final FastqParser parser;
    private Long size = null;
    private volatile boolean closed;
    private final Predicate<String> filter;
    private final Predicate<FastqRecord> recordFilter;

    static FastqFileDataStore create(FastqParser parser, FastqQualityCodec qualityCodec, Predicate<String> filter, Predicate<FastqRecord> recordFilter) throws IOException {
        return new LargeFastqFileDataStore(parser, qualityCodec, filter, recordFilter);
    }

    private LargeFastqFileDataStore(FastqParser parser, FastqQualityCodec qualityCodec, Predicate<String> filter, Predicate<FastqRecord> recordFilter) throws IOException {
        if (parser == null) {
            throw new NullPointerException("parser can not be null");
        }
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.parser = parser;
        this.filter = filter;
        this.qualityCodec = qualityCodec;
        this.recordFilter = recordFilter;
    }

    @Override
    public Optional<File> getFile() {
        return this.parser.getFile();
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
    }

    @Override
    public FastqQualityCodec getQualityCodec() {
        return this.qualityCodec;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized boolean contains(String id) throws DataStoreException {
        this.throwExceptionIfClosed();
        if (!this.filter.test(id)) {
            return false;
        }
        try (StreamingIterator<String> iter = this.idIterator();){
            while (iter.hasNext()) {
                if (!iter.next().equals(id)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private void throwExceptionIfClosed() {
        if (this.closed) {
            throw new DataStoreClosedException("datastore is closed");
        }
    }

    @Override
    public synchronized FastqRecord get(String id) throws DataStoreException {
        this.throwExceptionIfClosed();
        if (!this.filter.test(id)) {
            return null;
        }
        try (StreamingIterator<FastqRecord> iter = this.iterator();){
            while (iter.hasNext()) {
                FastqRecord fastQ = iter.next();
                if (!fastQ.getId().equals(id)) continue;
                FastqRecord fastqRecord = fastQ;
                return fastqRecord;
            }
        }
        return null;
    }

    @Override
    public synchronized StreamingIterator<String> idIterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        if (this.recordFilter == null) {
            NoLambdaFastqIdIterator iterator = new NoLambdaFastqIdIterator();
            iterator.start();
            return DataStoreStreamingIterator.create(this, iterator);
        }
        return new LambdaFilteredFastqIdIterator(this.iterator());
    }

    @Override
    public synchronized long getNumberOfRecords() throws DataStoreException {
        this.throwExceptionIfClosed();
        if (this.size == null) {
            long count = 0L;
            StreamingIterator<FastqRecord> iter = this.iterator();
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            this.size = count;
        }
        return this.size;
    }

    @Override
    public synchronized StreamingIterator<FastqRecord> iterator() {
        this.throwExceptionIfClosed();
        LargeFastqFileIterator iter = new LargeFastqFileIterator();
        iter.start();
        return DataStoreStreamingIterator.create(this, iter);
    }

    @Override
    public <E extends Throwable> void forEach(final ThrowingBiConsumer<String, FastqRecord, E> consumer) throws IOException, E {
        this.parser.parse(new AbstractFastqVisitor(){

            @Override
            public FastqRecordVisitor visitDefline(FastqVisitor.FastqVisitorCallback callback, final String id, String optionalComment) {
                if (LargeFastqFileDataStore.this.filter.test(id)) {
                    return new AbstractFastqRecordVisitor(id, optionalComment, LargeFastqFileDataStore.this.qualityCodec, true){

                        @Override
                        protected void visitRecord(FastqRecord record) {
                            if (LargeFastqFileDataStore.this.recordFilter == null || LargeFastqFileDataStore.this.recordFilter.test(record)) {
                                try {
                                    consumer.accept(id, record);
                                }
                                catch (Throwable t) {
                                    Sneak.sneakyThrow(t);
                                }
                            }
                        }
                    };
                }
                return null;
            }
        });
    }

    @Override
    public synchronized StreamingIterator<DataStoreEntry<FastqRecord>> entryIterator() throws DataStoreException {
        this.throwExceptionIfClosed();
        StreamingIterator<DataStoreEntry<FastqRecord>> iter = new StreamingIterator<DataStoreEntry<FastqRecord>>(){
            StreamingIterator<FastqRecord> fastqs;
            {
                this.fastqs = LargeFastqFileDataStore.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.fastqs.hasNext();
            }

            @Override
            public void close() {
                this.fastqs.close();
            }

            @Override
            public DataStoreEntry<FastqRecord> next() {
                FastqRecord record = this.fastqs.next();
                return new DataStoreEntry<FastqRecord>(record.getId(), record);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return DataStoreStreamingIterator.create(this, iter);
    }

    private final class LargeFastqFileIterator
    extends AbstractBlockingStreamingIterator<FastqRecord>
    implements StreamingIterator<FastqRecord> {
        private LargeFastqFileIterator() {
        }

        @Override
        protected void backgroundThreadRunMethod() {
            try {
                FastqVisitor visitor = new FastqVisitor(){

                    @Override
                    public void visitEnd() {
                    }

                    @Override
                    public void halted() {
                    }

                    @Override
                    public FastqRecordVisitor visitDefline(final FastqVisitor.FastqVisitorCallback callback, String id, String optionalComment) {
                        if (LargeFastqFileIterator.this.isClosed()) {
                            callback.haltParsing();
                            return null;
                        }
                        if (LargeFastqFileDataStore.this.filter.test(id)) {
                            return new AbstractFastqRecordVisitor(id, optionalComment, LargeFastqFileDataStore.this.qualityCodec, true){

                                @Override
                                protected void visitRecord(FastqRecord record) {
                                    if (LargeFastqFileDataStore.this.recordFilter == null || LargeFastqFileDataStore.this.recordFilter.test(record)) {
                                        LargeFastqFileIterator.this.blockingPut(record);
                                        if (LargeFastqFileIterator.this.isClosed()) {
                                            callback.haltParsing();
                                        }
                                    }
                                }
                            };
                        }
                        return null;
                    }
                };
                LargeFastqFileDataStore.this.parser.parse(visitor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class NoLambdaFastqIdIterator
    extends AbstractBlockingStreamingIterator<String>
    implements StreamingIterator<String> {
        private NoLambdaFastqIdIterator() {
        }

        @Override
        protected void backgroundThreadRunMethod() {
            try {
                FastqVisitor visitor = new FastqVisitor(){

                    @Override
                    public void visitEnd() {
                    }

                    @Override
                    public void halted() {
                    }

                    @Override
                    public FastqRecordVisitor visitDefline(FastqVisitor.FastqVisitorCallback callback, String id, String optionalComment) {
                        if (NoLambdaFastqIdIterator.this.isClosed()) {
                            callback.haltParsing();
                        }
                        if (LargeFastqFileDataStore.this.filter.test(id)) {
                            NoLambdaFastqIdIterator.this.blockingPut(id);
                            if (NoLambdaFastqIdIterator.this.isClosed()) {
                                callback.haltParsing();
                            }
                            return null;
                        }
                        return null;
                    }
                };
                LargeFastqFileDataStore.this.parser.parse(visitor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class LambdaFilteredFastqIdIterator
    implements StreamingIterator<String> {
        private final StreamingIterator<FastqRecord> iter;

        public LambdaFilteredFastqIdIterator(StreamingIterator<FastqRecord> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public void close() {
            this.iter.close();
        }

        @Override
        public String next() {
            return this.iter.next().getId();
        }
    }
}

