/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.core.util.streams.ThrowingBiConsumer;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.trace.fastq.AbstractFastqRecordVisitor;
import org.jcvi.jillion.trace.fastq.AbstractFastqVisitor;
import org.jcvi.jillion.trace.fastq.FastqFileDataStore;
import org.jcvi.jillion.trace.fastq.FastqParser;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqRecordVisitor;
import org.jcvi.jillion.trace.fastq.FastqVisitor;
import org.jcvi.jillion.trace.fastq.LargeFastqFileDataStore;

final class IndexedFastqFileDataStore {
    IndexedFastqFileDataStore() {
    }

    static FastqFileDataStore create(FastqParser parser, FastqQualityCodec qualityCodec, Predicate<String> filter, Predicate<FastqRecord> recordFilter) throws IOException {
        MementoedFastqDataStoreBuilderVisitor visitor = new MementoedFastqDataStoreBuilderVisitor(parser, qualityCodec, filter, recordFilter);
        parser.parse(visitor);
        return visitor.build();
    }

    private static final class IndexedFastqFileDataStoreImpl
    implements FastqFileDataStore {
        private final Map<String, FastqVisitor.FastqVisitorCallback.FastqVisitorMemento> mementos;
        private final FastqQualityCodec qualityCodec;
        private final FastqParser parser;
        private final Predicate<String> filter;
        private final Predicate<FastqRecord> recordFilter;
        private volatile boolean closed;

        public IndexedFastqFileDataStoreImpl(FastqParser parser, FastqQualityCodec qualityCodec, Predicate<String> filter, Predicate<FastqRecord> recordFilter, Map<String, FastqVisitor.FastqVisitorCallback.FastqVisitorMemento> mementos) {
            this.qualityCodec = qualityCodec;
            this.parser = parser;
            this.mementos = mementos;
            this.filter = filter;
            this.recordFilter = recordFilter;
        }

        @Override
        public StreamingIterator<String> idIterator() throws DataStoreException {
            this.throwExceptionIfClosed();
            return DataStoreStreamingIterator.create(this, this.mementos.keySet().iterator());
        }

        @Override
        public FastqRecord get(String id) throws DataStoreException {
            this.throwExceptionIfClosed();
            FastqVisitor.FastqVisitorCallback.FastqVisitorMemento memento = this.mementos.get(id);
            if (memento == null) {
                return null;
            }
            SingleFastqRecordVistior visitor = new SingleFastqRecordVistior();
            try {
                this.parser.parse(visitor, memento);
            }
            catch (IOException e) {
                throw new DataStoreException("error reading fastq file", e);
            }
            return visitor.getRecord();
        }

        @Override
        public boolean contains(String id) throws DataStoreException {
            this.throwExceptionIfClosed();
            return this.mementos.containsKey(id);
        }

        @Override
        public long getNumberOfRecords() throws DataStoreException {
            this.throwExceptionIfClosed();
            return this.mementos.size();
        }

        @Override
        public void close() {
            this.closed = true;
            this.mementos.clear();
        }

        @Override
        public Optional<File> getFile() {
            return this.parser.getFile();
        }

        private void throwExceptionIfClosed() {
            if (this.closed) {
                throw new DataStoreClosedException("datastore is closed");
            }
        }

        @Override
        public <E extends Throwable> void forEach(ThrowingBiConsumer<String, FastqRecord, E> consumer) throws IOException, E {
            this.throwExceptionIfClosed();
            LargeFastqFileDataStore.create(this.parser, this.qualityCodec, this.filter, this.recordFilter).forEach(consumer);
        }

        @Override
        public StreamingIterator<FastqRecord> iterator() throws DataStoreException {
            this.throwExceptionIfClosed();
            try {
                StreamingIterator iter = LargeFastqFileDataStore.create(this.parser, this.qualityCodec, this.filter, this.recordFilter).iterator();
                return DataStoreStreamingIterator.create(this, iter);
            }
            catch (IOException e) {
                throw new IllegalStateException("fastq file no longer exists! : ", e);
            }
        }

        @Override
        public StreamingIterator<DataStoreEntry<FastqRecord>> entryIterator() throws DataStoreException {
            this.throwExceptionIfClosed();
            StreamingIterator<DataStoreEntry<FastqRecord>> iter = new StreamingIterator<DataStoreEntry<FastqRecord>>(){
                StreamingIterator<FastqRecord> fastqs;
                {
                    this.fastqs = this.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.fastqs.hasNext();
                }

                @Override
                public void close() {
                    this.fastqs.close();
                }

                @Override
                public DataStoreEntry<FastqRecord> next() {
                    FastqRecord record = this.fastqs.next();
                    return new DataStoreEntry<FastqRecord>(record.getId(), record);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return DataStoreStreamingIterator.create(this, iter);
        }

        @Override
        public FastqQualityCodec getQualityCodec() {
            return this.qualityCodec;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        private class SingleFastqRecordVistior
        extends AbstractFastqVisitor {
            private FastqRecord record;

            private SingleFastqRecordVistior() {
            }

            @Override
            public FastqRecordVisitor visitDefline(final FastqVisitor.FastqVisitorCallback callback, String id, String optionalComment) {
                return new AbstractFastqRecordVisitor(id, optionalComment, IndexedFastqFileDataStoreImpl.this.qualityCodec){

                    @Override
                    protected void visitRecord(FastqRecord record) {
                        SingleFastqRecordVistior.this.setRecord(record);
                        callback.haltParsing();
                    }
                };
            }

            public final FastqRecord getRecord() {
                return this.record;
            }

            public final void setRecord(FastqRecord record) {
                this.record = record;
            }
        }
    }

    private static final class MementoedFastqDataStoreBuilderVisitor
    extends AbstractFastqVisitor {
        private final Map<String, FastqVisitor.FastqVisitorCallback.FastqVisitorMemento> mementos = new LinkedHashMap<String, FastqVisitor.FastqVisitorCallback.FastqVisitorMemento>();
        private final FastqQualityCodec qualityCodec;
        private final FastqParser parser;
        private final Predicate<String> filter;
        private final Predicate<FastqRecord> recordFilter;

        public MementoedFastqDataStoreBuilderVisitor(FastqParser parser, FastqQualityCodec qualityCodec, Predicate<String> filter, Predicate<FastqRecord> recordFilter) {
            this.parser = parser;
            this.qualityCodec = qualityCodec;
            this.filter = filter;
            this.recordFilter = recordFilter;
        }

        public FastqFileDataStore build() {
            return new IndexedFastqFileDataStoreImpl(this.parser, this.qualityCodec, this.filter, this.recordFilter, this.mementos);
        }

        @Override
        public FastqRecordVisitor visitDefline(FastqVisitor.FastqVisitorCallback callback, final String id, String optionalComment) {
            if (this.filter.test(id)) {
                if (!callback.canCreateMemento()) {
                    throw new IllegalStateException("can not create memento for " + id);
                }
                final FastqVisitor.FastqVisitorCallback.FastqVisitorMemento createMemento = callback.createMemento();
                if (this.recordFilter == null) {
                    this.mementos.put(id, createMemento);
                    return null;
                }
                return new AbstractFastqRecordVisitor(id, optionalComment, this.qualityCodec){

                    @Override
                    protected void visitRecord(FastqRecord record) {
                        if (recordFilter.test(record)) {
                            mementos.put(id, createMemento);
                        }
                    }
                };
            }
            return null;
        }
    }
}

