/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqRecordBuilder;
import org.jcvi.jillion.trace.fastq.FastqWriter;

class InMemorySortedFastqWriter
implements FastqWriter {
    private final FastqWriter writer;
    private final Set<FastqRecord> sorted;
    private volatile boolean closed;

    public InMemorySortedFastqWriter(FastqWriter writer, Comparator<FastqRecord> comparator) {
        Objects.requireNonNull(writer);
        Objects.requireNonNull(comparator);
        this.writer = writer;
        this.sorted = new ConcurrentSkipListSet<FastqRecord>(comparator);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            for (FastqRecord record : this.sorted) {
                this.writer.write(record);
            }
        }
        finally {
            this.sorted.clear();
            IOUtil.closeAndIgnoreErrors((Closeable)this.writer);
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("writer is closed");
        }
    }

    @Override
    public void write(FastqRecord record) throws IOException {
        this.checkNotClosed();
        this.sorted.add(record);
    }

    @Override
    public void write(String id, NucleotideSequence nucleotides, QualitySequence qualities) throws IOException {
        this.write(FastqRecordBuilder.create(id, nucleotides, qualities).build());
    }

    @Override
    public void write(String id, NucleotideSequence sequence, QualitySequence qualities, String optionalComment) throws IOException {
        this.write(FastqRecordBuilder.create(id, sequence, qualities, optionalComment).build());
    }
}

