/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IlluminaUtil {
    private static final Pattern NAME_PATTERN = Pattern.compile("^(SOLEXA\\d+).*:(\\d+):(\\d+):(\\d+):(\\d+)#(\\D+)?(\\d+)?\\/(\\d+)$");
    private static final Pattern CASAVA_1_8_PATTERN = Pattern.compile("^(\\S+):(\\d+):(\\S+):(\\d+):(\\d+)#(\\D+)?(\\d+)?\\/(\\d+)$");

    private IlluminaUtil() {
    }

    public static boolean isIlluminaRead(String readId) {
        if (readId == null) {
            throw new NullPointerException();
        }
        Matcher matcher = NAME_PATTERN.matcher(readId);
        if (matcher.matches()) {
            return true;
        }
        return IlluminaUtil.isCasava18Read(readId);
    }

    public static boolean isCasava18Read(String readId) {
        return CASAVA_1_8_PATTERN.matcher(readId).matches();
    }

    public static String getRunId(String illuminaReadId) {
        Matcher matcher = CASAVA_1_8_PATTERN.matcher(illuminaReadId);
        if (!matcher.matches()) {
            IlluminaUtil.throwNotValidReadId(illuminaReadId);
        }
        return matcher.group(2);
    }

    private static String throwNotValidReadId(String readId) {
        throw new IllegalArgumentException("is not an illumina read id " + readId);
    }

    public static final String getInstrumentName(String illuminaReadId) {
        if (illuminaReadId == null) {
            throw new NullPointerException();
        }
        Matcher matcher = NAME_PATTERN.matcher(illuminaReadId);
        if (!matcher.matches()) {
            IlluminaUtil.throwNotValidReadId(illuminaReadId);
        }
        return matcher.group(1);
    }

    public static final String getFlowcellId(String illuminaReadId) {
        if (illuminaReadId == null) {
            throw new NullPointerException();
        }
        Matcher matcher = NAME_PATTERN.matcher(illuminaReadId);
        if (matcher.matches()) {
            return IlluminaUtil.getLegacyFlowCellId(matcher);
        }
        Matcher casava18Matcher = CASAVA_1_8_PATTERN.matcher(illuminaReadId);
        if (casava18Matcher.matches()) {
            return IlluminaUtil.getCasava18FlowCellId(casava18Matcher);
        }
        return IlluminaUtil.throwNotValidReadId(illuminaReadId);
    }

    private static String getCasava18FlowCellId(Matcher matcher) {
        return matcher.group(3);
    }

    private static String getLegacyFlowCellId(Matcher legacyMatcher) {
        return legacyMatcher.group(2);
    }

    public static final int getTileNumber(String illuminaReadId) {
        if (illuminaReadId == null) {
            throw new NullPointerException();
        }
        Matcher matcher = NAME_PATTERN.matcher(illuminaReadId);
        if (!matcher.matches()) {
            IlluminaUtil.throwNotValidReadId(illuminaReadId);
        }
        return Integer.parseInt(matcher.group(3));
    }

    public static final int getXClusterCoordinate(String illuminaReadId) {
        if (illuminaReadId == null) {
            throw new NullPointerException();
        }
        Matcher matcher = NAME_PATTERN.matcher(illuminaReadId);
        if (!matcher.matches()) {
            IlluminaUtil.throwNotValidReadId(illuminaReadId);
        }
        return Integer.parseInt(matcher.group(4));
    }

    public static final int getYClusterCoordinate(String illuminaReadId) {
        if (illuminaReadId == null) {
            throw new NullPointerException();
        }
        Matcher matcher = NAME_PATTERN.matcher(illuminaReadId);
        if (!matcher.matches()) {
            IlluminaUtil.throwNotValidReadId(illuminaReadId);
        }
        return Integer.parseInt(matcher.group(5));
    }

    public static final int getMultiplexIndex(String illuminaReadId) {
        if (illuminaReadId == null) {
            throw new NullPointerException();
        }
        Matcher matcher = NAME_PATTERN.matcher(illuminaReadId);
        if (!matcher.matches()) {
            IlluminaUtil.throwNotValidReadId(illuminaReadId);
        }
        return Integer.parseInt(matcher.group(7));
    }

    public static final int getPairNumber(String illuminaReadId) {
        if (illuminaReadId == null) {
            throw new NullPointerException();
        }
        Matcher matcher = NAME_PATTERN.matcher(illuminaReadId);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("is not an illumina read id or member of a pair" + illuminaReadId);
        }
        return Integer.parseInt(matcher.group(8));
    }
}

