/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.BufferSize;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.internal.core.io.OutputStreamFactory;
import org.jcvi.jillion.internal.trace.fastq.ParsedFastqRecord;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqWriter;
import org.jcvi.jillion.trace.fastq.InMemorySortedFastqWriter;
import org.jcvi.jillion.trace.fastq.TmpDirSortedFastqWriter;

public final class FastqWriterBuilder
implements Builder<FastqWriter> {
    private static final String CR = "\n";
    private static final int ALL_ON_ONE_LINE = -1;
    private static final Charset DEFAULT_CHARSET = IOUtil.UTF_8;
    private static final FastqQualityCodec DEFAULT_CODEC = FastqQualityCodec.SANGER;
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private final OutputStream out;
    private int numberOfBasesPerLine = -1;
    private boolean writeIdOnQualityLine = false;
    private FastqQualityCodec codec = DEFAULT_CODEC;
    private Charset charSet = DEFAULT_CHARSET;
    private Comparator<FastqRecord> comparator = null;
    private Integer inMemoryCacheSize;
    private File tmpDir;
    private Function<FastqRecord, FastqRecord> adapterFunction = null;

    public FastqWriterBuilder(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("outputstream can not be null");
        }
        this.out = out;
    }

    public FastqWriterBuilder(File outputFile) throws IOException {
        this.out = OutputStreamFactory.create(outputFile, BufferSize.kb(64));
    }

    public FastqWriterBuilder charset(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset can not be null");
        }
        this.charSet = charset;
        return this;
    }

    public FastqWriterBuilder qualityCodec(FastqQualityCodec codec) {
        if (codec == null) {
            throw new NullPointerException("codec can not be null");
        }
        this.codec = codec;
        return this;
    }

    public FastqWriterBuilder duplicateIdOnQualityDefLine() {
        this.writeIdOnQualityLine = true;
        return this;
    }

    public FastqWriterBuilder adapt(Function<FastqRecord, FastqRecord> adapterFunction) {
        this.adapterFunction = adapterFunction;
        return this;
    }

    public FastqWriterBuilder basesPerLine(int basesPerLine) {
        if (basesPerLine < 1) {
            throw new IllegalArgumentException("number per line must be >=1");
        }
        this.numberOfBasesPerLine = basesPerLine;
        return this;
    }

    public FastqWriterBuilder sortInMemoryOnly(Comparator<FastqRecord> comparator) {
        Objects.requireNonNull(comparator);
        this.comparator = comparator;
        this.inMemoryCacheSize = null;
        this.tmpDir = null;
        return this;
    }

    public FastqWriterBuilder sort(Comparator<FastqRecord> comparator) {
        return this.sort(comparator, 10000);
    }

    public FastqWriterBuilder sort(Comparator<FastqRecord> comparator, int inMemoryCacheSize) {
        return this.sort(comparator, inMemoryCacheSize, null);
    }

    public FastqWriterBuilder sort(Comparator<FastqRecord> comparator, int inMemoryCacheSize, File dir) {
        Objects.requireNonNull(comparator);
        if (inMemoryCacheSize < 1) {
            throw new IllegalArgumentException("in memory cache size must be positive");
        }
        if (dir != null) {
            if (!dir.exists()) {
                throw new IllegalArgumentException("tmpDir does not exist: " + dir.getAbsolutePath());
            }
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("tmpDir is not a directory: " + dir.getAbsolutePath());
            }
        }
        this.comparator = comparator;
        this.inMemoryCacheSize = inMemoryCacheSize;
        this.tmpDir = dir;
        return this;
    }

    @Override
    public FastqWriter build() {
        FastqWriter innerWriter = this.buildInnerWriter();
        if (this.adapterFunction == null) {
            return innerWriter;
        }
        return FastqWriter.adapt(innerWriter, this.adapterFunction);
    }

    private FastqWriter buildInnerWriter() {
        FastqRecordWriterImpl writer = new FastqRecordWriterImpl(this.out, this.charSet, this.codec, this.writeIdOnQualityLine, this.numberOfBasesPerLine);
        if (this.comparator == null) {
            return writer;
        }
        if (this.inMemoryCacheSize == null) {
            return new InMemorySortedFastqWriter(writer, this.comparator);
        }
        return new TmpDirSortedFastqWriter(writer, this.comparator, this.codec, this.tmpDir, this.inMemoryCacheSize);
    }

    private static final class FastqRecordWriterImpl
    implements FastqWriter {
        private final Writer writer;
        private final FastqQualityCodec codec;
        private final boolean writeIdOnQualityLine;
        private final int numberOfBasesPerLine;
        private final StringBuilder tempBuilder = new StringBuilder(2000);

        private FastqRecordWriterImpl(OutputStream out, Charset charset, FastqQualityCodec codec, boolean writeIdOnQualityLine, int numberOfBasesPerLine) {
            this.writer = new OutputStreamWriter(out, charset);
            this.codec = codec;
            this.writeIdOnQualityLine = writeIdOnQualityLine;
            this.numberOfBasesPerLine = numberOfBasesPerLine;
        }

        @Override
        public void close() throws IOException {
            this.writer.flush();
            this.writer.close();
        }

        @Override
        public void write(FastqRecord record) throws IOException {
            this.write(record, null);
        }

        @Override
        public void write(FastqRecord record, Range trimRange) throws IOException {
            if (record instanceof ParsedFastqRecord) {
                String formattedString;
                ParsedFastqRecord parsedRecord = (ParsedFastqRecord)record;
                FastqQualityCodec recordCodec = parsedRecord.getQualityCodec();
                if (this.codec == recordCodec) {
                    formattedString = this.toFormattedString(parsedRecord.getId(), this.encodeNucleotides(parsedRecord.getNucleotideString(), trimRange), this.formatEncodedQualities(parsedRecord.getEncodedQualities(), trimRange), parsedRecord.getComment());
                } else {
                    String reEncodedQualities = this.reEncodeTrimmedQualities(parsedRecord, recordCodec, trimRange);
                    formattedString = this.toFormattedString(parsedRecord.getId(), this.encodeNucleotides(parsedRecord.getNucleotideString(), trimRange), this.formatEncodedQualities(reEncodedQualities, null), parsedRecord.getComment());
                }
                this.writer.write(formattedString);
            } else if (trimRange == null) {
                this.write(record.getId(), record.getNucleotideSequence(), record.getQualitySequence(), record.getComment());
            } else {
                this.write(record.getId(), record.getNucleotideSequence().toBuilder().trim(trimRange).turnOffDataCompression(true).build(), record.getQualitySequence().toBuilder().trim(trimRange).turnOffDataCompression(true).build(), record.getComment());
            }
        }

        private String reEncodeTrimmedQualities(ParsedFastqRecord parsedRecord, FastqQualityCodec recordCodec, Range trimRange) {
            int offsetCorrection = this.codec.getOffset() - recordCodec.getOffset();
            char[] chars = trimRange == null ? parsedRecord.getEncodedQualities().toCharArray() : parsedRecord.getEncodedQualities().substring((int)trimRange.getBegin(), (int)trimRange.getEnd() + 1).toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = (char)(chars[i] + offsetCorrection);
            }
            return new String(chars);
        }

        @Override
        public void write(String id, NucleotideSequence nucleotides, QualitySequence qualities) throws IOException {
            this.write(id, nucleotides, qualities, null);
        }

        @Override
        public void write(String id, NucleotideSequence sequence, QualitySequence qualities, String optionalComment) throws IOException {
            long qualLength;
            if (id == null) {
                throw new NullPointerException("id can not be null");
            }
            if (sequence == null) {
                throw new NullPointerException("nucleotide sequence can not be null");
            }
            if (qualities == null) {
                throw new NullPointerException("quality sequence can not be null");
            }
            long nucLength = sequence.getLength();
            if (nucLength != (qualLength = qualities.getLength())) {
                throw new IllegalArgumentException(String.format("nucleotide and quality sequences must be same length: %d vs %d", nucLength, qualLength));
            }
            String formattedString = this.toFormattedString(id, this.encodeNucleotides(sequence.toString(), null), this.encodeQualities(qualities), optionalComment);
            this.writer.write(formattedString);
        }

        private CharSequence encodeNucleotides(String sequence, Range trimRange) {
            String nucleotidesToWrite;
            String string = nucleotidesToWrite = trimRange == null ? sequence : sequence.substring((int)trimRange.getBegin(), (int)trimRange.getEnd() + 1);
            if (this.numberOfBasesPerLine == -1) {
                return nucleotidesToWrite;
            }
            int numBases = nucleotidesToWrite.length();
            int numberOfLines = numBases / this.numberOfBasesPerLine + 1;
            StringBuilder builder = new StringBuilder(numBases + numberOfLines);
            if (numBases == 0) {
                return builder;
            }
            char[] charArray = nucleotidesToWrite.toCharArray();
            builder.append(charArray[0]);
            for (int i = 1; i < numBases; ++i) {
                if (i % this.numberOfBasesPerLine == 0) {
                    builder.append(FastqWriterBuilder.CR);
                }
                builder.append(charArray[i]);
            }
            return builder;
        }

        private CharSequence encodeQualities(QualitySequence qualities) {
            String encodedQualities = this.codec.encode(qualities);
            return this.formatEncodedQualities(encodedQualities, null);
        }

        private CharSequence formatEncodedQualities(String encodedQualities, Range trimRange) {
            String qualitiesToWrite;
            String string = qualitiesToWrite = trimRange == null ? encodedQualities : encodedQualities.substring((int)trimRange.getBegin(), (int)trimRange.getEnd() + 1);
            if (this.numberOfBasesPerLine == -1) {
                return qualitiesToWrite;
            }
            int numberOfLines = qualitiesToWrite.length() / this.numberOfBasesPerLine + 1;
            StringBuilder builder = new StringBuilder(qualitiesToWrite.length() + numberOfLines);
            for (int i = 0; i < qualitiesToWrite.length(); ++i) {
                if (i > 0 && i % this.numberOfBasesPerLine == 0) {
                    builder.append(FastqWriterBuilder.CR);
                }
                builder.append(qualitiesToWrite.charAt(i));
            }
            return builder;
        }

        private synchronized String toFormattedString(String id, CharSequence sequence, CharSequence encodedQualities, String optionalComment) {
            this.tempBuilder.setLength(0);
            boolean hasComment = optionalComment != null;
            this.tempBuilder.append("@").append(id);
            if (hasComment) {
                this.tempBuilder.append(' ').append(optionalComment);
            }
            this.tempBuilder.append(FastqWriterBuilder.CR).append(sequence).append(FastqWriterBuilder.CR).append('+');
            if (this.writeIdOnQualityLine) {
                this.tempBuilder.append(id);
            }
            this.tempBuilder.append(FastqWriterBuilder.CR).append(encodedQualities).append(FastqWriterBuilder.CR);
            return this.tempBuilder.toString();
        }
    }
}

