/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqWriter;

final class FastqWriterAdapter
implements FastqWriter {
    private final FastqWriter delegate;
    private final Function<FastqRecord, FastqRecord> adapterFunction;

    public FastqWriterAdapter(FastqWriter delegate, Function<FastqRecord, FastqRecord> adapterFunction) {
        this.delegate = Objects.requireNonNull(delegate);
        this.adapterFunction = Objects.requireNonNull(adapterFunction);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void write(FastqRecord record) throws IOException {
        FastqRecord newRecord = this.adapterFunction.apply(record);
        if (newRecord != null) {
            this.delegate.write(newRecord);
        }
    }
}

