/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.ThrowingStream;
import org.jcvi.jillion.internal.core.util.Sneak;
import org.jcvi.jillion.trace.fastq.AbstractFastqVisitor;
import org.jcvi.jillion.trace.fastq.FastqDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileReader;
import org.jcvi.jillion.trace.fastq.FastqParser;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqRecordBuilder;
import org.jcvi.jillion.trace.fastq.FastqRecordVisitor;
import org.jcvi.jillion.trace.fastq.FastqVisitor;
import org.jcvi.jillion.trace.fastq.FastqWriterAdapter;
import org.jcvi.jillion.trace.fastq.FastqWriterBuilder;

public interface FastqWriter
extends Closeable {
    public void write(FastqRecord var1) throws IOException;

    default public void write(FastqRecord record, Range trimRange) throws IOException {
        if (trimRange == null) {
            this.write(record);
            return;
        }
        this.write(record.getId(), record.getNucleotideSequence().toBuilder().trim(trimRange).turnOffDataCompression(true).build(), record.getQualitySequence().toBuilder().trim(trimRange).turnOffDataCompression(true).build(), record.getComment());
    }

    default public void write(String id, NucleotideSequence nucleotides, QualitySequence qualities) throws IOException {
        this.write(id, nucleotides, qualities, null);
    }

    default public void write(String id, NucleotideSequence sequence, QualitySequence qualities, String optionalComment) throws IOException {
        this.write(FastqRecordBuilder.create(id, sequence, qualities, optionalComment).build());
    }

    public static FastqWriter adapt(FastqWriter delegate, Function<FastqRecord, FastqRecord> adapter) {
        return new FastqWriterAdapter(delegate, adapter);
    }

    public static void write(FastqFileDataStore datastore, File outputFile) throws IOException {
        FastqWriter.write(datastore, outputFile, datastore.getQualityCodec());
    }

    public static void write(FastqDataStore datastore, File outputFile, FastqQualityCodec codec) throws IOException {
        Objects.requireNonNull(datastore);
        try (FastqWriter writer = new FastqWriterBuilder(outputFile).qualityCodec(codec).build();
             ThrowingStream<FastqRecord> stream = datastore.records();){
            stream.throwingForEach(writer::write);
        }
    }

    public static void copy(FastqParser in, OutputStream out) throws IOException {
        try (FastqFileReader.Results results = FastqFileReader.read(in);
             FastqWriter writer = new FastqWriterBuilder(out).qualityCodec(results.getCodec()).build();
             ThrowingStream<FastqRecord> stream = results.records();){
            stream.throwingForEach(writer::write);
        }
    }

    public static void copy(FastqParser in, FastqQualityCodec codec, OutputStream out) throws IOException {
        try (FastqWriter writer = new FastqWriterBuilder(out).qualityCodec(codec).build();){
            FastqFileReader.forEach(in, codec, (id, fastq) -> writer.write((FastqRecord)fastq));
        }
    }

    public static void copy(FastqParser in, FastqQualityCodec codec, File out) throws IOException {
        try (FastqWriter writer = new FastqWriterBuilder(out).qualityCodec(codec).build();){
            FastqFileReader.forEach(in, codec, (id, fastq) -> writer.write((FastqRecord)fastq));
        }
    }

    public static void copy(FastqParser in, File out) throws IOException {
        try (FastqFileReader.Results results = FastqFileReader.read(in);
             FastqWriter writer = new FastqWriterBuilder(out).qualityCodec(results.getCodec()).build();
             ThrowingStream<FastqRecord> stream = results.records();){
            stream.throwingForEach(writer::write);
        }
    }

    public static void copy(FastqParser in, OutputStream out, Predicate<FastqRecord> filter) throws IOException {
        try (FastqFileReader.Results results = FastqFileReader.read(in);
             FastqWriter writer = new FastqWriterBuilder(out).qualityCodec(results.getCodec()).build();
             ThrowingStream<FastqRecord> stream = results.records();){
            stream.filter((Predicate)filter).throwingForEach(writer::write);
        }
    }

    public static void copy(FastqParser in, File out, Predicate<FastqRecord> filter) throws IOException {
        try (FastqFileReader.Results results = FastqFileReader.read(in);
             FastqWriter writer = new FastqWriterBuilder(out).qualityCodec(results.getCodec()).build();
             ThrowingStream<FastqRecord> stream = results.records();){
            stream.filter((Predicate)filter).throwingForEach(writer::write);
        }
    }

    public static void copy(FastqParser in, FastqQualityCodec codec, OutputStream out, Predicate<FastqRecord> filter) throws IOException {
        try (FastqWriter writer = new FastqWriterBuilder(out).qualityCodec(codec).build();){
            FastqFileReader.forEach(in, codec, filter, (id, record) -> writer.write((FastqRecord)record));
        }
    }

    public static void copy(FastqParser in, FastqQualityCodec codec, File out, Predicate<FastqRecord> filter) throws IOException {
        try (FastqWriter writer = new FastqWriterBuilder(out).qualityCodec(codec).build();){
            FastqFileReader.forEach(in, codec, filter, (id, record) -> writer.write((FastqRecord)record));
        }
    }

    public static void copyById(FastqParser in, OutputStream out, final Predicate<String> idFilter) throws IOException {
        try (final BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));){
            in.parse(new AbstractFastqVisitor(){
                StringBuilder builder = new StringBuilder(2000);

                @Override
                public FastqRecordVisitor visitDefline(FastqVisitor.FastqVisitorCallback callback, String id, String optionalComment) {
                    if (idFilter.test(id)) {
                        this.builder.setLength(0);
                        this.builder.append('@').append(id);
                        if (optionalComment != null) {
                            this.builder.append(' ').append(optionalComment);
                        }
                        this.builder.append('\n');
                        return new FastqRecordVisitor(){

                            @Override
                            public void visitQualities(QualitySequence qualities) {
                                this.visitEncodedQualities(FastqQualityCodec.getDefault().encode(qualities));
                            }

                            @Override
                            public void visitNucleotides(String nucleotides) {
                                builder.append(nucleotides).append('\n');
                            }

                            @Override
                            public void visitEnd() {
                                try {
                                    writer.write(builder.toString());
                                }
                                catch (IOException e) {
                                    Sneak.sneakyThrow(e);
                                }
                            }

                            @Override
                            public void visitEncodedQualities(String encodedQualities) {
                                builder.append("+\n").append(encodedQualities).append('\n');
                            }

                            @Override
                            public void halted() {
                            }
                        };
                    }
                    return null;
                }
            });
        }
    }
}

