/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.trace.fastq.FastqFileParser;
import org.jcvi.jillion.trace.fastq.FastqParser;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecordVisitor;
import org.jcvi.jillion.trace.fastq.FastqVisitor;

public final class FastqUtil {
    public static final Pattern SEQ_DEFLINE_PATTERN = Pattern.compile("^@(\\S+)(\\s+)?(.+$)?");

    private FastqUtil() {
    }

    public static FastqQualityCodec guessQualityCodecUsed(File fastqFile) throws IOException {
        return FastqUtil.guessQualityCodecUsed(fastqFile, Integer.MAX_VALUE);
    }

    public static FastqQualityCodec guessQualityCodecUsed(File fastqFile, int numberOfReadsToInspect) throws IOException {
        if (numberOfReadsToInspect < 1) {
            throw new IllegalArgumentException("number of reads to inspect must be >=1");
        }
        FastqQualityCodecDetectorVisitor detectorVisitor = new FastqQualityCodecDetectorVisitor(numberOfReadsToInspect);
        FastqFileParser.create(InputStreamSupplier.forFile(fastqFile), false, true, false).parse(detectorVisitor);
        return detectorVisitor.getDetectedCodec();
    }

    public static FastqQualityCodec guessQualityCodecUsed(FastqParser parser) throws IOException {
        return FastqUtil.guessQualityCodecUsed(parser, Integer.MAX_VALUE);
    }

    public static FastqQualityCodec guessQualityCodecUsed(FastqParser parser, int numberOfReadsToInspect) throws IOException {
        if (numberOfReadsToInspect < 1) {
            throw new IllegalArgumentException("number of reads to inspect must be >=1");
        }
        FastqQualityCodecDetectorVisitor detectorVisitor = new FastqQualityCodecDetectorVisitor(numberOfReadsToInspect);
        parser.parse(detectorVisitor);
        return detectorVisitor.getDetectedCodec();
    }

    static FastqQualityCodec guessQualityCodecUsed(String encodedQualities) {
        if (encodedQualities.isEmpty()) {
            return null;
        }
        int sangerOffset = FastqQualityCodec.SANGER.getOffset();
        boolean hasSolexaOnlyValues = false;
        int maxQuality = Integer.MIN_VALUE;
        int minQuality = Integer.MAX_VALUE;
        char[] chars = encodedQualities.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            int asciiValue = chars[i];
            if (asciiValue < sangerOffset) {
                throw new IllegalArgumentException(String.format("invalid encoded qualities has out of range ascii value %d : '%s'", asciiValue, encodedQualities));
            }
            if (asciiValue < 59) {
                return FastqQualityCodec.SANGER;
            }
            if (asciiValue < 64) {
                hasSolexaOnlyValues = true;
            }
            if (asciiValue > maxQuality) {
                maxQuality = asciiValue;
            }
            if (asciiValue >= minQuality) continue;
            minQuality = asciiValue;
        }
        if (maxQuality < sangerOffset + 41) {
            return FastqQualityCodec.SANGER;
        }
        if (hasSolexaOnlyValues) {
            return FastqQualityCodec.SOLEXA;
        }
        return FastqQualityCodec.ILLUMINA;
    }

    private static class MixedFastqEncodings
    extends IOException {
        private static final long serialVersionUID = 1L;

        MixedFastqEncodings(long numSanger, long numSolexa, long numIllumina, long numEither) {
            super(String.format("many reads are encoded differently #sanger =%d #illuminia = %d #either = %d", numSanger, numIllumina, numSolexa + numEither));
        }
    }

    private static final class FastqQualityCodecDetectorRecordVisitor
    implements FastqRecordVisitor {
        private long numSanger = 0L;
        private long numIllumina = 0L;
        private long numPossiblySolexa = 0L;
        private long numEither = 0L;
        private int overAllMin = Integer.MAX_VALUE;
        private int overallMax = Integer.MIN_VALUE;

        private FastqQualityCodecDetectorRecordVisitor() {
        }

        @Override
        public void visitNucleotides(String nucleotides) {
        }

        @Override
        public void visitEncodedQualities(String encodedQualities) {
            boolean hasSolexaOnlyValues = false;
            int maxQuality = Integer.MIN_VALUE;
            char[] chars = encodedQualities.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                int asciiValue = chars[i];
                if (asciiValue < 33) {
                    throw new IllegalArgumentException(String.format("invalid encoded qualities has out of range ascii value %d : '%s'", asciiValue, encodedQualities));
                }
                if (asciiValue > maxQuality) {
                    maxQuality = asciiValue;
                }
                if (asciiValue > this.overallMax) {
                    this.overallMax = asciiValue;
                }
                if (asciiValue < this.overAllMin) {
                    this.overAllMin = asciiValue;
                }
                if (asciiValue < 59) {
                    ++this.numSanger;
                    return;
                }
                if (asciiValue >= 64) continue;
                hasSolexaOnlyValues = true;
            }
            if (maxQuality > 80) {
                if (hasSolexaOnlyValues) {
                    ++this.numPossiblySolexa;
                } else {
                    ++this.numIllumina;
                }
            } else {
                ++this.numEither;
            }
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        public FastqQualityCodec getMostFrequentCodec() throws MixedFastqEncodings {
            if (this.numSanger == 0L && this.numPossiblySolexa == 0L && this.numIllumina == 0L && this.numEither == 0L) {
                throw new IllegalStateException("fastq file must not be empty");
            }
            if (this.numSanger > 0L && this.numIllumina > 0L) {
                throw new MixedFastqEncodings(this.numSanger, this.numPossiblySolexa, this.numIllumina, this.numEither);
            }
            if (this.numSanger > 0L) {
                return FastqQualityCodec.SANGER;
            }
            if (this.numIllumina == 0L && this.overallMax < FastqQualityCodec.SANGER.getOffset() + 41) {
                return FastqQualityCodec.SANGER;
            }
            if (this.numPossiblySolexa > 0L) {
                return FastqQualityCodec.SOLEXA;
            }
            return FastqQualityCodec.ILLUMINA;
        }

        @Override
        public void visitQualities(QualitySequence qualities) {
        }
    }

    private static final class FastqQualityCodecDetectorVisitor
    implements FastqVisitor {
        private int numberOfRecordsVisited = 0;
        private final int maxNumberOfRecordsToVisit;
        FastqQualityCodecDetectorRecordVisitor recordVisitor = new FastqQualityCodecDetectorRecordVisitor();

        public FastqQualityCodecDetectorVisitor(int maxNumberOfRecordsToVisit) {
            this.maxNumberOfRecordsToVisit = maxNumberOfRecordsToVisit;
        }

        public FastqQualityCodec getDetectedCodec() throws MixedFastqEncodings {
            return this.recordVisitor.getMostFrequentCodec();
        }

        @Override
        public FastqRecordVisitor visitDefline(FastqVisitor.FastqVisitorCallback callback, String id, String optionalComment) {
            if (this.numberOfRecordsVisited < this.maxNumberOfRecordsToVisit) {
                ++this.numberOfRecordsVisited;
                return this.recordVisitor;
            }
            callback.haltParsing();
            return null;
        }

        @Override
        public void halted() {
        }

        @Override
        public void visitEnd() {
        }
    }
}

