/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.util.Objects;
import java.util.Optional;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.trace.fastq.CommentedFastqRecord;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqRecordBuilder;
import org.jcvi.jillion.trace.fastq.UncommentedFastqRecord;

final class FastqRecordBuilderImpl
implements FastqRecordBuilder {
    private String comments = null;
    private String id;
    private NucleotideSequence basecalls;
    private QualitySequence qualities;
    private boolean lengthsModified = false;

    public FastqRecordBuilderImpl(FastqRecord record) {
        this.id = record.getId();
        this.basecalls = record.getNucleotideSequence();
        this.qualities = record.getQualitySequence();
        this.comments = record.getComment();
        this.assertValidLength(this.basecalls, this.qualities);
    }

    public FastqRecordBuilderImpl(String id, NucleotideSequence basecalls, QualitySequence qualities) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        if (basecalls == null) {
            throw new NullPointerException("basecalls can not be null");
        }
        if (qualities == null) {
            throw new NullPointerException("qualities can not be null");
        }
        this.assertValidLength(basecalls, qualities);
        this.id = id;
        this.basecalls = basecalls;
        this.qualities = qualities;
    }

    private void assertValidLength(NucleotideSequence basecalls, QualitySequence qualities) {
        long qualityLength;
        long basecallLength = basecalls.getLength();
        if (basecallLength != (qualityLength = qualities.getLength())) {
            throw new IllegalArgumentException(String.format("basecalls and qualities must have the same length! %d vs %d", basecallLength, qualityLength));
        }
    }

    @Override
    public FastqRecordBuilderImpl comment(String comments) {
        this.comments = comments;
        return this;
    }

    @Override
    public FastqRecord build() {
        if (this.lengthsModified) {
            this.assertValidLength(this.basecalls, this.qualities);
        }
        if (this.comments == null) {
            return new UncommentedFastqRecord(this.id, this.basecalls, this.qualities);
        }
        return new CommentedFastqRecord(this.id, this.basecalls, this.qualities, this.comments);
    }

    @Override
    public Optional<String> comment() {
        return Optional.ofNullable(this.comments);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public FastqRecordBuilder id(String id) {
        this.id = Objects.requireNonNull(id);
        return this;
    }

    @Override
    public NucleotideSequence basecalls() {
        return this.basecalls;
    }

    @Override
    public FastqRecordBuilder basecalls(NucleotideSequence basecalls) {
        this.basecalls = Objects.requireNonNull(basecalls);
        this.lengthsModified = true;
        return this;
    }

    @Override
    public QualitySequence qualities() {
        return this.qualities;
    }

    @Override
    public FastqRecordBuilder qualities(QualitySequence qualities) {
        this.qualities = Objects.requireNonNull(qualities);
        this.lengthsModified = true;
        return this;
    }

    @Override
    public FastqRecordBuilder trim(Range trimRange) {
        this.basecalls = this.basecalls.toBuilder().trim(trimRange).build();
        this.qualities = this.qualities.toBuilder().trim(trimRange).build();
        this.lengthsModified = true;
        return this;
    }
}

