/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import org.jcvi.jillion.core.Sequence;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.trace.fastq.SolexaUtil;

public enum FastqQualityCodec {
    ILLUMINA(64),
    SANGER(33),
    SOLEXA(64){

        @Override
        public PhredQuality decode(char encodedQuality) {
            int solexaQuality = encodedQuality - 64;
            return SolexaUtil.convertSolexaQualityToPhredQuality(solexaQuality);
        }

        @Override
        public char encode(PhredQuality quality) {
            int solexaQuality = SolexaUtil.convertPhredQualityToSolexaQuality(quality);
            return (char)(solexaQuality + 64);
        }

        @Override
        public QualitySequence decode(String fastqQualities) {
            QualitySequenceBuilder builder = new QualitySequenceBuilder(fastqQualities.length());
            for (int i = 0; i < fastqQualities.length(); ++i) {
                builder.append(SolexaUtil.convertSolexaQualityToPhredQuality(fastqQualities.charAt(i) - 64));
            }
            return builder.build();
        }
    };

    private final int offset;

    public static FastqQualityCodec getDefault() {
        return SANGER;
    }

    public QualitySequence decode(String fastqQualities) {
        return this.decode(fastqQualities, false);
    }

    public QualitySequence decode(String fastqQualities, boolean turnOffCompression) {
        byte[] buffer = new byte[fastqQualities.length()];
        for (int i = 0; i < fastqQualities.length(); ++i) {
            buffer[i] = (byte)(fastqQualities.charAt(i) - this.offset);
        }
        return new QualitySequenceBuilder(buffer).turnOffDataCompression(turnOffCompression).build();
    }

    private FastqQualityCodec(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public PhredQuality decode(char encodedQuality) {
        return PhredQuality.valueOf(encodedQuality - this.offset);
    }

    public char encode(PhredQuality quality) {
        return (char)(quality.getQualityScore() + this.offset);
    }

    public String encode(Sequence<PhredQuality> qualities) {
        StringBuilder builder = new StringBuilder();
        for (PhredQuality quality : qualities) {
            builder.append(this.encode(quality));
        }
        return builder.toString();
    }
}

