/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.core.util.ThrowingStream;
import org.jcvi.jillion.core.util.streams.ThrowingBiConsumer;
import org.jcvi.jillion.trace.fastq.FastqFileDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileDataStoreBuilder;
import org.jcvi.jillion.trace.fastq.FastqParser;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecord;

public final class FastqFileReader {
    private FastqFileReader() {
    }

    public static <E extends Throwable> void forEach(File fastqFile, ThrowingBiConsumer<String, FastqRecord, E> consumer) throws IOException, E {
        Objects.requireNonNull(consumer, "consumer can not be null");
        try (FastqFileDataStore datastore = new FastqFileDataStoreBuilder(fastqFile).hint(DataStoreProviderHint.ITERATION_ONLY).build();){
            datastore.forEach(consumer);
        }
    }

    public static <E extends Throwable> void forEach(FastqParser fastqParser, ThrowingBiConsumer<String, FastqRecord, E> consumer) throws IOException, E {
        Objects.requireNonNull(consumer, "consumer can not be null");
        try (FastqFileDataStore datastore = new FastqFileDataStoreBuilder(fastqParser).hint(DataStoreProviderHint.ITERATION_ONLY).build();){
            datastore.forEach(consumer);
        }
    }

    public static <E extends Throwable> void forEach(FastqParser fastqParser, FastqQualityCodec codec, ThrowingBiConsumer<String, FastqRecord, E> consumer) throws IOException, E {
        Objects.requireNonNull(consumer, "consumer can not be null");
        try (FastqFileDataStore datastore = new FastqFileDataStoreBuilder(fastqParser).qualityCodec(codec).hint(DataStoreProviderHint.ITERATION_ONLY).build();){
            datastore.forEach(consumer);
        }
    }

    public static <E extends Throwable> void forEach(FastqParser fastqParser, FastqQualityCodec codec, Predicate<String> idFilter, Predicate<FastqRecord> recordFilter, ThrowingBiConsumer<String, FastqRecord, E> consumer) throws IOException, E {
        FastqFileReader._forEach(fastqParser, codec, idFilter, recordFilter, consumer);
    }

    public static <E extends Throwable> void forEach(FastqParser fastqParser, FastqQualityCodec codec, Predicate<FastqRecord> recordFilter, ThrowingBiConsumer<String, FastqRecord, E> consumer) throws IOException, E {
        FastqFileReader._forEach(fastqParser, codec, null, recordFilter, consumer);
    }

    public static <E extends Throwable> void forEach(FastqParser fastqParser, Predicate<String> idFilter, Predicate<FastqRecord> recordFilter, ThrowingBiConsumer<String, FastqRecord, E> consumer) throws IOException, E {
        FastqFileReader._forEach(fastqParser, null, idFilter, recordFilter, consumer);
    }

    public static <E extends Throwable> void forEach(FastqParser fastqParser, Predicate<FastqRecord> recordFilter, ThrowingBiConsumer<String, FastqRecord, E> consumer) throws IOException, E {
        FastqFileReader._forEach(fastqParser, null, null, recordFilter, consumer);
    }

    private static <E extends Throwable> void _forEach(FastqParser fastqParser, FastqQualityCodec codec, Predicate<String> idFilter, Predicate<FastqRecord> recordFilter, ThrowingBiConsumer<String, FastqRecord, E> consumer) throws IOException, E {
        Objects.requireNonNull(consumer, "consumer can not be null");
        FastqFileDataStoreBuilder builder = new FastqFileDataStoreBuilder(fastqParser).hint(DataStoreProviderHint.ITERATION_ONLY);
        if (idFilter != null) {
            builder.filter(idFilter);
        }
        if (recordFilter != null) {
            builder.filterRecords(recordFilter);
        }
        if (codec != null) {
            builder.qualityCodec(codec);
        }
        try (FastqFileDataStore datastore = builder.build();){
            datastore.forEach(consumer);
        }
    }

    public static <E extends Throwable> void forEach(File fastqFile, FastqQualityCodec codec, ThrowingBiConsumer<String, FastqRecord, E> consumer) throws IOException, E {
        Objects.requireNonNull(consumer, "consumer can not be null");
        try (FastqFileDataStore datastore = new FastqFileDataStoreBuilder(fastqFile).qualityCodec(codec).hint(DataStoreProviderHint.ITERATION_ONLY).build();){
            datastore.forEach(consumer);
        }
    }

    public static Results read(File fastqFile) throws IOException {
        FastqFileDataStore datastore = new FastqFileDataStoreBuilder(fastqFile).hint(DataStoreProviderHint.ITERATION_ONLY).build();
        return new Results(datastore);
    }

    public static Results read(FastqParser fastqParser) throws IOException {
        FastqFileDataStore datastore = new FastqFileDataStoreBuilder(fastqParser).hint(DataStoreProviderHint.ITERATION_ONLY).build();
        return new Results(datastore);
    }

    public static Results read(File fastqFile, FastqQualityCodec codec) throws IOException {
        FastqFileDataStore datastore = new FastqFileDataStoreBuilder(fastqFile).qualityCodec(codec).hint(DataStoreProviderHint.ITERATION_ONLY).build();
        return new Results(datastore);
    }

    public static Results read(FastqParser fastqParser, FastqQualityCodec codec) throws IOException {
        FastqFileDataStore datastore = new FastqFileDataStoreBuilder(fastqParser).qualityCodec(codec).hint(DataStoreProviderHint.ITERATION_ONLY).build();
        return new Results(datastore);
    }

    public static final class Results
    implements Closeable {
        private final FastqFileDataStore datastore;

        private Results(FastqFileDataStore datastore) {
            this.datastore = datastore;
        }

        public ThrowingStream<FastqRecord> records() throws IOException {
            return this.datastore.records();
        }

        public FastqQualityCodec getCodec() {
            return this.datastore.getQualityCodec();
        }

        public <E extends Throwable> void forEach(ThrowingBiConsumer<String, FastqRecord, E> consumer) throws E, IOException {
            this.datastore.forEach(consumer);
        }

        @Override
        public void close() throws IOException {
            this.datastore.close();
        }
    }
}

