/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.trace.fastq.FastqFileParser;
import org.jcvi.jillion.trace.fastq.FastqParser;

public final class FastqFileParserBuilder {
    private final InputStreamSupplier inputStreamSupplier;
    private final InputStream in;
    private boolean hasComments;
    private boolean multiline;
    private final boolean mementoSupport;

    public FastqFileParserBuilder(InputStream in) {
        Objects.requireNonNull(in, "Inputstream can not be null");
        this.mementoSupport = false;
        this.in = in;
        this.inputStreamSupplier = null;
    }

    public FastqFileParserBuilder(File fastqFile) throws IOException {
        this(InputStreamSupplier.forFile(fastqFile), false);
    }

    public FastqFileParserBuilder(File fastqFile, boolean mementoSupport) throws IOException {
        this(InputStreamSupplier.forFile(fastqFile), mementoSupport);
    }

    public FastqFileParserBuilder(InputStreamSupplier inputStreamSupplier, boolean mementoSupport) {
        Objects.requireNonNull(inputStreamSupplier);
        this.in = null;
        this.inputStreamSupplier = inputStreamSupplier;
        this.mementoSupport = mementoSupport;
    }

    public FastqFileParserBuilder hasComments(boolean hasComments) {
        this.hasComments = hasComments;
        return this;
    }

    public FastqFileParserBuilder hasMultilineSequences(boolean multiline) {
        this.multiline = multiline;
        return this;
    }

    public FastqParser build() throws IOException {
        if (this.in == null) {
            return FastqFileParser.create(this.inputStreamSupplier, this.hasComments, this.multiline, this.mementoSupport);
        }
        return FastqFileParser.create(this.in, this.hasComments, this.multiline);
    }
}

