/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.internal.core.io.LineParser;
import org.jcvi.jillion.internal.core.io.OpenAwareInputStream;
import org.jcvi.jillion.internal.core.io.PositionlessLineParser;
import org.jcvi.jillion.internal.core.io.TextLineParser;
import org.jcvi.jillion.trace.fastq.FastqParser;
import org.jcvi.jillion.trace.fastq.FastqRecordVisitor;
import org.jcvi.jillion.trace.fastq.FastqUtil;
import org.jcvi.jillion.trace.fastq.FastqVisitor;

public abstract class FastqFileParser
implements FastqParser {
    private static final Pattern CASAVA_1_8_DEFLINE_PATTERN = Pattern.compile("^@(\\S+\\s+\\d:[N|Y]:\\d+:(\\S+)?)\\s*$");
    private final StringBuilder sequenceBuilder = new StringBuilder(2000);
    private final StringBuilder qualityBuilder = new StringBuilder(2000);
    private final boolean hasComments;
    private final boolean multiLine;

    public static FastqParser create(InputStream in) {
        return FastqFileParser.create(in, false, false);
    }

    public static FastqParser create(File fastq) throws IOException {
        return FastqFileParser.create(InputStreamSupplier.forFile(fastq), false, false, false);
    }

    static FastqParser create(InputStream in, boolean hasComments, boolean multiLine) {
        return new InputStreamFastqFileParser(in, hasComments, multiLine);
    }

    static FastqFileParser create(InputStreamSupplier supplier, boolean hasComments, boolean multiLine, boolean trackPosition) throws IOException {
        return new FileBasedFastqFileParser(supplier, hasComments, multiLine, trackPosition);
    }

    private FastqFileParser(boolean hasComments, boolean multiLine) {
        this.hasComments = hasComments;
        this.multiLine = multiLine;
    }

    void parseFastqFile(FastqVisitor visitor, LineParser parser) throws IOException {
        ParserState parserState;
        ParserState parserState2 = parserState = parser.tracksPosition() ? new ParserState(parser.getPosition()) : new ParserState(0L);
        while (parserState.keepParsing() && parser.hasNextLine()) {
            parserState = this.parseNextRecord(visitor, parser, parserState);
        }
        if (parserState.keepParsing()) {
            visitor.visitEnd();
        } else {
            visitor.halted();
        }
    }

    private ParserState parseNextRecord(FastqVisitor visitor, LineParser parser, ParserState parserState) throws IOException {
        FastqRecordVisitor recordVisitor;
        String id;
        String deflineText = parser.nextLine();
        AbstractFastqVisitorCallback callback = this.createCallback(parserState);
        if (this.hasComments) {
            Defline defline = Defline.parse(deflineText);
            id = defline.getId();
            recordVisitor = visitor.visitDefline(callback, id, defline.getComment());
        } else {
            if (deflineText.charAt(0) != '@') {
                throw new IllegalStateException(String.format("invalid fastq file, could not parse seq id from '%s'", deflineText));
            }
            id = deflineText.substring(1).trim();
            recordVisitor = visitor.visitDefline(callback, id, null);
        }
        if (!parserState.keepParsing()) {
            return parserState;
        }
        return this.parseRecordBody(parser, recordVisitor, parserState, id);
    }

    private ParserState parseRecordBody(LineParser parser, FastqRecordVisitor recordVisitor, ParserState parserState, String currentId) throws IOException {
        String qualDefline;
        if (recordVisitor == null) {
            this.skipCurrentRecord(parser);
            return parserState.updatePosition(parser);
        }
        String line = parser.nextLine();
        if (line == null) {
            throw new IOException(String.format("unexpected end of file. no sequence for current record '%s'", currentId));
        }
        this.sequenceBuilder.append(line.trim());
        boolean inBasecallBlock = this.multiLine;
        while (inBasecallBlock) {
            line = parser.nextLine();
            inBasecallBlock = this.notQualityDefLine(line);
            if (!inBasecallBlock) continue;
            this.sequenceBuilder.append(line.trim());
        }
        recordVisitor.visitNucleotides(this.sequenceBuilder.toString());
        if (!parserState.keepParsing()) {
            recordVisitor.halted();
            return parserState.updatePosition(parser);
        }
        if (!(this.multiLine || (qualDefline = parser.nextLine()) != null && qualDefline.charAt(0) == '+')) {
            throw new IOException("invalid quality defline. should start with '+' but was " + qualDefline);
        }
        int expectedQualities = this.sequenceBuilder.length();
        this.sequenceBuilder.setLength(0);
        this.qualityBuilder.setLength(0);
        do {
            if ((line = parser.nextLine()) == null) {
                throw new IOException(String.format("too few quality values for current record '%s' : expected %d but was %d", currentId, expectedQualities, this.qualityBuilder.length()));
            }
            this.qualityBuilder.append(line.trim());
        } while (this.qualityBuilder.length() < expectedQualities);
        if (this.qualityBuilder.length() > expectedQualities) {
            throw new IOException(String.format("incorrect number of quality values for current record: expected %d but was %d if there are too few qualities the parser may have read into the next record", expectedQualities, this.qualityBuilder.length()));
        }
        recordVisitor.visitEncodedQualities(this.qualityBuilder.toString());
        ParserState endParserState = parserState.updatePosition(parser);
        if (endParserState.keepParsing()) {
            recordVisitor.visitEnd();
        } else {
            recordVisitor.halted();
        }
        return endParserState;
    }

    private void skipCurrentRecord(LineParser parser) throws IOException {
        if (this.multiLine) {
            int numberOfQualitiesLeft;
            String line = parser.nextLine();
            int numberOfBasesSeen = 0;
            while (this.notQualityDefLine(line)) {
                numberOfBasesSeen += line.trim().length();
                line = parser.nextLine();
            }
            if (numberOfBasesSeen == 0) {
                parser.nextLine();
                return;
            }
            for (numberOfQualitiesLeft = numberOfBasesSeen; numberOfQualitiesLeft > 0; numberOfQualitiesLeft -= line.trim().length()) {
                line = parser.nextLine();
            }
            if (numberOfQualitiesLeft < 0) {
                throw new IOException(String.format("too many quality values for current record: expected %d but was %d", numberOfBasesSeen, numberOfBasesSeen - numberOfQualitiesLeft));
            }
        } else {
            parser.nextLine();
            parser.nextLine();
            parser.nextLine();
        }
    }

    private boolean notQualityDefLine(String line) {
        return line.charAt(0) != '+';
    }

    protected abstract AbstractFastqVisitorCallback createCallback(ParserState var1);

    private static class LongWidthOffsetMemento
    extends OffsetMemento {
        private final long value;

        public LongWidthOffsetMemento(long value) {
            this.value = value;
        }

        @Override
        public long getValue() {
            return this.value;
        }
    }

    private static class IntWidthOffsetMemento
    extends OffsetMemento {
        private final int value;

        public IntWidthOffsetMemento(long value) {
            this.value = IOUtil.toSignedInt(value);
        }

        @Override
        public long getValue() {
            return IOUtil.toUnsignedInt(this.value);
        }
    }

    private static class ShortWidthOffsetMemento
    extends OffsetMemento {
        private final short value;

        public ShortWidthOffsetMemento(long value) {
            this.value = IOUtil.toSignedShort((int)value);
        }

        @Override
        public long getValue() {
            return IOUtil.toUnsignedShort(this.value);
        }
    }

    private static class ByteWidthOffsetMemento
    extends OffsetMemento {
        private final byte value;

        public ByteWidthOffsetMemento(long value) {
            this.value = IOUtil.toSignedByte((int)value);
        }

        @Override
        public long getValue() {
            return IOUtil.toUnsignedByte(this.value);
        }
    }

    public static abstract class OffsetMemento
    implements FastqVisitor.FastqVisitorCallback.FastqVisitorMemento {
        private static final long UNSIGNED_MAX_BYTE = 255L;
        private static final long UNSIGNED_MAX_SHORT = 65535L;
        private static final long UNSIGNED_MAX_INT = 0xFFFFFFFFL;

        public static OffsetMemento valueOf(long value) {
            if (value < 0L) {
                throw new IllegalArgumentException("can not have negative offset");
            }
            if (value <= 255L) {
                return new ByteWidthOffsetMemento(value);
            }
            if (value <= 65535L) {
                return new ShortWidthOffsetMemento(value);
            }
            if (value <= 0xFFFFFFFFL) {
                return new IntWidthOffsetMemento(value);
            }
            return new LongWidthOffsetMemento(value);
        }

        public abstract long getValue();

        public String toString() {
            return Long.toString(this.getValue());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof OffsetMemento) {
                return this.getValue() == ((OffsetMemento)obj).getValue();
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            long value = this.getValue();
            return 31 * (int)(value ^ value >>> 32);
        }
    }

    private static class InputStreamFastqFileParser
    extends FastqFileParser {
        private final OpenAwareInputStream in;

        public InputStreamFastqFileParser(InputStream in, boolean hasComments, boolean multiLine) {
            super(hasComments, multiLine);
            if (in == null) {
                throw new NullPointerException("inputstream can not be null");
            }
            this.in = new OpenAwareInputStream(in);
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public boolean isReadOnceOnly() {
            return true;
        }

        @Override
        public synchronized void parse(FastqVisitor visitor) throws IOException {
            if (!this.canParse()) {
                throw new IllegalStateException("can not accept, inputStream closed");
            }
            if (visitor == null) {
                throw new NullPointerException("visitor can not be null");
            }
            try {
                PositionlessLineParser parser = new PositionlessLineParser(this.in);
                this.parseFastqFile(visitor, parser);
            }
            finally {
                IOUtil.closeAndIgnoreErrors((Closeable)this.in);
            }
        }

        @Override
        public boolean canParse() {
            return this.in.isOpen();
        }

        @Override
        public void parse(FastqVisitor visitor, FastqVisitor.FastqVisitorCallback.FastqVisitorMemento memento) throws IOException {
            throw new UnsupportedOperationException("mementos not supported");
        }

        @Override
        protected AbstractFastqVisitorCallback createCallback(ParserState parserState) {
            return new NoMementoCallback(parserState);
        }

        @Override
        public Optional<File> getFile() {
            return Optional.empty();
        }
    }

    private static class FileBasedFastqFileParser
    extends FastqFileParser {
        private final InputStreamSupplier supplier;
        private final boolean trackPosition;

        public FileBasedFastqFileParser(InputStreamSupplier supplier, boolean hasComments, boolean multiLine, boolean trackPosition) throws IOException {
            super(hasComments, multiLine);
            Objects.requireNonNull(supplier);
            this.trackPosition = trackPosition;
            this.supplier = supplier;
        }

        @Override
        public Optional<File> getFile() {
            return this.supplier.getFile();
        }

        @Override
        public boolean canCreateMemento() {
            return true;
        }

        @Override
        public boolean isReadOnceOnly() {
            return false;
        }

        @Override
        public boolean canParse() {
            return true;
        }

        @Override
        protected AbstractFastqVisitorCallback createCallback(ParserState parserState) {
            return new MementoCallback(parserState);
        }

        @Override
        public void parse(FastqVisitor visitor) throws IOException {
            if (visitor == null) {
                throw new NullPointerException("visitor can not be null");
            }
            try (InputStream in = this.supplier.get();){
                LineParser parser = this.trackPosition ? new TextLineParser(in) : new PositionlessLineParser(in);
                this.parseFastqFile(visitor, parser);
            }
        }

        @Override
        public void parse(FastqVisitor visitor, FastqVisitor.FastqVisitorCallback.FastqVisitorMemento memento) throws IOException {
            if (!(memento instanceof OffsetMemento)) {
                throw new IllegalArgumentException("unknown memento type, instance must be generated by this parser");
            }
            if (visitor == null) {
                throw new NullPointerException("visitor can not be null");
            }
            long startOffset = ((OffsetMemento)memento).getValue();
            try (InputStream in = this.supplier.get(startOffset);){
                TextLineParser parser = new TextLineParser(in, startOffset);
                this.parseFastqFile(visitor, parser);
            }
        }
    }

    private static class ParserState {
        private final long currentOffset;
        private final AtomicBoolean keepParsing;

        ParserState(long startOffset) {
            this(startOffset, new AtomicBoolean(true));
        }

        public final long getCurrentOffset() {
            return this.currentOffset;
        }

        private ParserState(long startOffset, AtomicBoolean keepParsing) {
            this.currentOffset = startOffset;
            this.keepParsing = keepParsing;
        }

        void stopParsing() {
            this.keepParsing.set(false);
        }

        public boolean keepParsing() {
            return this.keepParsing.get();
        }

        ParserState setOffset(long newOffset) {
            return new ParserState(newOffset, this.keepParsing);
        }

        ParserState updatePosition(LineParser parser) {
            if (parser.tracksPosition()) {
                return this.setOffset(parser.getPosition());
            }
            return this;
        }
    }

    private static class MementoCallback
    extends AbstractFastqVisitorCallback {
        public MementoCallback(ParserState parserState) {
            super(parserState);
        }

        @Override
        public boolean canCreateMemento() {
            return true;
        }

        @Override
        public FastqVisitor.FastqVisitorCallback.FastqVisitorMemento createMemento() {
            return OffsetMemento.valueOf(this.getParserState().getCurrentOffset());
        }
    }

    private static class NoMementoCallback
    extends AbstractFastqVisitorCallback {
        public NoMementoCallback(ParserState parserState) {
            super(parserState);
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public FastqVisitor.FastqVisitorCallback.FastqVisitorMemento createMemento() {
            throw new UnsupportedOperationException("can not create memento");
        }
    }

    private static abstract class AbstractFastqVisitorCallback
    implements FastqVisitor.FastqVisitorCallback {
        private final ParserState parserState;

        public AbstractFastqVisitorCallback(ParserState parserState) {
            this.parserState = parserState;
        }

        @Override
        public void haltParsing() {
            this.parserState.stopParsing();
        }

        final ParserState getParserState() {
            return this.parserState;
        }
    }

    private static final class Defline {
        private final String id;
        private final String comment;

        private Defline(String id, String comment) {
            this.id = id;
            this.comment = comment;
        }

        public static Defline parse(String fastqDefline) {
            Matcher casava18Matcher = CASAVA_1_8_DEFLINE_PATTERN.matcher(fastqDefline);
            if (casava18Matcher.matches()) {
                return new Defline(casava18Matcher.group(1), null);
            }
            Matcher beginSeqMatcher = FastqUtil.SEQ_DEFLINE_PATTERN.matcher(fastqDefline);
            if (!beginSeqMatcher.find()) {
                throw new IllegalStateException(String.format("invalid fastq file, could not parse seq id from '%s'", fastqDefline));
            }
            return new Defline(beginSeqMatcher.group(1), beginSeqMatcher.group(3));
        }

        public String getId() {
            return this.id;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

