/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.trace.fastq.FastqDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileDataStore;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecord;

final class FastqFileDataStoreImpl
implements FastqFileDataStore {
    private final FastqDataStore datastore;
    private final FastqQualityCodec codec;
    private final File fastqFile;

    public FastqFileDataStoreImpl(FastqDataStore datastore, FastqQualityCodec codec, File fastqFile) {
        Objects.requireNonNull(datastore);
        Objects.requireNonNull(codec);
        this.datastore = datastore;
        this.codec = codec;
        this.fastqFile = fastqFile;
    }

    @Override
    public Optional<File> getFile() {
        return Optional.ofNullable(this.fastqFile);
    }

    @Override
    public StreamingIterator<String> idIterator() throws DataStoreException {
        return this.datastore.idIterator();
    }

    @Override
    public FastqRecord get(String id) throws DataStoreException {
        return (FastqRecord)this.datastore.get(id);
    }

    @Override
    public boolean contains(String id) throws DataStoreException {
        return this.datastore.contains(id);
    }

    @Override
    public long getNumberOfRecords() throws DataStoreException {
        return this.datastore.getNumberOfRecords();
    }

    @Override
    public boolean isClosed() {
        return this.datastore.isClosed();
    }

    @Override
    public StreamingIterator<FastqRecord> iterator() throws DataStoreException {
        return this.datastore.iterator();
    }

    @Override
    public StreamingIterator<DataStoreEntry<FastqRecord>> entryIterator() throws DataStoreException {
        return this.datastore.entryIterator();
    }

    @Override
    public void close() throws IOException {
        this.datastore.close();
    }

    @Override
    public FastqQualityCodec getQualityCodec() {
        return this.codec;
    }
}

