/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.core.io.InputStreamSupplier;
import org.jcvi.jillion.trace.fastq.DefaultFastqFileDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileParser;
import org.jcvi.jillion.trace.fastq.FastqFileParserBuilder;
import org.jcvi.jillion.trace.fastq.FastqParser;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqUtil;
import org.jcvi.jillion.trace.fastq.IndexedFastqFileDataStore;
import org.jcvi.jillion.trace.fastq.LargeFastqFileDataStore;

public final class FastqFileDataStoreBuilder {
    private FastqParser parser;
    private InputStreamSupplier inputStreamSupplier;
    private Predicate<String> idFilter = id -> true;
    private Predicate<FastqRecord> recordFilter = null;
    private DataStoreProviderHint hint = DataStoreProviderHint.RANDOM_ACCESS_OPTIMIZE_SPEED;
    private FastqQualityCodec codec = null;
    private boolean hasComments;
    private boolean isMultiLine;

    public FastqFileDataStoreBuilder(File fastqFile) throws IOException {
        this(InputStreamSupplier.forFile(fastqFile));
    }

    public FastqFileDataStoreBuilder(InputStreamSupplier inputStreamSupplier) {
        Objects.requireNonNull(inputStreamSupplier);
        this.inputStreamSupplier = inputStreamSupplier;
        this.parser = null;
    }

    public FastqFileDataStoreBuilder(InputStream inputStream) throws IOException {
        this.parser = FastqFileParser.create(inputStream);
    }

    public FastqFileDataStoreBuilder(FastqParser parser) throws IOException {
        if (parser == null) {
            throw new NullPointerException("parser can not be null");
        }
        this.parser = parser;
    }

    public FastqFileDataStoreBuilder qualityCodec(FastqQualityCodec codec) {
        if (codec == null) {
            throw new NullPointerException("quality codec can not be null");
        }
        this.codec = codec;
        return this;
    }

    public FastqFileDataStoreBuilder hasComments(boolean hasComments) {
        this.hasComments = hasComments;
        return this;
    }

    public FastqFileDataStoreBuilder hasMultilineSequences(boolean multiline) {
        this.isMultiLine = multiline;
        return this;
    }

    public FastqFileDataStoreBuilder filter(Predicate<String> filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.idFilter = filter;
        return this;
    }

    public FastqFileDataStoreBuilder filterRecords(Predicate<FastqRecord> filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.recordFilter = filter;
        return this;
    }

    public FastqFileDataStoreBuilder hint(DataStoreProviderHint hint) {
        if (hint == null) {
            throw new NullPointerException("hint can not be null");
        }
        this.hint = hint;
        return this;
    }

    public FastqFileDataStore build() throws IOException {
        if (this.parser == null) {
            this.parser = new FastqFileParserBuilder(this.inputStreamSupplier, this.hint == DataStoreProviderHint.RANDOM_ACCESS_OPTIMIZE_MEMORY).hasComments(this.hasComments).hasMultilineSequences(this.isMultiLine).build();
        }
        if (this.codec == null) {
            if (this.parser.isReadOnceOnly()) {
                throw new IllegalStateException("must set quality codec if parsing inputStream");
            }
            this.codec = FastqUtil.guessQualityCodecUsed(this.parser);
        }
        switch (this.hint) {
            case RANDOM_ACCESS_OPTIMIZE_SPEED: {
                return DefaultFastqFileDataStore.create(this.parser, this.codec, this.idFilter, this.recordFilter);
            }
            case RANDOM_ACCESS_OPTIMIZE_MEMORY: {
                return this.parser.canCreateMemento() ? IndexedFastqFileDataStore.create(this.parser, this.codec, this.idFilter, this.recordFilter) : DefaultFastqFileDataStore.create(this.parser, this.codec, this.idFilter, this.recordFilter);
            }
            case ITERATION_ONLY: {
                return LargeFastqFileDataStore.create(this.parser, this.codec, this.idFilter, this.recordFilter);
            }
        }
        throw new IllegalArgumentException("unknown provider hint : " + (Object)((Object)this.hint));
    }
}

