/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.trace.fastq.FastqDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileDataStoreBuilder;
import org.jcvi.jillion.trace.fastq.FastqParser;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;

public interface FastqFileDataStore
extends FastqDataStore {
    public FastqQualityCodec getQualityCodec();

    public Optional<File> getFile();

    public static FastqFileDataStore fromFile(File fastqFile) throws IOException {
        return new FastqFileDataStoreBuilder(fastqFile).build();
    }

    public static FastqFileDataStore fromFile(File fastqFile, FastqQualityCodec codec) throws IOException {
        return new FastqFileDataStoreBuilder(fastqFile).qualityCodec(codec).build();
    }

    public static FastqFileDataStore fromFile(File fastqFile, DataStoreProviderHint hint) throws IOException {
        FastqFileDataStoreBuilder builder = new FastqFileDataStoreBuilder(fastqFile);
        builder.hint(hint);
        return builder.build();
    }

    public static FastqFileDataStore fromFile(File fastqFile, FastqQualityCodec codec, DataStoreProviderHint hint) throws IOException {
        return new FastqFileDataStoreBuilder(fastqFile).qualityCodec(codec).hint(hint).build();
    }

    public static FastqFileDataStore from(FastqParser parser) throws IOException {
        FastqFileDataStoreBuilder builder = new FastqFileDataStoreBuilder(parser);
        return builder.build();
    }
}

