/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.trace.fastq.AbstractFastqRecordVisitor;
import org.jcvi.jillion.trace.fastq.FastqDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileDataStore;
import org.jcvi.jillion.trace.fastq.FastqFileDataStoreImpl;
import org.jcvi.jillion.trace.fastq.FastqParser;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqRecordVisitor;
import org.jcvi.jillion.trace.fastq.FastqVisitor;

final class DefaultFastqFileDataStore {
    private DefaultFastqFileDataStore() {
    }

    public static FastqFileDataStore create(FastqParser parser, FastqQualityCodec qualityCodec, Predicate<String> filter, Predicate<FastqRecord> recordFilter) throws IOException {
        DefaultFastqFileDataStoreBuilderVisitor2 visitor = new DefaultFastqFileDataStoreBuilderVisitor2(qualityCodec, filter, recordFilter, parser.getFile().orElse(null));
        parser.parse(visitor);
        return visitor.build();
    }

    private static final class DefaultFastqFileDataStoreBuilderVisitor2
    implements FastqVisitor,
    Builder<FastqFileDataStore> {
        private final Predicate<String> filter;
        private final Predicate<FastqRecord> recordFilter;
        private final FastqQualityCodec qualityCodec;
        private final Map<String, FastqRecord> map = new LinkedHashMap<String, FastqRecord>();
        private final File fastqFile;

        public DefaultFastqFileDataStoreBuilderVisitor2(FastqQualityCodec qualityCodec, Predicate<String> filter, Predicate<FastqRecord> recordFilter, File fastqFile) {
            if (qualityCodec == null) {
                throw new NullPointerException("quality codec can not be null");
            }
            if (filter == null) {
                throw new NullPointerException("filter can not be null");
            }
            this.qualityCodec = qualityCodec;
            this.filter = filter;
            this.recordFilter = recordFilter;
            this.fastqFile = fastqFile;
        }

        @Override
        public FastqRecordVisitor visitDefline(FastqVisitor.FastqVisitorCallback callback, String id, String optionalComment) {
            if (!this.filter.test(id)) {
                return null;
            }
            return new AbstractFastqRecordVisitor(id, optionalComment, this.qualityCodec){

                @Override
                protected void visitRecord(FastqRecord record) {
                    if (recordFilter == null || recordFilter.test(record)) {
                        map.put(record.getId(), record);
                    }
                }
            };
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void halted() {
        }

        @Override
        public FastqFileDataStore build() {
            return new FastqFileDataStoreImpl(DataStore.of(this.map, FastqDataStore.class), this.qualityCodec, this.fastqFile);
        }
    }
}

