/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.fastq;

import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.trace.fastq.CommentedParsedFastqRecord;
import org.jcvi.jillion.internal.trace.fastq.ParsedFastqRecord;
import org.jcvi.jillion.trace.fastq.FastqQualityCodec;
import org.jcvi.jillion.trace.fastq.FastqRecord;
import org.jcvi.jillion.trace.fastq.FastqRecordBuilder;
import org.jcvi.jillion.trace.fastq.FastqRecordVisitor;

public abstract class AbstractFastqRecordVisitor
implements FastqRecordVisitor {
    private final String id;
    private final String optionalComment;
    private final FastqQualityCodec qualityCodec;
    private String currentBasecalls;
    private QualitySequence currentQualities;
    private String encodedQualities;
    private boolean turnOffCompression;

    public AbstractFastqRecordVisitor(String id, String optionalComment, FastqQualityCodec qualityCodec) {
        this(id, optionalComment, qualityCodec, false);
    }

    public AbstractFastqRecordVisitor(String id, String optionalComment, FastqQualityCodec qualityCodec, boolean turnOffCompression) {
        this.id = id;
        this.optionalComment = optionalComment;
        this.qualityCodec = qualityCodec;
        this.turnOffCompression = turnOffCompression;
    }

    @Override
    public final void visitNucleotides(String nucleotides) {
        this.currentBasecalls = nucleotides;
    }

    @Override
    public final void visitEncodedQualities(String encodedQualities) {
        this.encodedQualities = encodedQualities;
    }

    @Override
    public void visitQualities(QualitySequence qualities) {
        this.currentQualities = qualities;
    }

    @Override
    public final void visitEnd() {
        FastqRecord fastqRecord = this.currentQualities == null ? (this.optionalComment == null ? new ParsedFastqRecord(this.id, this.currentBasecalls, this.encodedQualities, this.qualityCodec, this.turnOffCompression) : new CommentedParsedFastqRecord(this.id, this.currentBasecalls, this.encodedQualities, this.qualityCodec, this.turnOffCompression, this.optionalComment)) : FastqRecordBuilder.create(this.id, new NucleotideSequenceBuilder(this.currentBasecalls).turnOffDataCompression(this.turnOffCompression).build(), this.currentQualities).comment(this.optionalComment).build();
        this.visitRecord(fastqRecord);
    }

    @Override
    public void halted() {
    }

    protected abstract void visitRecord(FastqRecord var1);
}

