/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.chromat.ztr;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.internal.trace.chromat.ztr.IOLibLikeZtrChromatogramWriter;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.ChromatogramWriter;

public final class ZtrChromatogramWriterBuilder
implements Builder<ChromatogramWriter> {
    private final File ztrFile;
    private final OutputStream out;

    public ZtrChromatogramWriterBuilder(File ztrFile) {
        if (ztrFile == null) {
            throw new NullPointerException("output file can not be null");
        }
        this.ztrFile = ztrFile;
        this.out = null;
    }

    public ZtrChromatogramWriterBuilder(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("output stream can not be null");
        }
        this.ztrFile = null;
        this.out = out;
    }

    @Override
    public ChromatogramWriter build() {
        try {
            if (this.out == null) {
                return new ZtrChromatogramWriterImpl(this.ztrFile);
            }
            return new ZtrChromatogramWriterImpl(this.out);
        }
        catch (IOException e) {
            throw new IllegalStateException("error creating ztr output file", e);
        }
    }

    private static class ZtrChromatogramWriterImpl
    implements ChromatogramWriter {
        private final OutputStream out;
        private volatile boolean closed = false;
        private final boolean ownOutputStream;

        public ZtrChromatogramWriterImpl(File ztrFile) throws IOException {
            IOUtil.mkdirs(ztrFile.getParentFile());
            this.out = new BufferedOutputStream(new FileOutputStream(ztrFile));
            this.ownOutputStream = true;
        }

        public ZtrChromatogramWriterImpl(OutputStream out) throws IOException {
            this.out = out;
            this.ownOutputStream = false;
        }

        @Override
        public void close() throws IOException {
            if (this.ownOutputStream) {
                this.out.close();
            }
            this.closed = false;
        }

        @Override
        public void write(Chromatogram c) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("can only write one ztr");
            }
            IOLibLikeZtrChromatogramWriter.INSTANCE.write(c, this.out);
            this.close();
        }
    }
}

