/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.chromat.ztr;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.internal.trace.chromat.ztr.ZTRUtil;
import org.jcvi.jillion.internal.trace.chromat.ztr.chunk.Chunk;
import org.jcvi.jillion.internal.trace.chromat.ztr.chunk.ChunkException;
import org.jcvi.jillion.trace.chromat.ChromatogramFileVisitor;

public abstract class ZtrChromatogramParser {
    public static ZtrChromatogramParser create(File ztrFile) {
        return new ZtrFileChromatogramParser(ztrFile);
    }

    public static ZtrChromatogramParser create(InputStream in) {
        return new InputStreamChromatogramParser(in);
    }

    private ZtrChromatogramParser() {
    }

    public abstract void accept(ChromatogramFileVisitor var1) throws IOException;

    protected void parse(InputStream ztrStream, ChromatogramFileVisitor visitor) throws IOException {
        this.parseHeader(ztrStream);
        Chunk currentChunk = this.parseNextChunk(ztrStream);
        NucleotideSequence basecalls = null;
        while (currentChunk != null) {
            basecalls = currentChunk.parseChunk(ztrStream, visitor, basecalls);
            currentChunk = this.parseNextChunk(ztrStream);
        }
        visitor.visitEnd();
    }

    private void parseHeader(InputStream inputStream) throws IOException {
        try {
            this.validateZTRMagicNumber(inputStream);
            this.checkVersion(inputStream);
        }
        catch (IOException ioEx) {
            throw new IOException("error parsing ztr header", ioEx);
        }
    }

    private void checkVersion(InputStream inputStream) throws IOException, IOException {
        int majorVersion = inputStream.read();
        int minorVersion = inputStream.read();
        if (majorVersion != 1 && minorVersion > 2) {
            String message = "Unsupported ZTR version";
            throw new IOException(message);
        }
    }

    private void validateZTRMagicNumber(InputStream inputStream) throws IOException, IOException {
        byte[] ztrMagic = this.readZTRMagicNumber(inputStream);
        if (!ZTRUtil.isMagicNumber(ztrMagic)) {
            String message = "ZTR header magic number does not match expected " + new String(ztrMagic, IOUtil.UTF_8);
            throw new IOException(message);
        }
    }

    private byte[] readZTRMagicNumber(InputStream inputStream) throws IOException {
        try {
            return IOUtil.toByteArray(inputStream, 8);
        }
        catch (IOException e) {
            throw new IOException("invalid ZTR header", e);
        }
    }

    private Chunk parseNextChunk(InputStream inputStream) throws IOException {
        try {
            byte[] chunkType = new byte[4];
            try {
                IOUtil.blockingRead(inputStream, chunkType);
            }
            catch (EOFException e) {
                return null;
            }
            return Chunk.getChunk(new String(chunkType, IOUtil.UTF_8));
        }
        catch (Exception e) {
            throw new ChunkException("error parsing next chunk", e);
        }
    }

    private static final class InputStreamChromatogramParser
    extends ZtrChromatogramParser {
        private final InputStream in;
        private volatile boolean readAlready = false;

        public InputStreamChromatogramParser(InputStream in) {
            if (in == null) {
                throw new NullPointerException("inputstream can not be null");
            }
            this.in = in;
        }

        @Override
        public synchronized void accept(ChromatogramFileVisitor visitor) throws IOException {
            if (this.readAlready) {
                throw new IllegalStateException("already parsed inputstream");
            }
            this.readAlready = true;
            this.parse(this.in, visitor);
        }
    }

    private static final class ZtrFileChromatogramParser
    extends ZtrChromatogramParser {
        private final File ztrFile;

        public ZtrFileChromatogramParser(File ztrFile) {
            if (ztrFile == null) {
                throw new NullPointerException("ztr file can not be null");
            }
            this.ztrFile = ztrFile;
        }

        @Override
        public void accept(ChromatogramFileVisitor visitor) throws IOException {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.ztrFile));
            try {
                this.parse(in, visitor);
            }
            finally {
                IOUtil.closeAndIgnoreErrors((Closeable)in);
            }
        }
    }
}

