/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.chromat.ztr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.pos.PositionSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.internal.trace.chromat.BasicChromatogramBuilder;
import org.jcvi.jillion.internal.trace.chromat.ztr.ZTRChromatogramImpl;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.ztr.ZtrChromatogram;
import org.jcvi.jillion.trace.chromat.ztr.ZtrChromatogramFileVisitor;
import org.jcvi.jillion.trace.chromat.ztr.ZtrChromatogramParser;

public final class ZtrChromatogramBuilder
implements Builder<ZtrChromatogram> {
    private Range clip;
    private final BasicChromatogramBuilder basicBuilder;

    public ZtrChromatogramBuilder(String id) {
        this.basicBuilder = new BasicChromatogramBuilder(id);
    }

    public ZtrChromatogramBuilder(String id, File ztrFile) throws IOException {
        this(id);
        ZTRChromatogramFileBuilderVisitor visitor = new ZTRChromatogramFileBuilderVisitor(this);
        ZtrChromatogramParser.create(ztrFile).accept(visitor);
    }

    public ZtrChromatogramBuilder(String id, InputStream ztrStream) throws IOException {
        this(id);
        ZTRChromatogramFileBuilderVisitor visitor = new ZTRChromatogramFileBuilderVisitor(this);
        ZtrChromatogramParser.create(ztrStream).accept(visitor);
    }

    public ZtrChromatogramBuilder(Chromatogram copy) {
        this.basicBuilder = new BasicChromatogramBuilder(copy);
    }

    public ZtrChromatogramBuilder(ZtrChromatogram copy) {
        this((Chromatogram)copy);
        this.clip(copy.getClip());
    }

    public final Range clip() {
        return this.clip;
    }

    public final ZtrChromatogramBuilder clip(Range clip) {
        this.clip = clip;
        return this;
    }

    @Override
    public ZtrChromatogram build() {
        return new ZTRChromatogramImpl(this.basicBuilder.build(), this.clip());
    }

    public final PositionSequence peaks() {
        return this.basicBuilder.peaks();
    }

    public ZtrChromatogramBuilder peaks(short[] peaks) {
        this.basicBuilder.peaks(new PositionSequenceBuilder(peaks).build());
        return this;
    }

    public final NucleotideSequence basecalls() {
        return this.basicBuilder.basecalls();
    }

    public ZtrChromatogramBuilder basecalls(NucleotideSequence basecalls) {
        this.basicBuilder.basecalls(basecalls);
        return this;
    }

    public final byte[] aQualities() {
        return this.basicBuilder.aQualities();
    }

    public final ZtrChromatogramBuilder aQualities(byte[] qualities) {
        this.basicBuilder.aQualities(qualities);
        return this;
    }

    public final byte[] cQualities() {
        return this.basicBuilder.cQualities();
    }

    public final ZtrChromatogramBuilder cConfidence(byte[] qualities) {
        this.basicBuilder.cQualities(qualities);
        return this;
    }

    public final byte[] gQualities() {
        return this.basicBuilder.gQualities();
    }

    public final ZtrChromatogramBuilder gQualities(byte[] qualities) {
        this.basicBuilder.gQualities(qualities);
        return this;
    }

    public final byte[] tQualities() {
        return this.basicBuilder.tQualities();
    }

    public final ZtrChromatogramBuilder tQualities(byte[] qualities) {
        this.basicBuilder.tQualities(qualities);
        return this;
    }

    public final short[] aPositions() {
        return this.basicBuilder.aPositions();
    }

    public final ZtrChromatogramBuilder aPositions(short[] positions) {
        this.basicBuilder.aPositions(positions);
        return this;
    }

    public final short[] cPositions() {
        return this.basicBuilder.cPositions();
    }

    public final ZtrChromatogramBuilder cPositions(short[] positions) {
        this.basicBuilder.cPositions(positions);
        return this;
    }

    public final short[] gPositions() {
        return this.basicBuilder.gPositions();
    }

    public final ZtrChromatogramBuilder gPositions(short[] positions) {
        this.basicBuilder.gPositions(positions);
        return this;
    }

    public final short[] tPositions() {
        return this.basicBuilder.tPositions();
    }

    public final ZtrChromatogramBuilder tPositions(short[] positions) {
        this.basicBuilder.tPositions(positions);
        return this;
    }

    public final Map<String, String> comments() {
        return this.basicBuilder.comments();
    }

    public final ZtrChromatogramBuilder comments(Map<String, String> comments) {
        this.basicBuilder.comments(comments);
        return this;
    }

    private static final class ZTRChromatogramFileBuilderVisitor
    implements ZtrChromatogramFileVisitor {
        private final ZtrChromatogramBuilder builder;

        private ZTRChromatogramFileBuilderVisitor(ZtrChromatogramBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void visitAConfidence(byte[] confidence) {
            this.builder.aQualities(confidence);
        }

        @Override
        public void visitCConfidence(byte[] confidence) {
            this.builder.cConfidence(confidence);
        }

        @Override
        public void visitGConfidence(byte[] confidence) {
            this.builder.gQualities(confidence);
        }

        @Override
        public void visitTConfidence(byte[] confidence) {
            this.builder.tQualities(confidence);
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visitBasecalls(NucleotideSequence basecalls) {
            this.builder.basecalls(basecalls);
        }

        @Override
        public void visitPeaks(short[] peaks) {
            this.builder.peaks(peaks);
        }

        @Override
        public void visitClipRange(Range clipRange) {
            this.builder.clip(clipRange);
        }

        @Override
        public void visitComments(Map<String, String> comments) {
            this.builder.comments(comments);
        }

        @Override
        public void visitAPositions(short[] positions) {
            this.builder.aPositions(positions);
        }

        @Override
        public void visitCPositions(short[] positions) {
            this.builder.cPositions(positions);
        }

        @Override
        public void visitGPositions(short[] positions) {
            this.builder.gPositions(positions);
        }

        @Override
        public void visitTPositions(short[] positions) {
            this.builder.tPositions(positions);
        }
    }
}

