/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.chromat.scf;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.trace.chromat.scf.SCFCodecs;
import org.jcvi.jillion.internal.trace.chromat.scf.header.DefaultSCFHeaderCodec;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeader;
import org.jcvi.jillion.internal.trace.chromat.scf.header.SCFHeaderCodec;
import org.jcvi.jillion.trace.chromat.ChromatogramFileVisitor;

public abstract class ScfChromatogramParser {
    private static final float THREE = 3.0f;
    private static final SCFHeaderCodec HEADER_CODEC = DefaultSCFHeaderCodec.INSTANCE;

    public static ScfChromatogramParser create(File scfFile) {
        return new ScfFileChromatogramParser(scfFile);
    }

    public static ScfChromatogramParser create(InputStream in) {
        return new InputStreamChromatogramParser(in);
    }

    private ScfChromatogramParser() {
    }

    public abstract void accept(ChromatogramFileVisitor var1) throws IOException;

    protected void parse(InputStream in, ChromatogramFileVisitor visitor) throws IOException {
        DataInputStream dIn = new DataInputStream(in);
        SCFHeader header = HEADER_CODEC.decode(dIn);
        if (header.getVersion() >= 3.0f) {
            SCFCodecs.VERSION_3.parse(dIn, header, visitor);
        } else {
            SCFCodecs.VERSION_2.parse(dIn, header, visitor);
        }
    }

    private static final class InputStreamChromatogramParser
    extends ScfChromatogramParser {
        private final InputStream in;
        private volatile boolean readAlready = false;

        public InputStreamChromatogramParser(InputStream in) {
            if (in == null) {
                throw new NullPointerException("inputstream can not be null");
            }
            this.in = in;
        }

        @Override
        public synchronized void accept(ChromatogramFileVisitor visitor) throws IOException {
            if (this.readAlready) {
                throw new IllegalStateException("already parsed inputstream");
            }
            this.readAlready = true;
            this.parse(this.in, visitor);
        }
    }

    private static final class ScfFileChromatogramParser
    extends ScfChromatogramParser {
        private final File scfFile;

        public ScfFileChromatogramParser(File scfFile) {
            if (scfFile == null) {
                throw new NullPointerException("scf file can not be null");
            }
            this.scfFile = scfFile;
        }

        @Override
        public void accept(ChromatogramFileVisitor visitor) throws IOException {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.scfFile));
            try {
                this.parse(in, visitor);
            }
            finally {
                IOUtil.closeAndIgnoreErrors((Closeable)in);
            }
        }
    }
}

