/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.chromat.scf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.pos.PositionSequenceBuilder;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.internal.trace.chromat.BasicChromatogramBuilder;
import org.jcvi.jillion.internal.trace.chromat.scf.PrivateDataImpl;
import org.jcvi.jillion.internal.trace.chromat.scf.ScfChromatogramImpl;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.scf.PrivateData;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogram;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogramFileVisitor;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogramParser;

public final class ScfChromatogramBuilder
implements Builder<ScfChromatogram> {
    private QualitySequence substitutionConfidence;
    private QualitySequence insertionConfidence;
    private QualitySequence deletionConfidence;
    private byte[] privateData;
    private final BasicChromatogramBuilder basicBuilder;

    public ScfChromatogramBuilder(String id) {
        this.basicBuilder = new BasicChromatogramBuilder(id);
    }

    public ScfChromatogramBuilder(String id, File scfFile) throws IOException {
        this(id);
        SCFChromatogramFileBuilderVisitor visitor = new SCFChromatogramFileBuilderVisitor(this);
        ScfChromatogramParser.create(scfFile).accept(visitor);
    }

    public ScfChromatogramBuilder(String id, InputStream scfInputStream) throws IOException {
        this(id);
        SCFChromatogramFileBuilderVisitor visitor = new SCFChromatogramFileBuilderVisitor(this);
        ScfChromatogramParser.create(scfInputStream).accept(visitor);
    }

    public ScfChromatogramBuilder(Chromatogram copy) {
        this.basicBuilder = new BasicChromatogramBuilder(copy);
    }

    public ScfChromatogramBuilder(String id, Chromatogram copy) {
        this.basicBuilder = new BasicChromatogramBuilder(id, copy);
    }

    public ScfChromatogramBuilder(ScfChromatogram copy) {
        this((Chromatogram)copy);
        this.substitutionConfidence = copy.getSubstitutionConfidence();
        this.deletionConfidence = copy.getDeletionConfidence();
        this.insertionConfidence = copy.getInsertionConfidence();
        this.privateData(copy.getPrivateData().getBytes());
    }

    public QualitySequence substitutionConfidence() {
        return this.substitutionConfidence;
    }

    public ScfChromatogramBuilder substitutionConfidence(byte[] substitutionConfidence) {
        this.substitutionConfidence = substitutionConfidence == null ? null : new QualitySequenceBuilder(substitutionConfidence).build();
        return this;
    }

    public QualitySequence insertionConfidence() {
        return this.insertionConfidence;
    }

    public ScfChromatogramBuilder insertionConfidence(byte[] insertionConfidence) {
        this.insertionConfidence = insertionConfidence == null ? null : new QualitySequenceBuilder(insertionConfidence).build();
        return this;
    }

    public QualitySequence deletionConfidence() {
        return this.deletionConfidence;
    }

    public ScfChromatogramBuilder deletionConfidence(byte[] deletionConfidence) {
        this.deletionConfidence = deletionConfidence == null ? null : new QualitySequenceBuilder(deletionConfidence).build();
        return this;
    }

    public byte[] privateData() {
        return this.privateData == null ? null : Arrays.copyOf(this.privateData, this.privateData.length);
    }

    public ScfChromatogramBuilder privateData(byte[] privateData) {
        this.privateData = privateData == null ? null : Arrays.copyOf(privateData, privateData.length);
        return this;
    }

    @Override
    public ScfChromatogram build() {
        Chromatogram basicChromo = this.basicBuilder.build();
        return new ScfChromatogramImpl(basicChromo, this.substitutionConfidence(), this.insertionConfidence(), this.deletionConfidence(), this.createPrivateData());
    }

    private PrivateData createPrivateData() {
        if (this.privateData() == null) {
            return null;
        }
        return new PrivateDataImpl(this.privateData());
    }

    public final PositionSequence peaks() {
        return this.basicBuilder.peaks();
    }

    public ScfChromatogramBuilder peaks(short[] peaks) {
        this.basicBuilder.peaks(new PositionSequenceBuilder(peaks).build());
        return this;
    }

    public final NucleotideSequence basecalls() {
        return this.basicBuilder.basecalls();
    }

    public ScfChromatogramBuilder basecalls(NucleotideSequence basecalls) {
        this.basicBuilder.basecalls(basecalls);
        return this;
    }

    public final byte[] aQualities() {
        return this.basicBuilder.aQualities();
    }

    public final ScfChromatogramBuilder aQualities(byte[] qualities) {
        this.basicBuilder.aQualities(qualities);
        return this;
    }

    public final byte[] cQualities() {
        return this.basicBuilder.cQualities();
    }

    public final ScfChromatogramBuilder cQualities(byte[] qualities) {
        this.basicBuilder.cQualities(qualities);
        return this;
    }

    public final byte[] gQualities() {
        return this.basicBuilder.gQualities();
    }

    public final ScfChromatogramBuilder gQualities(byte[] qualities) {
        this.basicBuilder.gQualities(qualities);
        return this;
    }

    public final byte[] tQualities() {
        return this.basicBuilder.tQualities();
    }

    public final ScfChromatogramBuilder tQualities(byte[] qualities) {
        this.basicBuilder.tQualities(qualities);
        return this;
    }

    public final short[] aPositions() {
        return this.basicBuilder.aPositions();
    }

    public final ScfChromatogramBuilder aPositions(short[] positions) {
        this.basicBuilder.aPositions(positions);
        return this;
    }

    public final short[] cPositions() {
        return this.basicBuilder.cPositions();
    }

    public final ScfChromatogramBuilder cPositions(short[] positions) {
        this.basicBuilder.cPositions(positions);
        return this;
    }

    public final short[] gPositions() {
        return this.basicBuilder.gPositions();
    }

    public final ScfChromatogramBuilder gPositions(short[] positions) {
        this.basicBuilder.gPositions(positions);
        return this;
    }

    public final short[] tPositions() {
        return this.basicBuilder.tPositions();
    }

    public final ScfChromatogramBuilder tPositions(short[] positions) {
        this.basicBuilder.tPositions(positions);
        return this;
    }

    public final Map<String, String> comments() {
        return this.basicBuilder.comments();
    }

    public final ScfChromatogramBuilder comments(Map<String, String> properties) {
        this.basicBuilder.comments(properties);
        return this;
    }

    private static final class SCFChromatogramFileBuilderVisitor
    implements ScfChromatogramFileVisitor {
        private final ScfChromatogramBuilder builder;

        private SCFChromatogramFileBuilderVisitor(ScfChromatogramBuilder builder) {
            this.builder = builder;
        }

        @Override
        public synchronized void visitAConfidence(byte[] confidence) {
            this.builder.aQualities(confidence);
        }

        @Override
        public synchronized void visitCConfidence(byte[] confidence) {
            this.builder.cQualities(confidence);
        }

        @Override
        public synchronized void visitGConfidence(byte[] confidence) {
            this.builder.gQualities(confidence);
        }

        @Override
        public synchronized void visitTConfidence(byte[] confidence) {
            this.builder.tQualities(confidence);
        }

        @Override
        public synchronized void visitEnd() {
        }

        @Override
        public synchronized void visitBasecalls(NucleotideSequence basecalls) {
            this.builder.basecalls(basecalls);
        }

        @Override
        public synchronized void visitPeaks(short[] peaks) {
            this.builder.peaks(peaks);
        }

        @Override
        public synchronized void visitComments(Map<String, String> comments) {
            this.builder.comments(comments);
        }

        @Override
        public synchronized void visitAPositions(short[] positions) {
            this.builder.aPositions(positions);
        }

        @Override
        public synchronized void visitCPositions(short[] positions) {
            this.builder.cPositions(positions);
        }

        @Override
        public synchronized void visitGPositions(short[] positions) {
            this.builder.gPositions(positions);
        }

        @Override
        public synchronized void visitTPositions(short[] positions) {
            this.builder.tPositions(positions);
        }

        @Override
        public synchronized void visitPrivateData(byte[] privateData) {
            this.builder.privateData(privateData);
        }

        @Override
        public synchronized void visitSubstitutionConfidence(byte[] confidence) {
            this.builder.substitutionConfidence(confidence);
        }

        @Override
        public synchronized void visitInsertionConfidence(byte[] confidence) {
            this.builder.insertionConfidence(confidence);
        }

        @Override
        public synchronized void visitDeletionConfidence(byte[] confidence) {
            this.builder.deletionConfidence(confidence);
        }
    }
}

