/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.chromat.abi.tag;

import java.util.HashMap;
import java.util.Map;

public enum TaggedDataType {
    CHAR(2),
    INTEGER(4),
    FLOAT(7),
    DATE(10),
    TIME(11),
    PASCAL_STRING(18),
    TYPE_19(19),
    TYPE_5(5),
    TYPE_1(1),
    USER_DEFINED(1024),
    LEGACY_BOOL(13);

    private static final Map<Integer, TaggedDataType> MAP;
    private final int value;

    public static TaggedDataType parseTaggedDataName(int dataTypeValue) {
        Integer key = dataTypeValue;
        if (!MAP.containsKey(key)) {
            throw new IllegalArgumentException("Unknown TaggedDataType " + dataTypeValue);
        }
        return MAP.get(key);
    }

    private TaggedDataType(int type) {
        this.value = type;
    }

    public int getValue() {
        return this.value;
    }

    static {
        MAP = new HashMap<Integer, TaggedDataType>();
        for (TaggedDataType type : TaggedDataType.values()) {
            MAP.put(type.getValue(), type);
        }
    }
}

