/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.chromat.abi.tag;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public enum TaggedDataName {
    GEL_COMB("CMBF"),
    DATA("DATA"),
    FILTER_WHEEL_ORDER("FWO_", true),
    GEL_FILE_NAME("GELN"),
    GEL_FILE_PATH("GELP"),
    LANE("LANE"),
    TRANSFORM_MATRIX("MTRX"),
    TRANSFORM_MATRIX_FILE_NAME("MTXF"),
    LAT_PIXEL_AVG("NAVG"),
    NUM_CAPILLARIES("NLNE"),
    BASECALLS("PBAS", true),
    DYE_PRIMER_CORRECTION_FILE("PDMF"),
    PEAK_LOCATIONS("PLOC"),
    PEAK_POSITIONS("PPOS"),
    PEAK_3500("Peak"),
    RUN_DATE("RUND"),
    RUN_TIME("RUNT"),
    SCALE_FACTOR("S/N%"),
    SAMPLE_NAME("SMPL"),
    SPACING("SPAC"),
    TRACKING_CENTER_ADJUSTMENT("TRKC"),
    TRACKING_INITIAL_ADJUSTMENT("TRKP"),
    ANALYSIS_ENDING_SCAN_POINT("AEPt"),
    ANALYSIS_PARAMETERS_FILE_NAME("APFN"),
    ANALYSIS_PROTOCOL_XML_SCHEMA_VERSION("APXV", true),
    ANALYSIS_PROTOCOL_SETTING_NAME("APrN", true),
    ANALYSIS_PROTOCOL_SETTING_VERSION("APrV"),
    ANALYSIS_PROTOTCOL_SETTING_XML("APrX"),
    ANALYSIS_RETURN_CODE("ARTN"),
    ADAPTIVE_PROCESSING_FLAG("ASPF"),
    ANALYSIS_START_SCAN_POINT("ASPt"),
    AUDIT_LOG("AUDT"),
    B1Pt("B1Pt"),
    BASECALLER_TIMESTAMP("BCTS"),
    COMMENT("CMNT"),
    CONTAINER_ID("CTID", true),
    CONTAINER_NAME("CTNM", true),
    CONTAINER_OWNER("CTOw", true),
    COMMENT_TITLE("CTTL"),
    CAPILLARY_TYPE_ELECTROPHORESIS("CpEP"),
    DETECTION_CELL_HEATER_TEMP("DCHT"),
    DOWNSAMPLING_RATE("DSam"),
    DYE_SET_NAME("DySN"),
    DYE_NUMBER("Dye#"),
    DYE_NAME("DyeN"),
    DYE_WAVELENGTH("DyeW"),
    ELECTROPHERSIS_VOLTAGE("EPVt"),
    EVENT("EVNT"),
    GEL_TYPE("GTyp"),
    INSTRUMENT_INFORMATION("HCFG", true),
    INJECTION_TIME_SETTINGS("InSc"),
    INJECTION_VOLTAGE_SETTINGS("InVt"),
    SAMPLE_TRACKING_ID_FOR_LIMS("LIMS"),
    LENGTH_TO_DETECTOR("LNTD"),
    LASER_POWER("LsrP"),
    MACHINE_NAME("MCHN"),
    RUN_MODULE_FILENAME("MODF"),
    MODEL("MODL", true),
    NOISE("NOIS"),
    QUALITY_VALUES("PCON"),
    PLATE_SZE("PSZE"),
    PLATE_TYPE("PTYP", true),
    PXLB("PXLB"),
    RESULTS_GROUP_NAME("RGNm", true),
    RMXV("RMXV"),
    RMdN("RMdN", true),
    RMdV("RMdV"),
    RMdX("RMdX", true),
    RPrN("RPrN", true),
    RPrV("RPrV"),
    Rate("Rate"),
    RevC("RevC"),
    JTC_RUN_NAME("RunN", true),
    SCAN("SCAN"),
    SEPARATION_MEDIUM_EXPIRATION_DATE("SMED"),
    SEPARATION_MEDIUM_LOT_NUMBER("SMLt"),
    SOFTWARE_VERSION("SVER"),
    Scal("Scal"),
    Scan("Scan"),
    TUBE("TUBE"),
    OVEN_TEMPERATURE("Tmpr"),
    USER("User"),
    USER_EDITED_SIZE_MATCH_RESULTS("UsrE"),
    PEAK_ARIA_RATIO("phAR"),
    CHEMISTRY_TYPE("phCH"),
    DYE_TYPE("phDY"),
    MAX_QUAL_VALUE("phQL"),
    phTR("phTR"),
    MATRIX_FILE_NAME("MTFX"),
    FTab("FTab"),
    FVoc("FVoc"),
    Feat("Feat"),
    OFF_SCALE("OffS", true),
    RAW_DATA_START_POINT("ScSt"),
    OFF_SCALE_LIST("OfSc"),
    SATURATED_SCAN_INDEXES("Satd"),
    BufT("BufT"),
    BufG("BufG"),
    BufC("BufC"),
    BufA("BufA"),
    LAST("LAST"),
    P1AM("P1AM"),
    P1RL("P1RL"),
    P1WD("P1WD"),
    P2AM("P2AM"),
    P2RL("P2RL"),
    P2BA("P2BA"),
    RGOw("RGOw"),
    PRIMARY_ANALYSIS_AUDIT_ACTIVE_INDICATOR("AAct"),
    ANODE_BUFFER_EXPIRATION_DATE("ABED"),
    ANODE_BUFFER_INSTALL_DATE("ABID"),
    ANODE_BUFFER_LOT_NUMBER("ABLt"),
    ANODE_BUFFER_RUN_NUMBER("ABRn"),
    ANODE_BUFFER_TYPE("ABTp"),
    ASSAY_VALIDATION_FLAG("AVld"),
    ASSAY_XML("AsyC"),
    AMBIENT_TEMP("AmbT"),
    ASSAY_NAME("AsyN"),
    ASSAY_VERSION("AsyV"),
    BASECALL_QC_CODE("BcRn"),
    BASECAL_WARNINGS_OR_ERRORS("BcRs"),
    CAPILLARY_ARRAY_EXPIRATION("CAED"),
    CAID("CAID"),
    CAPILLARY_ARRAY_LOT_NUM("CALt"),
    CAPILLAY_INJECTION_COUNT("CARn"),
    CAPILLARY_ARRAY_SERIAL_NUM("CASN"),
    CATHODE_BUFFER_EXPIRATION_DATE("CBED"),
    CATHODE_BUFFER_INSTALL_DATE("CBID"),
    CATHODE_BUFFER_LOT_NUMBER("CBLt"),
    CATHODE_BUFFER_RUN_NUMBER("CBRn"),
    CATHODE_BUFFER_TYPE("CBTp"),
    CLEAR_RANGE_START_or_LENGTH("CLRG"),
    CONTINIOUS_READ_LENGTH_or_PASS_FAIL_CHECK("CRLn"),
    FILE_CHECKSUM("CkSm"),
    DCMD("DCMD"),
    INJECTION_NAME("InjN"),
    MEDIUM_PUPSCORE("PuSc"),
    QV20("QV20"),
    QC_PARAMS("QcPa"),
    QC_TRIMCODE("QcRn"),
    QC_WARNINGS_OR_ERRORS("QcRs"),
    RAMAN_NORMALIZATION_FACTOR("RNmF"),
    POLYMER_INSTALL_DATE("SMID"),
    POLYMER_RUN_NUMBER("SMRn"),
    ACTIVE_SPECTRAL_CALIBRATION_NAME("SpeN"),
    TRIMMING_PARAMETERS("TrPa"),
    DIRECTORY("tdir"),
    TRACE_SCORE("TrSc");

    private final String name;
    private final boolean isNullTerminated;
    private static final Map<Integer, TaggedDataName> INT_MAP;
    private static final Map<String, TaggedDataName> MAP;

    public static TaggedDataName getTagFromIntCode(int code) {
        return INT_MAP.get(code);
    }

    public static TaggedDataName parseTaggedDataName(String taggedDataName) {
        if (MAP.containsKey(taggedDataName)) {
            return MAP.get(taggedDataName);
        }
        System.out.println("unknown tag data name " + taggedDataName);
        return null;
    }

    private TaggedDataName(String name, boolean isNullTerminated) {
        this.name = name;
        this.isNullTerminated = isNullTerminated;
    }

    private TaggedDataName(String name) {
        this(name, false);
    }

    public boolean usesNullTerminatedStringValues() {
        return this.isNullTerminated;
    }

    public String toString() {
        return this.name;
    }

    static {
        TaggedDataName[] values = TaggedDataName.values();
        INT_MAP = new HashMap<Integer, TaggedDataName>(values.length);
        MAP = new HashMap<String, TaggedDataName>(values.length);
        for (TaggedDataName tag : values) {
            MAP.put(tag.name, tag);
            byte[] bytes = tag.name.getBytes(StandardCharsets.US_ASCII);
            int value = 0;
            for (int i = bytes.length - 1; i >= 0; --i) {
                value <<= 8;
                value |= bytes[i];
            }
            INT_MAP.put(value, tag);
        }
    }
}

