/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.chromat.abi;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.trace.chromat.abi.AbiUtil;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.DefaultShortArrayTaggedDataRecord;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.TaggedDataRecordBuilder;
import org.jcvi.jillion.internal.trace.chromat.abi.tag.rate.ScanRateUtils;
import org.jcvi.jillion.trace.chromat.ChromatogramFileVisitor;
import org.jcvi.jillion.trace.chromat.abi.AbiChromatogramFileVisitor;
import org.jcvi.jillion.trace.chromat.abi.tag.Ab1LocalDate;
import org.jcvi.jillion.trace.chromat.abi.tag.Ab1LocalTime;
import org.jcvi.jillion.trace.chromat.abi.tag.AsciiTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.ByteArrayTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.DateTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.FloatArrayTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.IntArrayTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.PascalStringTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.ShortArrayTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.StringTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.TaggedDataName;
import org.jcvi.jillion.trace.chromat.abi.tag.TaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.TaggedDataType;
import org.jcvi.jillion.trace.chromat.abi.tag.TimeTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.UserDefinedTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.rate.ScanRate;
import org.jcvi.jillion.trace.chromat.abi.tag.rate.ScanRateTaggedDataType;

public abstract class AbiChromatogramParser {
    private static final byte ZERO_QUALITY = 0;
    private static ThreadLocal<DateFormat> DATE_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat get() {
            return (DateFormat)super.get();
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("EEE dd MMM HH:mm:ss yyyy", Locale.US);
        }

        @Override
        public void remove() {
            super.remove();
        }

        @Override
        public void set(DateFormat value) {
            super.set(value);
        }
    };
    private static final int ORIGINAL_VERSION_INDEX = 0;
    private static final int CURRENT_VERSION_INDEX = 1;
    private static final int CURRENT_VERSION_TAGNUMBER = 1;
    private static final int ORIGINAL_VERSION_TAGNUMBER = 2;

    public static AbiChromatogramParser create(File abiFile) {
        return new AbiFileChromatogramParser(abiFile);
    }

    public static AbiChromatogramParser create(InputStream in) {
        return new InputStreamChromatogramParser(in);
    }

    private AbiChromatogramParser() {
    }

    public abstract void accept(ChromatogramFileVisitor var1) throws IOException;

    private static void parse(InputStream in, ChromatogramFileVisitor visitor) throws IOException {
        AbiChromatogramParser.verifyMagicNumber(in);
        long numberOfTaggedRecords = AbiChromatogramParser.parseNumTaggedRecords(in);
        int datablockOffset = AbiChromatogramParser.parseTaggedRecordOffset(in);
        byte[] traceData = AbiChromatogramParser.parseTraceDataBlock(in, datablockOffset - 30);
        GroupedTaggedRecords groupedDataRecordMap = AbiChromatogramParser.parseTaggedDataRecords(in, numberOfTaggedRecords, traceData, visitor);
        List<Nucleotide> channelOrder = AbiChromatogramParser.parseChannelOrder(groupedDataRecordMap);
        AbiChromatogramParser.visitChannelOrderIfAble(visitor, channelOrder);
        List<NucleotideSequence> basecalls = AbiChromatogramParser.parseBasecallsFrom(groupedDataRecordMap, traceData, visitor);
        String signalScale = AbiChromatogramParser.parseSignalScalingFactor(groupedDataRecordMap, channelOrder, traceData, visitor);
        Map<String, String> comments = AbiChromatogramParser.parseDataChannels(groupedDataRecordMap, channelOrder, traceData, visitor);
        AbiChromatogramParser.parsePeakData(groupedDataRecordMap, traceData, visitor);
        AbiChromatogramParser.parseQualityData(groupedDataRecordMap, traceData, basecalls, visitor);
        AbiChromatogramParser.parseCommentsFrom(comments, groupedDataRecordMap, channelOrder, traceData, signalScale, basecalls, visitor);
        visitor.visitEnd();
    }

    private static String parseSignalScalingFactor(GroupedTaggedRecords groupedDataRecordMap, List<Nucleotide> channelOrder, byte[] traceData, ChromatogramFileVisitor visitor) {
        ShortArrayTaggedDataRecord scalingFactors = (ShortArrayTaggedDataRecord)((TaggedDataRecords)groupedDataRecordMap.shortArrayDataRecords.get((Object)TaggedDataName.SCALE_FACTOR)).get(0);
        List<Short> list = AbiChromatogramParser.convertToShortList(traceData, scalingFactors);
        SignalScalingFactor scalingFactor = SignalScalingFactor.create(channelOrder, list);
        if (visitor instanceof AbiChromatogramFileVisitor) {
            ((AbiChromatogramFileVisitor)visitor).visitScaleFactors(scalingFactor.aScale, scalingFactor.cScale, scalingFactor.gScale, scalingFactor.tScale);
        }
        return scalingFactor.toString();
    }

    private static List<Short> convertToShortList(byte[] traceData, ShortArrayTaggedDataRecord scalingFactors) {
        ArrayList<Short> list = new ArrayList<Short>();
        for (short s : (short[])scalingFactors.parseDataRecordFrom(traceData)) {
            list.add(s);
        }
        return list;
    }

    private static void parseQualityData(GroupedTaggedRecords groupedDataRecordMap, byte[] traceData, List<NucleotideSequence> basecallsList, ChromatogramFileVisitor visitor) {
        TaggedDataRecords qualityRecords = (TaggedDataRecords)groupedDataRecordMap.byteArrayRecords.get((Object)TaggedDataName.QUALITY_VALUES);
        for (int i = 0; i < qualityRecords.size(); ++i) {
            ByteArrayTaggedDataRecord qualityRecord = (ByteArrayTaggedDataRecord)qualityRecords.get(i);
            NucleotideSequence basecalls = basecallsList.get(i);
            byte[][] qualities = AbiChromatogramParser.splitQualityDataByChannel(basecalls, (byte[])qualityRecord.parseDataRecordFrom(traceData));
            long tagNumber = qualityRecord.getTagNumber();
            if (tagNumber == 2L && visitor instanceof AbiChromatogramFileVisitor) {
                AbiChromatogramFileVisitor ab1Visitor = (AbiChromatogramFileVisitor)visitor;
                AbiChromatogramParser.handleOriginalConfidenceValues(qualities, ab1Visitor);
                continue;
            }
            if (tagNumber != 1L) continue;
            AbiChromatogramParser.handleCurrentConfidenceValues(visitor, qualities);
        }
    }

    private static void handleCurrentConfidenceValues(ChromatogramFileVisitor visitor, byte[][] qualities) {
        visitor.visitAConfidence(qualities[0]);
        visitor.visitCConfidence(qualities[1]);
        visitor.visitGConfidence(qualities[2]);
        visitor.visitTConfidence(qualities[3]);
    }

    private static void handleOriginalConfidenceValues(byte[][] qualities, AbiChromatogramFileVisitor ab1Visitor) {
        ab1Visitor.visitOriginalAConfidence(qualities[0]);
        ab1Visitor.visitOriginalCConfidence(qualities[1]);
        ab1Visitor.visitOriginalGConfidence(qualities[2]);
        ab1Visitor.visitOriginalTConfidence(qualities[3]);
    }

    private static byte[][] splitQualityDataByChannel(NucleotideSequence basecalls, byte[] qualities) {
        int size = (int)basecalls.getLength();
        ByteBuffer aQualities = ByteBuffer.allocate(size);
        ByteBuffer cQualities = ByteBuffer.allocate(size);
        ByteBuffer gQualities = ByteBuffer.allocate(size);
        ByteBuffer tQualities = ByteBuffer.allocate(size);
        AbiChromatogramParser.populateQualities(basecalls, qualities, aQualities, cQualities, gQualities, tQualities);
        return new byte[][]{aQualities.array(), cQualities.array(), gQualities.array(), tQualities.array()};
    }

    private static void populateQualities(NucleotideSequence basecalls, byte[] qualities, ByteBuffer aQualities, ByteBuffer cQualities, ByteBuffer gQualities, ByteBuffer tQualities) {
        Iterator basecallIterator = basecalls.iterator();
        for (int i = 0; i < qualities.length; ++i) {
            AbiChromatogramParser.populateQualities(aQualities, cQualities, gQualities, tQualities, (Nucleotide)basecallIterator.next(), qualities[i]);
        }
    }

    private static void populateQualities(ByteBuffer aQualities, ByteBuffer cQualities, ByteBuffer gQualities, ByteBuffer tQualities, Nucleotide basecall, byte quality) {
        switch (basecall) {
            case Adenine: {
                AbiChromatogramParser.handleAQuality(aQualities, cQualities, gQualities, tQualities, quality);
                break;
            }
            case Cytosine: {
                AbiChromatogramParser.handleCQuality(aQualities, cQualities, gQualities, tQualities, quality);
                break;
            }
            case Guanine: {
                AbiChromatogramParser.handleGQuality(aQualities, cQualities, gQualities, tQualities, quality);
                break;
            }
            default: {
                AbiChromatogramParser.handleTQuality(aQualities, cQualities, gQualities, tQualities, quality);
            }
        }
    }

    private static void handleTQuality(ByteBuffer aQualities, ByteBuffer cQualities, ByteBuffer gQualities, ByteBuffer tQualities, byte quality) {
        aQualities.put((byte)0);
        cQualities.put((byte)0);
        gQualities.put((byte)0);
        tQualities.put(quality);
    }

    private static void handleGQuality(ByteBuffer aQualities, ByteBuffer cQualities, ByteBuffer gQualities, ByteBuffer tQualities, byte quality) {
        aQualities.put((byte)0);
        cQualities.put((byte)0);
        gQualities.put(quality);
        tQualities.put((byte)0);
    }

    private static void handleCQuality(ByteBuffer aQualities, ByteBuffer cQualities, ByteBuffer gQualities, ByteBuffer tQualities, byte quality) {
        aQualities.put((byte)0);
        cQualities.put(quality);
        gQualities.put((byte)0);
        tQualities.put((byte)0);
    }

    private static void handleAQuality(ByteBuffer aQualities, ByteBuffer cQualities, ByteBuffer gQualities, ByteBuffer tQualities, byte quality) {
        aQualities.put(quality);
        cQualities.put((byte)0);
        gQualities.put((byte)0);
        tQualities.put((byte)0);
    }

    private static void parsePeakData(GroupedTaggedRecords groupedDataRecordMap, byte[] traceData, ChromatogramFileVisitor visitor) {
        TaggedDataRecords peakRecords = (TaggedDataRecords)groupedDataRecordMap.shortArrayDataRecords.get((Object)TaggedDataName.PEAK_LOCATIONS);
        peakRecords.getCurrentVersion().ifPresent(peaks -> visitor.visitPeaks((short[])peaks.parseDataRecordFrom(traceData)));
        if (visitor instanceof AbiChromatogramFileVisitor) {
            peakRecords.getOriginalVersion().ifPresent(peaks -> ((AbiChromatogramFileVisitor)visitor).visitOriginalPeaks((short[])peaks.parseDataRecordFrom(traceData)));
        }
    }

    private static Map<String, String> parseDataChannels(GroupedTaggedRecords groupedDataRecordMap, List<Nucleotide> channelOrder, byte[] traceData, ChromatogramFileVisitor visitor) {
        TaggedDataRecords dataRecords = (TaggedDataRecords)groupedDataRecordMap.shortArrayDataRecords.get((Object)TaggedDataName.DATA);
        if (visitor instanceof AbiChromatogramFileVisitor) {
            AbiChromatogramFileVisitor ab1Visitor = (AbiChromatogramFileVisitor)visitor;
            AbiChromatogramParser.visitAb1ExtraChannels(traceData, dataRecords, ab1Visitor);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        for (int i = 0; i < 4; ++i) {
            Nucleotide channel = channelOrder.get(i);
            short[] channelData = (short[])((ShortArrayTaggedDataRecord)dataRecords.get(i + 8)).parseDataRecordFrom(traceData);
            props.put("NPTS", "" + channelData.length);
            AbiChromatogramParser.visitChannel(visitor, channel, channelData);
        }
        return props;
    }

    private static void visitChannel(ChromatogramFileVisitor visitor, Nucleotide channel, short[] channelData) {
        switch (channel) {
            case Adenine: {
                visitor.visitAPositions(channelData);
                break;
            }
            case Thymine: {
                visitor.visitTPositions(channelData);
                break;
            }
            case Guanine: {
                visitor.visitGPositions(channelData);
                break;
            }
            case Cytosine: {
                visitor.visitCPositions(channelData);
                break;
            }
            default: {
                throw new IllegalStateException("invalid channel " + channel);
            }
        }
    }

    private static void visitAb1ExtraChannels(byte[] traceData, TaggedDataRecords<ShortArrayTaggedDataRecord> dataRecords, AbiChromatogramFileVisitor ab1Visitor) {
        for (int i = 0; i < 4; ++i) {
            short[] rawTraceData = (short[])dataRecords.get(i).parseDataRecordFrom(traceData);
            ab1Visitor.visitPhotometricData(rawTraceData, i);
        }
        ab1Visitor.visitGelVoltageData((short[])dataRecords.get(4).parseDataRecordFrom(traceData));
        ab1Visitor.visitGelCurrentData((short[])dataRecords.get(5).parseDataRecordFrom(traceData));
        ab1Visitor.visitElectrophoreticPower((short[])dataRecords.get(6).parseDataRecordFrom(traceData));
        ab1Visitor.visitGelTemperatureData((short[])dataRecords.get(7).parseDataRecordFrom(traceData));
    }

    private static void visitChannelOrderIfAble(ChromatogramFileVisitor visitor, List<Nucleotide> channelOrder) {
        if (visitor instanceof AbiChromatogramFileVisitor) {
            ((AbiChromatogramFileVisitor)visitor).visitChannelOrder(channelOrder);
        }
    }

    private static void parseCommentsFrom(Map<String, String> props, GroupedTaggedRecords groupedDataRecordMap, List<Nucleotide> channelOrder, byte[] traceData, String signalScale, List<NucleotideSequence> basecalls, ChromatogramFileVisitor visitor) {
        props.put("SIGN", signalScale);
        AbiChromatogramParser.addStringComments(groupedDataRecordMap, traceData, props);
        AbiChromatogramParser.addSingleShortValueComments(groupedDataRecordMap, traceData, props);
        AbiChromatogramParser.addChannelOrderComment(channelOrder, props);
        AbiChromatogramParser.addSpacingComment(groupedDataRecordMap, traceData, props);
        AbiChromatogramParser.addTimeStampComment(groupedDataRecordMap, traceData, props);
        AbiChromatogramParser.addNoiseComment(groupedDataRecordMap, channelOrder, traceData, props);
        AbiChromatogramParser.addNumberOfBases(basecalls, props);
        AbiChromatogramParser.parseSamplingRateFrom(groupedDataRecordMap, traceData, props);
        visitor.visitComments(props);
    }

    private static void parseSamplingRateFrom(GroupedTaggedRecords groupedDataRecordMap, byte[] traceData, Map<String, String> props) {
        Map map = groupedDataRecordMap.userDefinedDataRecords;
        TaggedDataRecords userDefinedTaggedDataRecords = (TaggedDataRecords)map.get((Object)TaggedDataName.Rate);
        if (userDefinedTaggedDataRecords != null && userDefinedTaggedDataRecords.size() > 0) {
            Optional originalVersion = userDefinedTaggedDataRecords.getOriginalVersion();
            if (originalVersion.isPresent()) {
                props.put("SamplingRate", String.format("%.3f", Float.valueOf(ScanRateUtils.getSamplingRateFor((ScanRate)((ScanRateTaggedDataType)originalVersion.get()).parseDataRecordFrom(traceData)))));
            } else {
                props.put("SamplingRate", String.format("%.3f", Float.valueOf(ScanRateUtils.getSamplingRateFor((ScanRate)((ScanRateTaggedDataType)userDefinedTaggedDataRecords.get(0)).parseDataRecordFrom(traceData)))));
            }
        }
    }

    private static void addNumberOfBases(List<NucleotideSequence> basecalls, Map<String, String> props) {
        props.put("NBAS", "" + basecalls.get(0).getLength());
    }

    private static void addNoiseComment(GroupedTaggedRecords groupedDataRecordMap, List<Nucleotide> channelOrder, byte[] traceData, Map<String, String> props) {
        Map map = groupedDataRecordMap.floatDataRecords;
        TaggedDataRecords floatArrayTaggedDataRecords = (TaggedDataRecords)map.get((Object)TaggedDataName.NOISE);
        if (floatArrayTaggedDataRecords != null && floatArrayTaggedDataRecords.size() > 0) {
            Optional originalVersion = floatArrayTaggedDataRecords.getOriginalVersion();
            float[] noiseData = originalVersion.isPresent() ? (float[])((FloatArrayTaggedDataRecord)originalVersion.get()).parseDataRecordFrom(traceData) : (float[])((FloatArrayTaggedDataRecord)floatArrayTaggedDataRecords.get(0)).parseDataRecordFrom(traceData);
            Noise noise = Noise.create(channelOrder, noiseData);
            props.put("NOIS", noise.toString());
        }
    }

    private static void addTimeStampComment(GroupedTaggedRecords groupedDataRecordMap, byte[] traceData, Map<String, String> props) {
        Map dates = groupedDataRecordMap.dateDataRecords;
        Map times = groupedDataRecordMap.timeDataRecords;
        if (dates.containsKey((Object)TaggedDataName.RUN_DATE) && times.containsKey((Object)TaggedDataName.RUN_TIME)) {
            Ab1LocalDate startDate = (Ab1LocalDate)((DateTaggedDataRecord)((TaggedDataRecords)dates.get((Object)TaggedDataName.RUN_DATE)).get(0)).parseDataRecordFrom(traceData);
            Ab1LocalDate endDate = (Ab1LocalDate)((DateTaggedDataRecord)((TaggedDataRecords)dates.get((Object)TaggedDataName.RUN_DATE)).get(1)).parseDataRecordFrom(traceData);
            Ab1LocalTime startTime = (Ab1LocalTime)((TimeTaggedDataRecord)((TaggedDataRecords)times.get((Object)TaggedDataName.RUN_TIME)).get(0)).parseDataRecordFrom(traceData);
            Ab1LocalTime endTime = (Ab1LocalTime)((TimeTaggedDataRecord)((TaggedDataRecords)times.get((Object)TaggedDataName.RUN_TIME)).get(1)).parseDataRecordFrom(traceData);
            Date startDateTime = startDate.toDate(startTime);
            Date endDateTime = endDate.toDate(endTime);
            props.put("DATE", String.format("%s to %s", DATE_FORMATTER.get().format(startDateTime), DATE_FORMATTER.get().format(endDateTime)));
            props.put("RUND", String.format("%04d%02d%02d.%02d%02d%02d - %04d%02d%02d.%02d%02d%02d", startDate.getYear(), startDate.getMonth() + 1, startDate.getDay(), startTime.getHour(), startTime.getMin(), startTime.getSec(), endDate.getYear(), endDate.getMonth() + 1, endDate.getDay(), endTime.getHour(), endTime.getMin(), endTime.getSec()));
        }
    }

    private static void addSpacingComment(GroupedTaggedRecords groupedDataRecordMap, byte[] traceData, Map<String, String> props) {
        Map map = groupedDataRecordMap.floatDataRecords;
        TaggedDataRecords spacing = (TaggedDataRecords)map.get((Object)TaggedDataName.SPACING);
        if (spacing != null && spacing.size() > 0) {
            Optional originalVersion = spacing.getOriginalVersion();
            if (originalVersion.isPresent()) {
                props.put("SPAC", String.format("%-6.2f", Float.valueOf(((float[])((FloatArrayTaggedDataRecord)originalVersion.get()).parseDataRecordFrom(traceData))[0])));
            } else {
                props.put("SPAC", String.format("%-6.2f", Float.valueOf(((float[])((FloatArrayTaggedDataRecord)spacing.get(0)).parseDataRecordFrom(traceData))[0])));
            }
        }
    }

    private static void addChannelOrderComment(List<Nucleotide> channelOrder, Map<String, String> props) {
        StringBuilder order = new StringBuilder();
        for (Nucleotide channel : channelOrder) {
            order.append(channel.getCharacter());
        }
        props.put("FWO_", order.toString());
    }

    private static Properties extractSingleIntValueComments(GroupedTaggedRecords groupedDataRecordMap, byte[] traceData, Properties props) {
        Map map = groupedDataRecordMap.intArrayDataRecords;
        if (map.containsKey((Object)TaggedDataName.OVEN_TEMPERATURE)) {
            ((TaggedDataRecords)map.get((Object)TaggedDataName.OVEN_TEMPERATURE)).getOriginalVersion().ifPresent(d -> props.put("Tmpr", (Object)((int[])d.parseDataRecordFrom(traceData))[0]));
        }
        if (map.containsKey((Object)TaggedDataName.ELECTROPHERSIS_VOLTAGE)) {
            ((TaggedDataRecords)map.get((Object)TaggedDataName.ELECTROPHERSIS_VOLTAGE)).getOriginalVersion().ifPresent(d -> props.put("EPVt", (Object)((int[])d.parseDataRecordFrom(traceData))[0]));
        }
        return props;
    }

    private static void addSingleShortValueComments(GroupedTaggedRecords groupedDataRecordMap, byte[] traceData, Map<String, String> props) {
        Map map = groupedDataRecordMap.shortArrayDataRecords;
        for (ShortTaggedDataRecordPropertyHandler handler : ShortTaggedDataRecordPropertyHandler.values()) {
            handler.handle(map, traceData, props);
        }
    }

    private static void addStringComments(GroupedTaggedRecords groupedDataRecordMap, byte[] traceData, Map<String, String> props) {
        Map pascalStrings = groupedDataRecordMap.pascalStringDataRecords;
        Map asciiStrings = groupedDataRecordMap.asciiDataRecords;
        AbiChromatogramParser.addProperty("COMM", TaggedDataName.COMMENT, props, pascalStrings, traceData);
        AbiChromatogramParser.addProperty("NAME", TaggedDataName.SAMPLE_NAME, props, pascalStrings, traceData);
        AbiChromatogramParser.addProperty("DYEP", TaggedDataName.DYE_PRIMER_CORRECTION_FILE, props, pascalStrings, traceData);
        AbiChromatogramParser.addProperty("MCHN", TaggedDataName.MACHINE_NAME, props, pascalStrings, traceData);
        AbiChromatogramParser.addProperty("MODL", TaggedDataName.MODEL, props, asciiStrings, traceData);
        AbiChromatogramParser.addProperty("MODF", TaggedDataName.RUN_MODULE_FILENAME, props, pascalStrings, traceData);
        AbiChromatogramParser.addProperty("MTFX", TaggedDataName.MATRIX_FILE_NAME, props, pascalStrings, traceData);
        AbiChromatogramParser.addProperty("BCAL", TaggedDataName.SPACING, props, pascalStrings, traceData);
        AbiChromatogramParser.addProperty("SMLt", TaggedDataName.SEPARATION_MEDIUM_LOT_NUMBER, props, pascalStrings, traceData);
        AbiChromatogramParser.addProperty("SMED", TaggedDataName.SEPARATION_MEDIUM_EXPIRATION_DATE, props, pascalStrings, traceData);
        if (pascalStrings.containsKey((Object)TaggedDataName.SOFTWARE_VERSION)) {
            TaggedDataRecords versions = (TaggedDataRecords)pascalStrings.get((Object)TaggedDataName.SOFTWARE_VERSION);
            for (int i = 0; i < versions.size() && i < 2; ++i) {
                props.put("VER" + (i + 1), ((String)((PascalStringTaggedDataRecord)versions.get(i)).parseDataRecordFrom(traceData)).trim());
            }
        }
        AbiChromatogramParser.addProperty("PRON", TaggedDataName.ANALYSIS_PARAMETERS_FILE_NAME, props, pascalStrings, traceData);
        AbiChromatogramParser.addProperty("TUBE", TaggedDataName.TUBE, props, pascalStrings, traceData);
        AbiChromatogramParser.addProperty("RUNN", TaggedDataName.JTC_RUN_NAME, props, asciiStrings, traceData);
        AbiChromatogramParser.addProperty("PROV", TaggedDataName.ANALYSIS_PROTOCOL_XML_SCHEMA_VERSION, props, asciiStrings, traceData);
    }

    private static <T extends StringTaggedDataRecord> void addProperty(String propertyName, TaggedDataName taggedDataName, Map<String, String> properties, Map<TaggedDataName, TaggedDataRecords<T>> asciiStrings, byte[] traceData) {
        TaggedDataRecords<T> dataRecords = asciiStrings.get((Object)taggedDataName);
        if (dataRecords != null && dataRecords.size() > 0) {
            Optional<T> originalVersion = dataRecords.getOriginalVersion();
            if (originalVersion.isPresent()) {
                properties.put(propertyName, ((String)((StringTaggedDataRecord)originalVersion.get()).parseDataRecordFrom(traceData)).trim());
            } else {
                properties.put(propertyName, ((String)((StringTaggedDataRecord)dataRecords.get(0)).parseDataRecordFrom(traceData)).trim());
            }
        }
    }

    private static List<NucleotideSequence> parseBasecallsFrom(GroupedTaggedRecords groupedDataRecordMap, byte[] ab1DataBlock, ChromatogramFileVisitor visitor) {
        ArrayList<NucleotideSequence> basecallsList = new ArrayList<NucleotideSequence>(2);
        for (AsciiTaggedDataRecord basecallRecord : (TaggedDataRecords)groupedDataRecordMap.asciiDataRecords.get((Object)TaggedDataName.BASECALLS)) {
            NucleotideSequence basecalls = new NucleotideSequenceBuilder((String)basecallRecord.parseDataRecordFrom(ab1DataBlock)).build();
            basecallsList.add(basecalls);
            if (basecallRecord.getTagNumber() == 1L) {
                visitor.visitBasecalls(basecalls);
                continue;
            }
            if (!(visitor instanceof AbiChromatogramFileVisitor)) continue;
            ((AbiChromatogramFileVisitor)visitor).visitOriginalBasecalls(basecalls);
        }
        return basecallsList;
    }

    private static List<Nucleotide> parseChannelOrder(GroupedTaggedRecords dataRecordMap) {
        AsciiTaggedDataRecord order = (AsciiTaggedDataRecord)((TaggedDataRecords)dataRecordMap.asciiDataRecords.get((Object)TaggedDataName.FILTER_WHEEL_ORDER)).get(0);
        return AbiChromatogramParser.asList(new NucleotideSequenceBuilder((String)order.parseDataRecordFrom(null)));
    }

    private static List<Nucleotide> asList(NucleotideSequenceBuilder builder) {
        ArrayList<Nucleotide> list = new ArrayList<Nucleotide>((int)builder.getLength());
        for (Nucleotide n : builder) {
            list.add(n);
        }
        return list;
    }

    private static GroupedTaggedRecords parseTaggedDataRecords(InputStream in, long numberOfTaggedRecords, byte[] abiDataBlock, ChromatogramFileVisitor visitor) throws IOException {
        GroupedTaggedRecords map = new GroupedTaggedRecords();
        boolean isAb1ChromatogramVisitor = visitor instanceof AbiChromatogramFileVisitor;
        try {
            for (long i = 0L; i < numberOfTaggedRecords; ++i) {
                String rawTagName = new String(IOUtil.toByteArray(in, 4), "UTF-8");
                TaggedDataName tagName = TaggedDataName.parseTaggedDataName(rawTagName);
                long tagNumber = IOUtil.readUnsignedInt(in);
                TaggedDataRecordBuilder builder = new TaggedDataRecordBuilder(tagName, tagNumber).setDataType(TaggedDataType.parseTaggedDataName(IOUtil.readUnsignedShort(in)), IOUtil.readUnsignedShort(in)).setNumberOfElements(IOUtil.readUnsignedInt(in)).setRecordLength(IOUtil.readUnsignedInt(in)).setDataRecord(IOUtil.readUnsignedInt(in)).setCrypticValue(IOUtil.readUnsignedInt(in));
                Object record = builder.build();
                if (isAb1ChromatogramVisitor) {
                    AbiChromatogramParser.visitCorrectTaggedDataRecordViaReflection((AbiChromatogramFileVisitor)visitor, record, abiDataBlock);
                }
                map.add((TaggedDataRecord<?, ?>)record);
            }
        }
        catch (IOException e) {
            throw new IOException("could parse not tagged data record", e);
        }
        return map;
    }

    private static void visitCorrectTaggedDataRecordViaReflection(AbiChromatogramFileVisitor visitor, TaggedDataRecord<?, ?> record, byte[] abiDataBlock) {
        try {
            Method method = visitor.getClass().getMethod("visitTaggedDataRecord", record.getType(), record.getParsedDataType());
            method.invoke((Object)visitor, record, record.parseDataRecordFrom(abiDataBlock));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not visit tagged data record " + record, e);
        }
    }

    private static byte[] parseTraceDataBlock(InputStream in, int lengthOfDataBlock) throws IOException {
        try {
            return IOUtil.toByteArray(in, lengthOfDataBlock);
        }
        catch (IOException e) {
            throw new IOException("could not parse trace data block", e);
        }
    }

    private static int parseTaggedRecordOffset(InputStream in) throws IOException {
        try {
            IOUtil.blockingSkip(in, 4L);
            return (int)IOUtil.readUnsignedInt(in);
        }
        catch (IOException e) {
            throw new IOException("could not parse number of tagged records", e);
        }
    }

    private static long parseNumTaggedRecords(InputStream in) throws IOException {
        try {
            IOUtil.blockingSkip(in, 14L);
            return IOUtil.readUnsignedInt(in);
        }
        catch (IOException e) {
            throw new IOException("could not parse number of tagged records", e);
        }
    }

    private static void verifyMagicNumber(InputStream in) throws IOException {
        try {
            byte[] magicNumber = IOUtil.toByteArray(in, 4);
            if (!AbiUtil.isABIMagicNumber(magicNumber)) {
                throw new IOException("magic number does not match AB1 format " + Arrays.toString(magicNumber));
            }
        }
        catch (IOException e) {
            throw new IOException("could not read magic number", e);
        }
    }

    private static final class InputStreamChromatogramParser
    extends AbiChromatogramParser {
        private final InputStream in;
        private volatile boolean readAlready = false;

        public InputStreamChromatogramParser(InputStream in) {
            if (in == null) {
                throw new NullPointerException("inputstream can not be null");
            }
            this.in = in;
        }

        @Override
        public synchronized void accept(ChromatogramFileVisitor visitor) throws IOException {
            if (this.readAlready) {
                throw new IllegalStateException("already parsed inputstream");
            }
            this.readAlready = true;
            AbiChromatogramParser.parse(this.in, visitor);
        }
    }

    private static final class AbiFileChromatogramParser
    extends AbiChromatogramParser {
        private final File abiFile;

        public AbiFileChromatogramParser(File abiFile) {
            if (abiFile == null) {
                throw new NullPointerException("abi file can not be null");
            }
            this.abiFile = abiFile;
        }

        @Override
        public void accept(ChromatogramFileVisitor visitor) throws IOException {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.abiFile));
            try {
                AbiChromatogramParser.parse(in, visitor);
            }
            finally {
                IOUtil.closeAndIgnoreErrors((Closeable)in);
            }
        }
    }

    private static enum ShortTaggedDataRecordPropertyHandler {
        LANE(TaggedDataName.LANE, "LANE"),
        LASER_POWER(TaggedDataName.LASER_POWER, "LsrP"),
        B1Pt(TaggedDataName.B1Pt, "B1Pt"),
        Scan(TaggedDataName.Scan, "Scan"),
        LENGTH_OF_DETECTOR(TaggedDataName.LENGTH_TO_DETECTOR, "LNTD"),
        JTC_START_POINT(TaggedDataName.ANALYSIS_START_SCAN_POINT, "ASPT"),
        JTC_END_POINT(TaggedDataName.ANALYSIS_ENDING_SCAN_POINT, "AEPT");

        private final TaggedDataName dataName;
        private final String propertyKey;

        private ShortTaggedDataRecordPropertyHandler(TaggedDataName dataName, String propertyKey) {
            this.dataName = dataName;
            this.propertyKey = propertyKey;
        }

        void handle(Map<TaggedDataName, TaggedDataRecords<ShortArrayTaggedDataRecord>> map, byte[] traceData, Map<String, String> props) {
            TaggedDataRecords<ShortArrayTaggedDataRecord> records = map.get((Object)this.dataName);
            if (records != null && records.size() > 0) {
                Optional<ShortArrayTaggedDataRecord> originalVersion = records.getOriginalVersion();
                if (originalVersion.isPresent()) {
                    props.put(this.propertyKey, Short.toString(((short[])originalVersion.get().parseDataRecordFrom(traceData))[0]));
                } else {
                    props.put(this.propertyKey, Short.toString(((short[])records.get(0).parseDataRecordFrom(traceData))[0]));
                }
            }
        }
    }

    private static class SignalScalingFactor {
        private short aScale = (short)-1;
        private short cScale = (short)-1;
        private short gScale = (short)-1;
        private short tScale = (short)-1;

        private SignalScalingFactor() {
        }

        static SignalScalingFactor create(List<Nucleotide> channelOrder, List<Short> scalingFactors) {
            SignalScalingFactor sf = new SignalScalingFactor();
            Iterator<Short> scaleIterator = scalingFactors.iterator();
            block5: for (Nucleotide channel : channelOrder) {
                short scale = scaleIterator.next();
                switch (channel) {
                    case Adenine: {
                        sf.aScale = scale;
                        continue block5;
                    }
                    case Cytosine: {
                        sf.cScale = scale;
                        continue block5;
                    }
                    case Guanine: {
                        sf.gScale = scale;
                        continue block5;
                    }
                }
                sf.tScale = scale;
            }
            return sf;
        }

        public String toString() {
            return String.format("A:%d,C:%d,G:%d,T:%d", this.aScale, this.cScale, this.gScale, this.tScale);
        }
    }

    private static class Noise {
        private float aNoise;
        private float cNoise;
        private float gNoise;
        private float tNoise;

        private Noise() {
        }

        static Noise create(List<Nucleotide> channelOrder, float[] noise) {
            Noise n = new Noise();
            int i = 0;
            for (Nucleotide channel : channelOrder) {
                switch (channel) {
                    case Adenine: {
                        n.aNoise = noise[i];
                        break;
                    }
                    case Cytosine: {
                        n.cNoise = noise[i];
                        break;
                    }
                    case Guanine: {
                        n.gNoise = noise[i];
                        break;
                    }
                    default: {
                        n.tNoise = noise[i];
                    }
                }
                ++i;
            }
            return n;
        }

        public String toString() {
            return String.format("A:%f,C:%f,G:%f,T:%f", Float.valueOf(this.aNoise), Float.valueOf(this.cNoise), Float.valueOf(this.gNoise), Float.valueOf(this.tNoise));
        }
    }

    private static class GroupedTaggedRecords {
        private final Map<TaggedDataName, TaggedDataRecords<AsciiTaggedDataRecord>> asciiDataRecords = new EnumMap<TaggedDataName, TaggedDataRecords<AsciiTaggedDataRecord>>(TaggedDataName.class);
        private final Map<TaggedDataName, TaggedDataRecords<FloatArrayTaggedDataRecord>> floatDataRecords = new EnumMap<TaggedDataName, TaggedDataRecords<FloatArrayTaggedDataRecord>>(TaggedDataName.class);
        private final Map<TaggedDataName, TaggedDataRecords<ByteArrayTaggedDataRecord>> byteArrayRecords = new EnumMap<TaggedDataName, TaggedDataRecords<ByteArrayTaggedDataRecord>>(TaggedDataName.class);
        private final Map<TaggedDataName, TaggedDataRecords<ShortArrayTaggedDataRecord>> shortArrayDataRecords = new EnumMap<TaggedDataName, TaggedDataRecords<ShortArrayTaggedDataRecord>>(TaggedDataName.class);
        private final Map<TaggedDataName, TaggedDataRecords<IntArrayTaggedDataRecord>> intArrayDataRecords = new EnumMap<TaggedDataName, TaggedDataRecords<IntArrayTaggedDataRecord>>(TaggedDataName.class);
        private final Map<TaggedDataName, TaggedDataRecords<PascalStringTaggedDataRecord>> pascalStringDataRecords = new EnumMap<TaggedDataName, TaggedDataRecords<PascalStringTaggedDataRecord>>(TaggedDataName.class);
        private final Map<TaggedDataName, TaggedDataRecords<DateTaggedDataRecord>> dateDataRecords = new EnumMap<TaggedDataName, TaggedDataRecords<DateTaggedDataRecord>>(TaggedDataName.class);
        private final Map<TaggedDataName, TaggedDataRecords<TimeTaggedDataRecord>> timeDataRecords = new EnumMap<TaggedDataName, TaggedDataRecords<TimeTaggedDataRecord>>(TaggedDataName.class);
        private final Map<TaggedDataName, TaggedDataRecords<UserDefinedTaggedDataRecord<?, ?>>> userDefinedDataRecords = new EnumMap(TaggedDataName.class);

        private GroupedTaggedRecords() {
        }

        public void add(TaggedDataRecord<?, ?> record) {
            switch (record.getDataType()) {
                case DATE: {
                    this.add(record, this.dateDataRecords);
                    break;
                }
                case FLOAT: {
                    this.add(record, this.floatDataRecords);
                    break;
                }
                case INTEGER: {
                    if (record instanceof DefaultShortArrayTaggedDataRecord) {
                        this.add(record, this.shortArrayDataRecords);
                        break;
                    }
                    this.add(record, this.intArrayDataRecords);
                    break;
                }
                case PASCAL_STRING: {
                    this.add(record, this.pascalStringDataRecords);
                    break;
                }
                case TIME: {
                    this.add(record, this.timeDataRecords);
                    break;
                }
                case USER_DEFINED: {
                    this.add(record, this.userDefinedDataRecords);
                    break;
                }
                default: {
                    if (record instanceof StringTaggedDataRecord) {
                        this.add(record, this.asciiDataRecords);
                        break;
                    }
                    this.add(record, this.byteArrayRecords);
                }
            }
        }

        private <T extends TaggedDataRecord<?, ?>> void add(TaggedDataRecord<?, ?> record, Map<TaggedDataName, TaggedDataRecords<T>> map) {
            TaggedDataName name = record.getTagName();
            if (!map.containsKey((Object)name)) {
                map.put(name, new TaggedDataRecords());
            }
            map.get((Object)name).add(record);
        }
    }

    public static class TaggedDataRecords<T extends TaggedDataRecord>
    implements Iterable<T> {
        private final List<T> data;

        public TaggedDataRecords() {
            this(new ArrayList());
        }

        public TaggedDataRecords(List<T> data) {
            this.data = Objects.requireNonNull(data);
        }

        public int size() {
            return this.data.size();
        }

        public T get(int i) {
            return (T)((TaggedDataRecord)this.data.get(i));
        }

        public void add(T record) {
            this.data.add(record);
        }

        public Optional<T> getCurrentVersion() {
            for (TaggedDataRecord t : this.data) {
                if (t.getTagNumber() != 1L) continue;
                return Optional.of(t);
            }
            return Optional.empty();
        }

        public Optional<T> getOriginalVersion() {
            for (TaggedDataRecord t : this.data) {
                if (t.getTagNumber() != 2L) continue;
                return Optional.of(t);
            }
            return Optional.empty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.data.iterator();
        }
    }
}

