/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.chromat.abi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jcvi.jillion.core.pos.PositionSequence;
import org.jcvi.jillion.core.pos.PositionSequenceBuilder;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.internal.trace.chromat.BasicChromatogramBuilder;
import org.jcvi.jillion.trace.chromat.ChannelGroup;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.abi.AbiChromatogram;
import org.jcvi.jillion.trace.chromat.abi.AbiChromatogramFileVisitor;
import org.jcvi.jillion.trace.chromat.abi.AbiChromatogramParser;
import org.jcvi.jillion.trace.chromat.abi.tag.Ab1LocalDate;
import org.jcvi.jillion.trace.chromat.abi.tag.Ab1LocalTime;
import org.jcvi.jillion.trace.chromat.abi.tag.ByteArrayTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.DateTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.FloatArrayTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.IntArrayTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.ShortArrayTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.StringTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.TimeTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.UserDefinedTaggedDataRecord;
import org.jcvi.jillion.trace.chromat.abi.tag.rate.ScanRate;
import org.jcvi.jillion.trace.chromat.abi.tag.rate.ScanRateTaggedDataType;

public class AbiChromatogramBuilder
implements Builder<AbiChromatogram> {
    private final BasicChromatogramBuilder currentBuilder;
    private final BasicChromatogramBuilder originalBuilder;
    private String id;

    public AbiChromatogramBuilder(String id) {
        this.currentBuilder = new BasicChromatogramBuilder(id);
        this.originalBuilder = new BasicChromatogramBuilder(id);
        this.id = id;
    }

    public AbiChromatogramBuilder(String id, File abiFile) throws IOException {
        AbiChromatogramBuilderVisitor visitor = new AbiChromatogramBuilderVisitor(id);
        AbiChromatogramParser.create(abiFile).accept(visitor);
        this.currentBuilder = visitor.currentBuilder;
        this.originalBuilder = visitor.originalBuilder;
        this.id = id;
    }

    public AbiChromatogramBuilder(String id, InputStream abiFileStream) throws IOException {
        AbiChromatogramBuilderVisitor visitor = new AbiChromatogramBuilderVisitor(id);
        AbiChromatogramParser.create(abiFileStream).accept(visitor);
        this.currentBuilder = visitor.currentBuilder;
        this.originalBuilder = visitor.originalBuilder;
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public AbiChromatogramBuilder id(String id) {
        this.id = id;
        this.currentBuilder.id(id);
        this.originalBuilder.id(id);
        return this;
    }

    public final PositionSequence peaks() {
        return this.currentBuilder.peaks();
    }

    public AbiChromatogramBuilder peaks(short[] peaks) {
        this.currentBuilder.peaks(new PositionSequenceBuilder(peaks).build());
        return this;
    }

    public final NucleotideSequence basecalls() {
        return this.currentBuilder.basecalls();
    }

    public AbiChromatogramBuilder basecalls(NucleotideSequence basecalls) {
        this.currentBuilder.basecalls(basecalls);
        return this;
    }

    public final byte[] aQualities() {
        return this.currentBuilder.aQualities();
    }

    public final AbiChromatogramBuilder aQualities(byte[] qualities) {
        this.currentBuilder.aQualities(qualities);
        return this;
    }

    public final byte[] cQualities() {
        return this.currentBuilder.cQualities();
    }

    public final AbiChromatogramBuilder cQualities(byte[] qualities) {
        this.currentBuilder.cQualities(qualities);
        return this;
    }

    public final byte[] gQualities() {
        return this.currentBuilder.gQualities();
    }

    public final AbiChromatogramBuilder gQualities(byte[] qualities) {
        this.currentBuilder.gQualities(qualities);
        return this;
    }

    public final byte[] tQualities() {
        return this.currentBuilder.tQualities();
    }

    public final AbiChromatogramBuilder tQualities(byte[] qualities) {
        this.currentBuilder.tQualities(qualities);
        return this;
    }

    public final short[] aPositions() {
        return this.currentBuilder.aPositions();
    }

    public final AbiChromatogramBuilder aPositions(short[] positions) {
        this.currentBuilder.aPositions(positions);
        return this;
    }

    public final short[] cPositions() {
        return this.currentBuilder.cPositions();
    }

    public final AbiChromatogramBuilder cPositions(short[] positions) {
        this.currentBuilder.cPositions(positions);
        return this;
    }

    public final short[] gPositions() {
        return this.currentBuilder.gPositions();
    }

    public final AbiChromatogramBuilder gPositions(short[] positions) {
        this.currentBuilder.gPositions(positions);
        return this;
    }

    public final short[] tPositions() {
        return this.currentBuilder.tPositions();
    }

    public final AbiChromatogramBuilder tPositions(short[] positions) {
        this.currentBuilder.tPositions(positions);
        return this;
    }

    public final Map<String, String> comments() {
        return this.currentBuilder.comments();
    }

    public final AbiChromatogramBuilder comments(Map<String, String> comments) {
        this.currentBuilder.comments(comments);
        return this;
    }

    public AbiChromatogramBuilder originalPeaks(short[] peaks) {
        this.originalBuilder.peaks(new PositionSequenceBuilder(peaks).build());
        return this;
    }

    public final NucleotideSequence originalBasecalls() {
        return this.originalBuilder.basecalls();
    }

    public AbiChromatogramBuilder originalBasecalls(NucleotideSequence basecalls) {
        this.originalBuilder.basecalls(basecalls);
        return this;
    }

    public final byte[] originalAQualities() {
        return this.originalBuilder.aQualities();
    }

    public final AbiChromatogramBuilder originalAQualities(byte[] qualities) {
        this.originalBuilder.aQualities(qualities);
        return this;
    }

    public final byte[] originalCQualities() {
        return this.originalBuilder.cQualities();
    }

    public final AbiChromatogramBuilder originalCQualities(byte[] qualities) {
        this.originalBuilder.cQualities(qualities);
        return this;
    }

    public final byte[] originalGQualities() {
        return this.originalBuilder.gQualities();
    }

    public final AbiChromatogramBuilder originalGQualities(byte[] qualities) {
        this.originalBuilder.gQualities(qualities);
        return this;
    }

    public final byte[] originalTQualities() {
        return this.originalBuilder.tQualities();
    }

    public final AbiChromatogramBuilder originalTQualities(byte[] qualities) {
        this.originalBuilder.tQualities(qualities);
        return this;
    }

    public final short[] originalAPositions() {
        return this.originalBuilder.aPositions();
    }

    public final AbiChromatogramBuilder originalAPositions(short[] positions) {
        this.originalBuilder.aPositions(positions);
        return this;
    }

    public final short[] originalCPositions() {
        return this.originalBuilder.cPositions();
    }

    public final AbiChromatogramBuilder originalCPositions(short[] positions) {
        this.originalBuilder.cPositions(positions);
        return this;
    }

    public final short[] originalGPositions() {
        return this.originalBuilder.gPositions();
    }

    public final AbiChromatogramBuilder originalGPositions(short[] positions) {
        this.originalBuilder.gPositions(positions);
        return this;
    }

    public final short[] originalTPositions() {
        return this.originalBuilder.tPositions();
    }

    public final AbiChromatogramBuilder originalTPositions(short[] positions) {
        this.originalBuilder.tPositions(positions);
        return this;
    }

    public final Map<String, String> originalComments() {
        return this.originalBuilder.comments();
    }

    public final AbiChromatogramBuilder originalComments(Map<String, String> comments) {
        this.originalBuilder.comments(comments);
        return this;
    }

    @Override
    public AbiChromatogram build() {
        return new AbiChromatogramImp(this.id, this.currentBuilder.build(), this.originalBuilder.build());
    }

    public static class AbiChromatogramBuilderVisitor
    implements AbiChromatogramFileVisitor {
        private final BasicChromatogramBuilder currentBuilder;
        private final BasicChromatogramBuilder originalBuilder;

        public AbiChromatogramBuilderVisitor(String id) {
            this.currentBuilder = new BasicChromatogramBuilder(id);
            this.originalBuilder = new BasicChromatogramBuilder(id);
        }

        @Override
        public void visitAPositions(short[] positions) {
            this.currentBuilder.aPositions(positions);
        }

        @Override
        public void visitCPositions(short[] positions) {
            this.currentBuilder.cPositions(positions);
        }

        @Override
        public void visitGPositions(short[] positions) {
            this.currentBuilder.gPositions(positions);
        }

        @Override
        public void visitTPositions(short[] positions) {
            this.currentBuilder.tPositions(positions);
        }

        @Override
        public void visitAConfidence(byte[] confidence) {
            this.currentBuilder.aQualities(confidence);
        }

        @Override
        public void visitCConfidence(byte[] confidence) {
            this.currentBuilder.cQualities(confidence);
        }

        @Override
        public void visitGConfidence(byte[] confidence) {
            this.currentBuilder.gQualities(confidence);
        }

        @Override
        public void visitTConfidence(byte[] confidence) {
            this.currentBuilder.tQualities(confidence);
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visitBasecalls(NucleotideSequence basecalls) {
            this.currentBuilder.basecalls(basecalls);
        }

        @Override
        public void visitPeaks(short[] peaks) {
            this.currentBuilder.peaks(new PositionSequenceBuilder(peaks).build());
        }

        @Override
        public void visitComments(Map<String, String> comments) {
            this.currentBuilder.comments(comments);
            this.originalBuilder.comments(comments);
        }

        @Override
        public void visitOriginalBasecalls(NucleotideSequence originalBasecalls) {
            this.originalBuilder.basecalls(originalBasecalls);
        }

        @Override
        public void visitChannelOrder(List<Nucleotide> order) {
        }

        @Override
        public void visitPhotometricData(short[] rawTraceData, int opticalFilterId) {
        }

        @Override
        public void visitGelVoltageData(short[] gelVoltage) {
        }

        @Override
        public void visitGelCurrentData(short[] gelCurrent) {
        }

        @Override
        public void visitElectrophoreticPower(short[] electrophoreticPowerData) {
        }

        @Override
        public void visitGelTemperatureData(short[] gelTemp) {
        }

        @Override
        public void visitOriginalPeaks(short[] originalPeaks) {
            this.originalBuilder.peaks(new PositionSequenceBuilder(originalPeaks).build());
        }

        @Override
        public void visitOriginalAConfidence(byte[] originalConfidence) {
            this.originalBuilder.aQualities(originalConfidence);
        }

        @Override
        public void visitOriginalCConfidence(byte[] originalConfidence) {
            this.originalBuilder.cQualities(originalConfidence);
        }

        @Override
        public void visitOriginalGConfidence(byte[] originalConfidence) {
            this.originalBuilder.gQualities(originalConfidence);
        }

        @Override
        public void visitOriginalTConfidence(byte[] originalConfidence) {
            this.originalBuilder.tQualities(originalConfidence);
        }

        @Override
        public void visitScaleFactors(short aScale, short cScale, short gScale, short tScale) {
        }

        @Override
        public void visitTaggedDataRecord(ByteArrayTaggedDataRecord record, byte[] data) {
        }

        @Override
        public void visitTaggedDataRecord(UserDefinedTaggedDataRecord<?, ?> record, byte[] data) {
        }

        @Override
        public void visitTaggedDataRecord(ScanRateTaggedDataType record, ScanRate scanRate) {
        }

        @Override
        public void visitTaggedDataRecord(ShortArrayTaggedDataRecord record, short[] data) {
        }

        @Override
        public void visitTaggedDataRecord(IntArrayTaggedDataRecord record, int[] data) {
        }

        @Override
        public void visitTaggedDataRecord(FloatArrayTaggedDataRecord record, float[] data) {
        }

        @Override
        public void visitTaggedDataRecord(StringTaggedDataRecord record, String data) {
        }

        @Override
        public void visitTaggedDataRecord(TimeTaggedDataRecord record, Ab1LocalTime time) {
        }

        @Override
        public void visitTaggedDataRecord(DateTaggedDataRecord record, Ab1LocalDate date) {
        }
    }

    private static class AbiChromatogramImp
    implements AbiChromatogram {
        private final Chromatogram delegate;
        private final Chromatogram originalChromatogram;
        private final String id;

        public AbiChromatogramImp(String id, Chromatogram delegate, Chromatogram originalChromatogram) {
            this.id = id;
            this.delegate = delegate;
            this.originalChromatogram = originalChromatogram;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Chromatogram getOriginalChromatogram() {
            return this.originalChromatogram;
        }

        @Override
        public ChannelGroup getChannelGroup() {
            return this.delegate.getChannelGroup();
        }

        @Override
        public Map<String, String> getComments() {
            return this.delegate.getComments();
        }

        @Override
        public int getNumberOfTracePositions() {
            return this.delegate.getNumberOfTracePositions();
        }

        @Override
        public NucleotideSequence getNucleotideSequence() {
            return this.delegate.getNucleotideSequence();
        }

        @Override
        public QualitySequence getQualitySequence() {
            return this.delegate.getQualitySequence();
        }

        @Override
        public PositionSequence getPeakSequence() {
            return this.delegate.getPeakSequence();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.delegate.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AbiChromatogramImp)) {
                return false;
            }
            AbiChromatogramImp other = (AbiChromatogramImp)obj;
            return this.delegate.equals(other.delegate);
        }
    }
}

