/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.chromat;

import java.util.Arrays;

final class EncodedShortData {
    private short[] data;

    private static short[] decodeData(String encodedData) {
        if (encodedData == null) {
            return null;
        }
        int i = 0;
        String[] dataValues = encodedData.split(",\\s*");
        short[] result = new short[dataValues.length];
        for (String datum : dataValues) {
            short value = Short.parseShort(datum);
            result[i++] = value;
        }
        return result;
    }

    public EncodedShortData(short[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data can not be null");
        }
        this.data = Arrays.copyOf(data, data.length);
    }

    public EncodedShortData(String encodedData) {
        this(EncodedShortData.decodeData(encodedData));
    }

    public short[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public String encodeData() {
        String encodedData = Arrays.toString(this.data);
        return encodedData.replaceAll("\\[|\\]", "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EncodedShortData)) {
            return false;
        }
        EncodedShortData other = (EncodedShortData)obj;
        return Arrays.equals(this.data, other.data);
    }
}

