/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.trace.chromat;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jcvi.jillion.core.io.FileUtil;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.core.io.MagicNumberInputStream;
import org.jcvi.jillion.internal.trace.chromat.abi.AbiUtil;
import org.jcvi.jillion.internal.trace.chromat.scf.SCFUtils;
import org.jcvi.jillion.internal.trace.chromat.ztr.ZTRUtil;
import org.jcvi.jillion.trace.chromat.Chromatogram;
import org.jcvi.jillion.trace.chromat.abi.AbiChromatogramBuilder;
import org.jcvi.jillion.trace.chromat.scf.ScfChromatogramBuilder;
import org.jcvi.jillion.trace.chromat.ztr.ZtrChromatogramBuilder;

public final class ChromatogramFactory {
    private ChromatogramFactory() {
    }

    public static Chromatogram create(File chromatogramFile) throws IOException {
        if (chromatogramFile == null) {
            throw new NullPointerException("file can not be null");
        }
        String id = FileUtil.getBaseName(chromatogramFile);
        return ChromatogramFactory.create(id, chromatogramFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Chromatogram create(String id, File chromatogramFile) throws IOException {
        Chromatogram chromatogram;
        MagicNumberInputStream mIn = null;
        try {
            mIn = new MagicNumberInputStream(chromatogramFile);
            chromatogram = ChromatogramFactory.createCorrectTypeOfChromatogram(mIn, id);
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(mIn);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)mIn);
        return chromatogram;
    }

    public static Chromatogram create(String id, InputStream in) throws IOException {
        MagicNumberInputStream mIn = new MagicNumberInputStream(in);
        return ChromatogramFactory.createCorrectTypeOfChromatogram(mIn, id);
    }

    private static Chromatogram createCorrectTypeOfChromatogram(MagicNumberInputStream mIn, String id) throws IOException, FileNotFoundException, IOException {
        byte[] magicNumber = mIn.peekMagicNumber();
        if (AbiUtil.isABIMagicNumber(magicNumber)) {
            return new AbiChromatogramBuilder(id, mIn).build();
        }
        if (ZTRUtil.isMagicNumber(magicNumber)) {
            return new ZtrChromatogramBuilder(id, mIn).build();
        }
        if (SCFUtils.isMagicNumber(magicNumber)) {
            return new ScfChromatogramBuilder(id, mIn).build();
        }
        throw new IOException("unknown chromatogram format (not ab1, scf or ztr)");
    }
}

