/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.testutils.assembly.cas;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.PeekableIterator;
import org.jcvi.jillion.testutils.NucleotideSequenceTestUtil;
import org.jcvi.jillion.testutils.assembly.cas.RecordWriter;
import org.jcvi.jillion.trace.sff.SffReadData;
import org.jcvi.jillion.trace.sff.SffReadHeader;
import org.jcvi.jillion.trace.sff.SffWriter;
import org.jcvi.jillion.trace.sff.SffWriterBuilder;

public final class SffRecordWriter
implements RecordWriter {
    private static final Range NO_CLIP = Range.of(Range.CoordinateSystem.RESIDUE_BASED, 0L, 0L);
    private final File sffFile;
    private final SffWriter writer;
    private final int maxNumberOfRecordsToWrite;
    private final NucleotideSequence flowSequence;
    private int counter = 0;
    private final int flowLength;

    private SffRecordWriter(Builder builder) throws IOException {
        this.maxNumberOfRecordsToWrite = builder.maxNumberOfRecordsToWrite;
        this.flowSequence = builder.flowSequence;
        this.sffFile = builder.sffFile;
        this.flowLength = builder.flowLength;
        this.writer = new SffWriterBuilder(this.sffFile, builder.keySequence, this.flowSequence).build();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private Nucleotide convertToACGT(Nucleotide n) {
        switch (n) {
            case Adenine: 
            case Cytosine: 
            case Guanine: {
                return n;
            }
        }
        return Nucleotide.Thymine;
    }

    public void write(String id, NucleotideSequence seq, QualitySequence qualSeq) throws IOException {
        this.write(id, seq, qualSeq, NO_CLIP, NO_CLIP);
    }

    public void write(final String id, final NucleotideSequence seq, final QualitySequence qualSeq, final Range qualClip, final Range adapterClip) throws IOException {
        if (!this.canWriteAnotherRecord()) {
            throw new IllegalStateException("too many records to write");
        }
        ++this.counter;
        SffReadHeader header = new SffReadHeader(){

            @Override
            public Range getQualityClip() {
                return qualClip;
            }

            @Override
            public int getNumberOfBases() {
                return (int)seq.getLength();
            }

            @Override
            public String getId() {
                return id;
            }

            @Override
            public Range getAdapterClip() {
                return adapterClip;
            }
        };
        int length = (int)seq.getLength();
        final short[] flowgrams = new short[this.flowLength];
        final byte[] flowIndexes = new byte[length];
        PeekableIterator flowIter = IteratorUtil.createPeekableIterator(this.flowSequence.iterator());
        PeekableIterator seqIter = IteratorUtil.createPeekableIterator(seq.iterator());
        int currentFlowgramIndex = 0;
        int currentIndex = 0;
        while (seqIter.hasNext()) {
            Nucleotide s;
            int homopolymerCount = 0;
            do {
                ++homopolymerCount;
                s = this.convertToACGT((Nucleotide)seqIter.next());
            } while (seqIter.hasNext() && s == this.convertToACGT((Nucleotide)seqIter.peek()));
            int flowIndexCount = 0;
            do {
                flowIndexCount = (byte)(flowIndexCount + 1);
                ++currentFlowgramIndex;
            } while (flowIter.hasNext() && s != flowIter.next());
            flowgrams[currentFlowgramIndex - 1] = (short)(homopolymerCount * 100);
            flowIndexes[currentIndex] = flowIndexCount;
            ++currentIndex;
        }
        SffReadData data = new SffReadData(){

            @Override
            public QualitySequence getQualitySequence() {
                return qualSeq;
            }

            @Override
            public NucleotideSequence getNucleotideSequence() {
                return seq;
            }

            @Override
            public short[] getFlowgramValues() {
                return Arrays.copyOf(flowgrams, SffRecordWriter.this.flowLength);
            }

            @Override
            public byte[] getFlowIndexPerBase() {
                return Arrays.copyOf(flowIndexes, flowIndexes.length);
            }
        };
        this.writer.write(header, data);
    }

    @Override
    public void write(String id, NucleotideSequence seq) throws IOException {
        int length = (int)seq.getLength();
        QualitySequenceBuilder quals = new QualitySequenceBuilder(length);
        for (int i = 0; i < length; ++i) {
            quals.append(RecordWriter.DEFAULT_QV);
        }
        QualitySequence qualSeq = quals.build();
        this.write(id, seq, qualSeq);
    }

    @Override
    public boolean canWriteAnotherRecord() {
        return this.counter < this.maxNumberOfRecordsToWrite;
    }

    @Override
    public File getFile() {
        return this.sffFile;
    }

    public static final class Builder {
        private static final NucleotideSequence KEY_SEQUENCE = NucleotideSequenceTestUtil.create("ACGT");
        private File sffFile;
        private int maxNumberOfRecordsToWrite = Integer.MAX_VALUE;
        private NucleotideSequence flowSequence = null;
        private NucleotideSequence keySequence = KEY_SEQUENCE;
        private int flowLength = 400;

        public Builder(File workingDir) throws IOException {
            this.sffFile = File.createTempFile("reads", ".sff", workingDir);
        }

        public Builder(File workingDir, String filename) throws IOException {
            this.sffFile = new File(workingDir, filename);
        }

        public Builder flowLength(int flowLength) {
            if (flowLength % 4 != 0) {
                throw new IllegalArgumentException("flow length must be divisible by 4");
            }
            this.flowLength = flowLength;
            return this;
        }

        public Builder maxRecordsToWrite(int maxRecordsToWrite) {
            if (maxRecordsToWrite < 1) {
                throw new IllegalArgumentException("max records can not < 1");
            }
            this.maxNumberOfRecordsToWrite = maxRecordsToWrite;
            return this;
        }

        public Builder flowSequence(NucleotideSequence seq) {
            Objects.requireNonNull(seq);
            this.flowSequence = seq;
            this.keySequence = new NucleotideSequenceBuilder(seq, Range.ofLength(4L)).build();
            return this;
        }

        public SffRecordWriter build() throws IOException {
            if (this.flowSequence == null) {
                NucleotideSequenceBuilder flowSequenceBuilder = new NucleotideSequenceBuilder(this.flowLength);
                int flowGroups = this.flowLength / 4;
                for (int i = 0; i < flowGroups; ++i) {
                    flowSequenceBuilder.append(KEY_SEQUENCE);
                }
                this.flowSequence = flowSequenceBuilder.build();
            }
            return new SffRecordWriter(this);
        }
    }
}

