/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.testutils.assembly.cas;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.testutils.assembly.cas.RecordWriter;
import org.jcvi.jillion.trace.fastq.FastqWriter;
import org.jcvi.jillion.trace.fastq.FastqWriterBuilder;

public final class FastqRecordWriter
implements RecordWriter {
    private final FastqWriter writer;
    private final File fastqFile;
    private final int maxNumberOfRecordsToWrite;
    private int counter = 0;

    public FastqRecordWriter(File workingDir) throws IOException {
        this(workingDir, Integer.MAX_VALUE);
    }

    public FastqRecordWriter(File workingDir, int maxRecordsToWrite) throws IOException {
        if (maxRecordsToWrite < 1) {
            throw new IllegalArgumentException("max records can not < 1");
        }
        this.fastqFile = File.createTempFile("reads", ".fastq", workingDir);
        this.writer = new FastqWriterBuilder(this.fastqFile).build();
        this.maxNumberOfRecordsToWrite = maxRecordsToWrite;
    }

    public FastqRecordWriter(File workingDir, String filename, int maxRecordsToWrite) throws IOException {
        if (maxRecordsToWrite < 1) {
            throw new IllegalArgumentException("max records can not < 1");
        }
        this.fastqFile = new File(workingDir, filename);
        this.writer = new FastqWriterBuilder(this.fastqFile).build();
        this.maxNumberOfRecordsToWrite = maxRecordsToWrite;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void write(String id, NucleotideSequence seq) throws IOException {
        QualitySequence quals;
        if (!this.canWriteAnotherRecord()) {
            throw new IllegalStateException("too many records to write");
        }
        ++this.counter;
        int length = (int)seq.getLength();
        if (length == 0) {
            quals = new QualitySequenceBuilder(0).build();
        } else {
            QualitySequenceBuilder builder = new QualitySequenceBuilder(length);
            for (int i = 0; i < length; ++i) {
                builder.append(RecordWriter.DEFAULT_QV);
            }
            quals = builder.build();
        }
        this.writer.write(id, seq, quals);
    }

    @Override
    public boolean canWriteAnotherRecord() {
        return this.counter != this.maxNumberOfRecordsToWrite;
    }

    @Override
    public File getFile() {
        return this.fastqFile;
    }
}

