/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.testutils.assembly.cas;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.fasta.nt.NucleotideFastaWriter;
import org.jcvi.jillion.fasta.nt.NucleotideFastaWriterBuilder;
import org.jcvi.jillion.testutils.assembly.cas.RecordWriter;

public final class FastaRecordWriter
implements RecordWriter {
    private final NucleotideFastaWriter writer;
    private final File fastaFile;
    private final int maxNumberOfRecordsToWrite;
    private int counter = 0;

    public FastaRecordWriter(File workingDir) throws IOException {
        this(workingDir, Integer.MAX_VALUE);
    }

    public FastaRecordWriter(File workingDir, int maxRecordsToWrite) throws IOException {
        if (maxRecordsToWrite < 1) {
            throw new IllegalArgumentException("max records can not < 1");
        }
        this.fastaFile = File.createTempFile("reads", ".fasta", workingDir);
        this.writer = new NucleotideFastaWriterBuilder(this.fastaFile).build();
        this.maxNumberOfRecordsToWrite = maxRecordsToWrite;
    }

    public FastaRecordWriter(File workingDir, String filename, int maxRecordsToWrite) throws IOException {
        if (maxRecordsToWrite < 1) {
            throw new IllegalArgumentException("max records can not < 1");
        }
        this.fastaFile = new File(workingDir, filename);
        this.writer = new NucleotideFastaWriterBuilder(this.fastaFile).build();
        this.maxNumberOfRecordsToWrite = maxRecordsToWrite;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void write(String id, NucleotideSequence seq) throws IOException {
        if (!this.canWriteAnotherRecord()) {
            throw new IllegalStateException("too many records to write. max records " + this.maxNumberOfRecordsToWrite);
        }
        ++this.counter;
        this.writer.write(id, seq);
    }

    @Override
    public boolean canWriteAnotherRecord() {
        return this.counter != this.maxNumberOfRecordsToWrite;
    }

    @Override
    public File getFile() {
        return this.fastaFile;
    }
}

