/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.testutils.assembly.cas;

import org.jcvi.jillion.assembly.clc.cas.CasAlignmentRegion;
import org.jcvi.jillion.assembly.clc.cas.CasAlignmentRegionType;

final class DefaultCasAlignmentRegion
implements CasAlignmentRegion {
    private final CasAlignmentRegionType type;
    private final long length;

    public DefaultCasAlignmentRegion(CasAlignmentRegionType type, long length) {
        if (type == null) {
            throw new NullPointerException("type can not be null");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length can not < 0 : " + length);
        }
        this.type = type;
        this.length = length;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public CasAlignmentRegionType getType() {
        return this.type;
    }

    public String toString() {
        return "DefaultCasAlignmentRegion [type=" + (Object)((Object)this.type) + ", length=" + this.length + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultCasAlignmentRegion)) {
            return false;
        }
        DefaultCasAlignmentRegion other = (DefaultCasAlignmentRegion)obj;
        if (this.length != other.length) {
            return false;
        }
        return this.type.equals((Object)other.type);
    }
}

